const { exec } = require( 'child_process' );
const { app, BrowserWindow, session, screen, Notification } = require( 'electron' );
const fs = require( "fs" );

process.env.NODE_TLS_REJECT_UNAUTHORIZED = 0;
console.error = () => { };
console.warn = () => { };

var win = null;
app.whenReady().then( () => {
    try {
        session.defaultSession.clearStorageData();
    } catch { }
    const primaryDisplay = screen.getPrimaryDisplay();
    const { width, height } = primaryDisplay.workAreaSize;

    win = new BrowserWindow( {
        show: false,
        backgroundColor: '#fff'
    } );

    win.setSize( width - 150, height - 150, false );
    win.center();
    win.setMenuBarVisibility( false );

    if ( fs.existsSync( "open.url" ) ) {
        var tmp = fs.readFileSync( "open.url" );
        var url = tmp.toString();
        if ( fs.existsSync( "settings.json" ) ) {
            var f = fs.readFileSync( "settings.json" );
            var j = JSON.parse( f );
            for ( item in j ) {
                if ( url.indexOf( j[ item ][ 'node' ] ) != -1 ) {
                    url = url.replace( j[ item ][ 'node' ], j[ item ][ 'map' ] + ":" + j[ item ][ 'port' ] );
                }
            }
        }

        win.loadURL( url );

        fs.unlinkSync( "open.url" );
    } else if ( process.argv[ 2 ] != undefined ) {
        win.loadURL( process.argv[ 2 ] );
    } else {
        if ( fs.existsSync( "nexus.urls" ) ) {
            var list = fs.readFileSync( "nexus.urls" );
            var options = "";
            list.toString().split( "\n" ).forEach( function ( line ) {
                if ( line.trim() != "" ) {
                    options = options + "<option value='" + line.trim() + "'>";
                }
            } );
            var tmpFile = fs.readFileSync( "./resources/app/nexus-tpl.html" );
            tmpFile = tmpFile.toString().replace( "{servers}", options );
            fs.writeFileSync( "./resources/app/nexus.html", tmpFile );
        } else {
            var tmpFile = fs.readFileSync( "./resources/app/nexus-tpl.html" );
            tmpFile = tmpFile.toString().replace( "{servers}", "" );
            fs.writeFileSync( "./resources/app/nexus.html", tmpFile );
        }
        win.loadFile( "nexus.html" );
    }

    win.webContents.on( "did-fail-load", ( event, errorCode, errorDescription ) => {
        win.loadFile( "error.html" );
        setTimeout( () => {
            win.show();
            win.focus();
        }, 1000 );
    } );
    win.on( 'ready-to-show', function () {
        setTimeout( () => {
            win.show();
            win.focus();
        }, 1000 );
        setTimeout( () => {
            try { loadingWindow_main.close(); } catch { }
        }, 1500 );
    } );


    var loadingWindow_main = new BrowserWindow( {
        parent: win,
        width: 600,
        height: 400,
        resizable: false,
        frame: false,
        alwaysOnTop: false,
        hasShadow: true,
        title: "Nexus"
    } );
    loadingWindow_main.loadFile( 'wait.html' );
    loadingWindow_main.show();


    win.on( 'close', ( e ) => {
        try {
            session.defaultSession.clearStorageData();
        } catch { }
    } );

    win.webContents.setWindowOpenHandler( ( { url } ) => {
        fs.writeFileSync( "open.url", url );
        exec( process.argv[ 0 ] );
        return { action: 'deny' }
    } );

    session.defaultSession.webRequest.onBeforeSendHeaders( ( details, callback ) => {
        details.requestHeaders[ 'User-Agent' ] = 'xcware-Nexus';
        callback( { cancel: false, requestHeaders: details.requestHeaders } );
    } );

    session.defaultSession.on( 'will-download', function ( event, downloadItem, webContents ) {
        var loadingWindow = new BrowserWindow( {
            parent: win,
            width: 600,
            height: 400,
            resizable: false,
            frame: false,
            alwaysOnTop: false,
            hasShadow: true,
            title: "Nexus"
        } );
        loadingWindow.loadFile( 'dl.html' );
        loadingWindow.show();

        function showNotification ( text ) {
            new Notification( {
                title: "Nexus",
                body: text,
                icon: __dirname + '/app.ico',
                tag: 'cwareNotification',
                hasReply: false
            } ).show();
        }

        downloadItem.once( 'done', function ( event, state ) {
            if ( state === 'completed' ) {
                showNotification( "Download completed" );
                try { loadingWindow.close(); } catch { }
                setTimeout( () => {
                    try { loadingWindow_main.close(); } catch { }
                }, 1500 );
            } else if ( state === 'cancelled' || state === "interrupted" ) {
                showNotification( "Download cancelled" );
                try { loadingWindow.close(); } catch { }
                setTimeout( () => {
                    try { loadingWindow_main.close(); } catch { }
                }, 1500 );
            }
        } );
    } );
} );

app.on( 'window-all-closed', () => {
    if ( process.platform !== 'darwin' ) {
        app.quit();
    }
} );

app.on( 'certificate-error', ( event, webContents, url, error, certificate, callback ) => {
    callback( true );
    event.preventDefault();
} );