/// variables

var _DELETE_CONFIRM_CODE = { MOBILEDELETE };
var _LIST_ANIMATION = { LISTANIMATION };
var mobile_item_selec = "";
var mobile_last_move = null;
var _tt_TIME = 39;
var _progress_TT = null;
var _CHART_ = null;
var _lcm = { _EXPIRE_MONTH };
var _lcy = { _EXPIRE_YEAR };
var _ST = false;

/// ajax

const ajax = (
    url,
    command,
    data = null,
    success = null,
    error = null,
    progress = null,
    formData = null
) => {
    var x = new XMLHttpRequest();
    x.onreadystatechange = function () {
        if ( x.readyState == 4 && x.status == 200 ) {
            if ( success != null ) {
                if ( x.responseText.trim() != "" ) {
                    if (
                        x.responseText ==
                        '{"result":"ERR", "message":"Session Expired"}'
                    ) {
                        window.location.href =
                            "/c/session".toLowerCase();
                    } else {
                        success( x.responseText );
                    }
                }
            }
        } else if ( x.readyState == 4 && x.status == 210 ) {
            if ( error != null ) {
                if ( x.responseText.trim() != "" ) {
                    if (
                        x.responseText ==
                        '{"result":"ERR", "message":"Session Expired"}'
                    ) {
                        window.location.href =
                            "/c/session".toLowerCase();
                    } else {
                        error( x.responseText );
                    }
                }
            }
        } else if ( x.readyState == 4 && x.status == 505 ) {
            if ( error != null ) {
                if ( x.responseText.trim() != "" ) {
                    error( x.responseText );
                }
            }
        }
    };
    x.upload.onload = () => { };
    x.upload.onerror = () => { };
    x.upload.onabort = () => { };
    x.upload.onprogress = ( event ) => {
        if ( event.lengthComputable ) {
            var percentComplete = parseInt( ( event.loaded / event.total ) * 100 );
            if ( progress != null ) {
                progress( event.total, event.loaded, percentComplete );
            }
        }
    };
    x.open( "POST", url, true );
    if ( formData != null ) {
        x.send( formData );
    } else {
        x.setRequestHeader( "X-API-COMMAND", command );
        x.setRequestHeader( "Content-Type", "application/json; charset=UTF-8;" );
        x.send( data );
    }
};

/// events

window.onload = ( e ) => {
    try {
        //only valid for sessions - ignore on other pages
        addSpinner();
        setTimeout( () => {
            if ( document.querySelectorAll( ".nav-link" ).length != 0 ) {
                list( document.querySelectorAll( ".nav-link" )[ 0 ], "start" );
            }
        }, 500 );
    } catch { }

    document.addEventListener( "contextmenu", ( event ) => {
        event.preventDefault();
        if ( selectedCard() != null ) {
            selectedCard().querySelectorAll( ".btn" )[ 0 ].click();
        }
    } );

    navigation.addEventListener( "navigate", ( event ) => {
        const url = new URL( event.destination.url );
        if ( url.hash.startsWith( "#call" ) ) {
            event.preventDefault();
            do_NodeLinkClick( url.hash );
        }
    } );

    window.onresize = ( e ) => {
        adjustSizing();
    };

    adjustSizing();

    var wt = setInterval( () => {
        var waitspinner = document.getElementById( "waitspinner" );
        if ( waitspinner != null ) {
            if (
                document
                    .getElementById( "cancelButton" )
                    .getAttribute( "disabled" ) != null
            ) {
                waitspinner.style.display = "block";
            } else {
                waitspinner.style.display = "none";
            }
        }
    }, 250 );

    document.addEventListener(
        "keyup",
        ( event ) => {
            //select card up
            if ( event.shiftKey && event.altKey && event.which == 40 ) {
                var ls = document.querySelectorAll( ".card" );
                var found = false;
                for ( var i = 0; i < ls.length; i++ ) {
                    if ( ls[ i ].classList.contains( "selected" ) ) {
                        try {
                            selectCard( ls[ i + 1 ] );
                            found = true;
                        } catch { }
                    }
                }
                if ( !found ) {
                    for ( var i = 0; i < ls.length; i++ ) {
                        if ( i == 2 ) {
                            try {
                                selectCard( ls[ i ] );
                                found = true;
                            } catch { }
                        }
                    }
                }
            }
            //select card down
            if ( event.shiftKey && event.altKey && event.which == 38 ) {
                var ls = document.querySelectorAll( ".card" );
                var found = false;
                for ( var i = ls.length - 1; i > 0; i-- ) {
                    if ( ls[ i ].classList.contains( "selected" ) ) {
                        try {
                            if ( i > 2 ) {
                                selectCard( ls[ i - 1 ] );
                                found = true;
                                break;
                            }
                        } catch { }
                    }
                }
                if ( !found ) {
                    for ( var i = 0; i < ls.length; i++ ) {
                        if ( i == 2 ) {
                            try {
                                selectCard( ls[ i ] );
                                found = true;
                                break;
                            } catch { }
                        }
                    }
                }
            }
            //show module selector
            if ( event.shiftKey && event.altKey && event.which == 37 ) {
                showModuleSelector();
            }
            //show account menu selector
            if ( event.shiftKey && event.altKey && event.which == 65 ) {
                showAccountMenuSelector();
            }
            //show actions menu selector
            if ( event.shiftKey && event.altKey && event.which == 39 ) {
                showActionMenuSelector();
            }
            //jump to search
            if ( event.shiftKey && event.altKey && event.which == 83 ) {
                try { document.getElementById( "searchfor" ).focus(); } catch { }
            }
            //refresh
            if ( event.shiftKey && event.altKey && event.which == 82 ) {
                try { document.getElementById( "reload-button" ).click(); } catch { }
            }
            //open card
            if ( event.shiftKey && event.altKey && event.which == 13 ) {
                var ls = document.querySelectorAll( ".card" );
                for ( var i = ls.length - 1; i > 0; i-- ) {
                    if ( ls[ i ].classList.contains( "selected" ) ) {
                        var event = new MouseEvent( 'dblclick', {
                            'view': window,
                            'bubbles': true,
                            'cancelable': true
                        } );
                        ls[ i ].dispatchEvent( event );
                        break;
                    }
                }
            }
            if ( event.ctrlKey && event.which == 83 ) {
                try {
                    document.getElementById( "okButton" ).click();
                } catch { }
            }
            if ( event.ctrlKey && event.which == 69 ) {
                try {
                    document.getElementById( "quitButton" ).click();
                } catch { }
            }
        }
    );
};

function detectMob () {
    const toMatch = [
        /Android/i,
        /webOS/i,
        /iPhone/i,
        /iPad/i,
        /iPod/i,
        /BlackBerry/i,
        /Windows Phone/i
    ];

    return toMatch.some( ( toMatchItem ) => {
        return navigator.userAgent.match( toMatchItem );
    } );
}

//on mobile devices we force verification code and disable SHIFT KEY verification
_DELETE_CONFIRM_CODE = detectMob();

/// functions
const showShortcuts = () => {
    var html = `
    <form
        autocomplete="some_off_string_workaround"
        spellcheck="false"
        id="docform"
        class="form-floating needs-validation mb-3"
        novalidate=""
        onsubmit="return false;"
    >
        <b>{NEXUS} Interface Shortcuts</b><br>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + Up</div>
            <div class="col">Select previous card</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + Down</div>
            <div class="col">Select next card</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + Right</div>
            <div class="col">Open "Actions" menu selector</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + Left</div>
            <div class="col">Open "Modules" selector</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + Enter</div>
            <div class="col">Execute the default action</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + A</div>
            <div class="col">Open "Account" menu selector</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + R</div>
            <div class="col">Reload list</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Alt + Shift + S</div>
            <div class="col">Focus on search</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + S</div>
            <div class="col">Positive dialog result</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + E</div>
            <div class="col">Negative dialog result</div>
        </div>

        <br>
        <b>{NEXUS} App Shortcuts</b><br>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + X</div>
            <div class="col">Cut text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + C</div>
            <div class="col">Copy text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + V</div>
            <div class="col">Paste text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + A</div>
            <div class="col">Select all text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + Z</div>
            <div class="col">Undo text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + Y</div>
            <div class="col">Redo text</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + R</div>
            <div class="col">Reload window</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + Shift + R</div>
            <div class="col">Force reload window</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + Shift + I</div>
            <div class="col">Toggle Devtools</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + 0</div>
            <div class="col">Reset Zoom</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + Shift + +</div>
            <div class="col">Zoom in</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + -</div>
            <div class="col">Zoom out</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">F11</div>
            <div class="col">Toggle Fullscreen</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + M</div>
            <div class="col">Minimize window</div>
        </div>
        <div class="row">
            <div class="col" style="max-width: 170px;">Ctrl + W</div>
            <div class="col">Close window</div>
        </div>

    </form>
    `;
    showModal( "Accessibility Shortcuts", html, "", "Close", "",
        () => {
            //nothing
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const showModuleSelector = () => {
    var list = document.getElementsByClassName( 'nav-link' );
    var html = `
    <form
        autocomplete="some_off_string_workaround"
        spellcheck="false"
        id="docform"
        class="form-floating needs-validation mb-3"
        novalidate=""
        onsubmit="return false;"
    >
        <div class="input-group has-validation flex-nowrap mb-3">
            <span class="input-group-text rounded-0" style="width: 30%"
                ><b>Selector</b></span
            >
            <select
                id="selector"
                item.disabled
                class="form-select rounded-0 setfocus"
            >
            item.items
            </select>
        </div>
    </form>
    `;
    var tmp = "";
    for ( i = 0; i < list.length; i++ ) {
        tmp = tmp + "<option>" + list[ i ].innerText.trim() + "</option>";
    }
    html = html.replace( "item.items", tmp );
    showModal( "Module Selector", html, "OK", "Cancel", "",
        () => {
            var item = document.getElementById( 'selector' ).options[ document.getElementById( 'selector' ).selectedIndex ].value;
            for ( i = 0; i < list.length; i++ ) {
                if ( list[ i ].innerText.trim() == item ) {
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        list[ i ].click();
                    }, 500 );
                    break;
                }
            }
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const showAccountMenuSelector = () => {
    var nav = document.getElementById( 'account-selector' );
    var list = nav.getElementsByClassName( 'dropdown-item' );
    var html = `
    <form
        autocomplete="some_off_string_workaround"
        spellcheck="false"
        id="docform"
        class="form-floating needs-validation mb-3"
        novalidate=""
        onsubmit="return false;"
    >
        <div class="input-group has-validation flex-nowrap mb-3">
            <span class="input-group-text rounded-0" style="width: 30%"
                ><b>Selector</b></span
            >
            <select
                id="selector"
                item.disabled
                class="form-select rounded-0 setfocus"
            >
            item.items
            </select>
        </div>
    </form>
    `;
    var tmp = "";
    for ( i = 0; i < list.length; i++ ) {
        tmp = tmp + "<option>" + list[ i ].innerText.trim() + "</option>";
    }
    html = html.replace( "item.items", tmp );
    showModal( "Menu Selector", html, "OK", "Cancel", "",
        () => {
            var item = document.getElementById( 'selector' ).options[ document.getElementById( 'selector' ).selectedIndex ].value;
            for ( i = 0; i < list.length; i++ ) {
                if ( list[ i ].innerText.trim() == item ) {
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        list[ i ].click();
                    }, 500 );
                    break;
                }
            }
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const showActionMenuSelector = () => {
    var nav = selectedCard();
    if ( nav == null ) {
        return;
    }
    var list = nav.getElementsByClassName( 'dropdown-item' );
    var html = `
    <form
        autocomplete="some_off_string_workaround"
        spellcheck="false"
        id="docform"
        class="form-floating needs-validation mb-3"
        novalidate=""
        onsubmit="return false;"
    >
        <div class="input-group has-validation flex-nowrap mb-3">
            <span class="input-group-text rounded-0" style="width: 30%"
                ><b>Selector</b></span
            >
            <select
                id="selector"
                item.disabled
                class="form-select rounded-0 setfocus"
            >
            item.items
            </select>
        </div>
    </form>
    `;
    var tmp = "";
    for ( i = 0; i < list.length; i++ ) {
        tmp = tmp + "<option>" + list[ i ].innerText.trim() + "</option>";
    }
    html = html.replace( "item.items", tmp );
    showModal( "Actions Selector", html, "OK", "Cancel", "",
        () => {
            var item = document.getElementById( 'selector' ).options[ document.getElementById( 'selector' ).selectedIndex ].value;
            for ( i = 0; i < list.length; i++ ) {
                if ( list[ i ].innerText.trim() == item ) {
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        list[ i ].click();
                    }, 500 );
                    break;
                }
            }
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const isOnScreen = ( el, partiallyVisible = false ) => {
    const { top, left, bottom, right } = el.getBoundingClientRect();
    const { innerHeight, innerWidth } = window;
    return partiallyVisible
        ? ( ( top > 0 && top < innerHeight ) ||
            ( bottom > 0 && bottom < innerHeight ) ) &&
        ( ( left > 0 && left < innerWidth ) ||
            ( right > 0 && right < innerWidth ) )
        : top >= 0 && left >= 0 && bottom <= innerHeight && right <= innerWidth;
};

const findInEditor = ( item ) => {
    try {
        var searchResults = window[ "editor" ].find( item );
        if ( searchResults ) {
            window[ "editor" ].scrollToLine( searchResults.start.row );
            window[ "editor" ].clearSelection();
            window[ "editor" ].focus();
        }
    } catch { }
};

const adjustSizing = ( st = false ) => {
    var top = document.getElementById( "floatmenu" );
    if ( st ) {
        _ST = !_ST;
    }
    if ( top ) {
        setTimeout( () => {
            var container = document.getElementById( "container" );
            const rect = container.getBoundingClientRect();
            const realLeft = rect.left + window.scrollX;
            if ( realLeft < 259 ) {
                if ( _ST ) {
                    top.style.left = "65px";
                    top.style.width = "calc(100% - 67px)";
                } else {
                    top.style.left = "2px";
                    top.style.width = "calc(100% - 2px)";
                }
            } else {
                top.style.left = "258px";
                top.style.width = "calc(100% - 260px)";
            }
        }, 250 );
    }

    if ( window.innerWidth <= 1400 ) {
        cls = document.getElementsByClassName( "dynocols" );
        for ( i = 0; i < cls.length; i++ ) {
            cls[ i ].classList.remove( "col-lg-12" );
            cls[ i ].classList.add( "col-lg-4" );
        }
        cls = document.getElementsByClassName( "dynodiv" );
        for ( i = 0; i < cls.length; i++ ) {
            cls[ i ].classList.remove( "vr" );
            cls[ i ].classList.add( "hr" );
        }
    } else {
        cls = document.getElementsByClassName( "dynocols" );
        for ( i = 0; i < cls.length; i++ ) {
            cls[ i ].classList.remove( "col-lg-4" );
            cls[ i ].classList.add( "col-lg-12" );
        }
        cls = document.getElementsByClassName( "dynodiv" );
        for ( i = 0; i < cls.length; i++ ) {
            cls[ i ].classList.remove( "hr" );
            cls[ i ].classList.add( "vr" );
        }
    }
};

const selectPricing = ( sender ) => {
    document.getElementById( "selPrice1" ).selectedIndex = sender.selectedIndex;
    document.getElementById( "selPrice2" ).selectedIndex = sender.selectedIndex;
    document.getElementById( "selPrice3" ).selectedIndex = sender.selectedIndex;
    document.getElementById( "selPrice4" ).selectedIndex = sender.selectedIndex;
    if ( sender.selectedIndex == 0 ) {
        document.getElementById( "priceV7S" ).innerHTML = "&euro; 29";
        document.getElementById( "priceV7M" ).innerHTML = "&euro; 59";
        document.getElementById( "priceV7L" ).innerHTML = "&euro; 119";
        document.getElementById( "priceV7XL" ).innerHTML = "&euro; 259";
        document.getElementById( "priceV7XXL" ).innerHTML = "&euro; 589";
        document.getElementById( "priceV7iX" ).innerHTML = "&euro; 349";
        document.getElementById( "priceV7iXL" ).innerHTML = "&euro; 399";
        document.getElementById( "priceSV7L" ).innerHTML = "&euro; 219";
        document.getElementById( "priceSV7XL" ).innerHTML = "&euro; 299";
        document.getElementById( "priceGV7T4" ).innerHTML = "&euro; 839";
        document.getElementById( "priceGV7A10" ).innerHTML = "&euro; 999";
        document.getElementById( "priceAV7L" ).innerHTML = "&euro; 359";
        document.getElementById( "priceAV7XL" ).innerHTML = "&euro; 459";
    } else if ( sender.selectedIndex == 1 ) {
        document.getElementById( "priceV7S" ).innerHTML =
            '&euro; 285 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7M" ).innerHTML =
            '&euro; 571 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7L" ).innerHTML =
            '&euro; 1142 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7XL" ).innerHTML =
            '&euro; 2486 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7XXL" ).innerHTML =
            '&euro; 5654 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7iX" ).innerHTML =
            '&euro; 3350 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceV7iXL" ).innerHTML =
            '&euro; 3830 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceSV7L" ).innerHTML =
            '&euro; 2102 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceSV7XL" ).innerHTML =
            '&euro; 2870 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceGV7T4" ).innerHTML =
            '&euro; 8054 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceGV7A10" ).innerHTML =
            '&euro; 9590 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceAV7L" ).innerHTML =
            '&euro; 3446 <sup style="font-size: 0.6rem;">20% OFF</sup>';
        document.getElementById( "priceAV7XL" ).innerHTML =
            '&euro; 4406 <sup style="font-size: 0.6rem;">20% OFF</sup>';
    }
};

const toggleTasks = ( sender ) => {
    var list = document.querySelector( ".tasklist" );
    if ( sender.checked ) {
        list.style.display = "block";
    } else {
        list.style.display = "none";
    }
};

const copyText = ( sender, value = "" ) => {
    var text = "";
    if ( value == "" ) {
        text = sender.innerText;
    } else {
        text = value;
    }
    if ( navigator.clipboard && window.isSecureContext ) {
        return navigator.clipboard.writeText( text );
    } else {
        let textArea = document.createElement( "textarea" );
        textArea.value = text;
        textArea.style.position = "fixed";
        textArea.style.left = "-999999px";
        textArea.style.top = "-999999px";
        document.body.appendChild( textArea );
        textArea.focus();
        textArea.select();
        return new Promise( ( res, rej ) => {
            document.execCommand( "copy" ) ? res() : rej();
            textArea.remove();
        } );
    }
};

const searchCard = ( start = false ) => {
    var input, filter, li, i, txtValue;
    if ( start ) {
        input = document.getElementById( "searchfor2" );
    } else {
        input = document.getElementById( "searchfor" );
    }
    filter = input.value.toUpperCase();
    li = document.getElementsByClassName( "card" );

    for ( i = 0; i < li.length; i++ ) {
        if ( li[ i ].id != "intro" ) {
            txtValue = li[ i ].textContent || li[ i ].innerText;
            if ( txtValue.toUpperCase().indexOf( filter ) > -1 ) {
                li[ i ].style.display = "";
            } else {
                li[ i ].style.display = "none";
            }
        }
    }
};

const searchLogs = () => {
    var input, filter, li, i, txtValue;
    input = document.getElementById( "logsearch" );
    filter = input.value.toUpperCase();
    li = document.getElementsByTagName( "TR" );

    for ( i = 0; i < li.length; i++ ) {
        txtValue = li[ i ].textContent || li[ i ].innerText;
        if ( txtValue.toUpperCase().indexOf( filter ) > -1 ) {
            li[ i ].style.display = "";
        } else {
            li[ i ].style.display = "none";
        }
    }

    document.getElementById( "monitorButton" ).innerHTML = "Load";
    document.getElementById( "monitorButton" ).removeAttribute( "disabled" );
    document.getElementById( "jsonTable" ).style.display = "block";
};

const doSearchFlowServices = () => {
    var input, filter, li, i, txtValue;
    input = document.getElementById( "findService" );
    filter = input.value.toUpperCase();
    li = document.getElementsByClassName( "apiblock" );

    for ( i = 0; i < li.length; i++ ) {
        txtValue = li[ i ].textContent || li[ i ].innerText;
        if ( txtValue.toUpperCase().indexOf( filter ) > -1 ) {
            li[ i ].style.display = "";
        } else {
            li[ i ].style.display = "none";
        }
    }
};

const doSearchRuns = () => {
    var input, filter, li, i, txtValue;
    input = document.getElementById( "findruns" );
    filter = input.value.toUpperCase();
    li = document.getElementsByClassName( "runs" );

    for ( i = 0; i < li.length; i++ ) {
        txtValue = li[ i ].textContent || li[ i ].innerText;
        if ( txtValue.toUpperCase().indexOf( filter ) > -1 ) {
            li[ i ].style.display = "";
        } else {
            li[ i ].style.display = "none";
        }
    }
};

const unselectNav = ( sender, groups = false ) => {
    if ( groups ) {
        var selList = document.getElementsByClassName( "nav-group" );
        for ( i = selList.length - 1; i > -1; i-- ) {
            selList[ i ].classList.remove( "show" );
        }
    }
    var links = document.getElementsByClassName( "nav-link" );
    for ( i = 0; i < links.length; i++ ) {
        links[ i ].classList.remove( "active" );
    }
};

const selectNav = ( sender, groups = false ) => {
    unselectNav( sender, groups );
    if (
        sender.innerText.toLowerCase().trim() != "identities" &&
        sender.innerText.toLowerCase().trim() != "roles" &&
        sender.innerText.toLowerCase().trim() != "groups" &&
        sender.innerText.toLowerCase().trim() != "upgrade account" &&
        sender.innerText.toLowerCase().trim() != "repository keys" &&
        sender.innerText.toLowerCase().trim() != "idendity keys" &&
        sender.innerText.toLowerCase().trim() != "role keys" &&
        sender.innerText.toLowerCase().trim() != "access keys" &&
        sender.innerText.toLowerCase().trim() != "documentation" &&
        sender.innerText.toLowerCase().trim() != "tutorials" &&
        sender.innerText.toLowerCase().trim() != "api and cli reference" &&
        sender.innerText.toLowerCase().trim() != "overview of costs" &&
        sender.innerText.toLowerCase().trim() != "payments history" &&
        sender.innerText.toLowerCase().trim() != "setup paypal account" &&
        sender.innerText.toLowerCase().trim() != "policies"
    ) {
        if ( sender.id == "nav-title" ) {
            var links = document.getElementsByClassName( "nav-link" );
            for ( i = 0; i < links.length; i++ ) {
                if ( links[ i ].innerText == sender.innerText ) {
                    links[ i ].classList.add( "active" );
                    break;
                }
            }
        } else {
            sender.classList.add( "active" );
        }
    }
    document.getElementById( "nav-title" ).innerHTML = sender.innerText;
    try {
        window.event.stopPropagation();
    } catch { }
};

const unselectCards = () => {
    var selList = document.getElementsByClassName( "card" );
    for ( i = selList.length - 1; i > -1; i-- ) {
        selList[ i ].classList.remove( "selected" );
    }
};

const selectCard = ( sender ) => {
    if ( sender != null ) {
        unselectCards();
        setTimeout( () => {
            sender.classList.add( "selected" );
            sender.focus();
            if ( !isOnScreen( sender ) ) {
                sender.scrollIntoView( { block: "end" } );
            };
        }, 1 );
    }
};

const selectedCard = () => {
    var selList = document.getElementsByClassName( "selected" );
    if ( selList.length == 1 ) {
        return selList[ 0 ];
    } else {
        return null;
    }
};

const hideSidebar = () => {
    if ( document.getElementById( "sidebar" ).classList.contains( "show" ) ) {
        document.querySelector( ".header-toggler" ).click();
    }
};

const addSpinner = () => {
    // var spinner = `<center style="z-Index: 100; color: {DEFCOLOR};"><div id="spinner" class="spinner-border text-info" role="status" style="z-Index: 100; color: {DEFCOLOR};">
    //                     <span style="z-Index: 100; color: {DEFCOLOR};" class="visually-hidden">Loading...</span>
    //                 </div><br>LOADING</center>`;
    // document.getElementById( "container" ).innerHTML = spinner;
    //document.getElementById( 'loadSpinner' ).style.display = "block";
};

const addNothing = () => {
    var nothing = `<center style="z-Index: 100; color: {DEFCOLOR};">
        <svg class="nav-icon" style="width: 36px; height: 36px;">
            <use xlink:href="vendors/@coreui/icons/svg/free.svg#cil-warning"></use>
        </svg>
    <br>nothing to see here</center>`;
    document.getElementById( "container" ).innerHTML = nothing;
};

const addError = ( error ) => {
    var nothing = `<center style="color: red; z-Index: 100;">
        <svg class="nav-icon" style="width: 36px; height: 36px;">
            <use xlink:href="vendors/@coreui/icons/svg/free.svg#cil-x"></use>
        </svg>
    <br>${error}</center>`;
    document.getElementById( "container" ).innerHTML = nothing;
};

const removeListItem = ( sender ) => {
    var parent = sender.parentNode.parentNode.parentNode;
    parent.removeChild( sender.parentNode.parentNode );
    window[ "apichanged" ] = true;
};

const addListItem = ( sel, list, extra = "", check = false ) => {
    if ( check ) {
        if ( sel.selectedIndex == -1 ) {
            showError( "Can not add an empty item" );
            return;
        }
        if ( sel.options[ sel.selectedIndex ].text == "" ) {
            showError( "Can not add an empty role" );
            return;
        }
        if ( sel.options[ sel.selectedIndex ].value == "" ) {
            showError( "Can not add an empty role" );
            return;
        }
    }
    var value = sel.options[ sel.selectedIndex ].text;
    var valueData = sel.options[ sel.selectedIndex ].value;
    var extraData = extra;
    var extraLabel = "";
    if ( extra != "" ) {
        extraLabel = " - (" + extra + ")";
    }
    var item = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" value-data="${valueData}" value-extra="${extraData}" disabled value="${value}${extraLabel}">
        <span class="input-group-btn">
            <button class="btn btn-secondary rounded-0" type="button" onclick="removeListItem(this);">Remove</button>
        </span>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].getAttribute( "value-data" ) == valueData ) {
            showWarning( "Item is already selected" );
            return;
        }
    }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-3";
    newNode.innerHTML = item;
    list.appendChild( newNode );
};

const addSIEMFilter = () => {
    var filterOption = document.getElementById( 'filteroption' ).options[ document.getElementById( 'filteroption' ).selectedIndex ].value;
    var filterValue = document.getElementById( 'filtervalue' ).value;
    var valueData = filterOption + "->" + filterValue;
    var list = document.getElementById( 'filter' );
    var item = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" value-data="${valueData}" disabled value="${valueData}">
        <span class="input-group-btn">
            <button class="btn btn-secondary rounded-0" type="button" onclick="removeListItem(this);">Remove</button>
        </span>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].getAttribute( "value-data" ) == valueData ) {
            showWarning( "Item is already selected" );
            return;
        }
    }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-3";
    newNode.innerHTML = item;
    list.appendChild( newNode );
};

const renewCertListItem = ( sender, id ) => {
    var value = sender.parentNode.parentNode
        .getElementsByTagName( "input" )[ 0 ]
        .getAttribute( "value-data" );
    if ( value.indexOf( "{APPNAME}" ) == -1 ) {
        ajax(
            "/api/skynodes".toLowerCase(),
            "renew-cert",
            '{"id": "' + id + '", "cert": "' + value + '"}',
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    } else {
        showInfo( "Certificate renewal not required" );
    }
};

const removeCertListItem = ( sender, id ) => {
    if ( !event.shiftKey ) {
        if ( !_DELETE_CONFIRM_CODE ) {
            showError(
                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
            );
            return;
        }
    }
    var value = sender.parentNode.parentNode
        .getElementsByTagName( "input" )[ 0 ]
        .getAttribute( "value-data" );
    ajax(
        "/api/skynodes".toLowerCase(),
        "remove-cert",
        '{"id": "' + id + '", "cert": "' + value + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
            var parent = sender.parentNode.parentNode.parentNode;
            parent.removeChild( sender.parentNode.parentNode );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const addCertListItem = ( id, domain, cert, extra = "" ) => {
    if ( domain.trim() == "" ) {
        showError( "Please enter a domain name" );
        return;
    }
    var value = domain.trim() + " - " + cert;
    var valueData = value;
    var extraData = extra;
    var extraLabel = "";
    if ( extra != "" ) {
        extraLabel = " - (" + extra + ")";
    }
    var item = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" value-data="${valueData}" value-extra="${extra}" disabled value="${value}${extraData}">
        <span class="input-group-btn">
            <button class="btn btn-secondary rounded-0" type="button" onclick="renewCertListItem(this, '${id}');">Renew</button>
        </span>
        <span class="input-group-btn">
            <button class="btn btn-secondary rounded-0" type="button" style="margin-right: 5px;" onclick="removeCertListItem(this, '${id}');">Remove</button>
        </span>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].getAttribute( "value-data" ) == valueData ) {
            showWarning( "Item is already exists" );
            return;
        }
    }

    document.getElementById( "certbutton" ).innerHTML =
        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
    document.getElementById( "certbutton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/skynodes".toLowerCase(),
        "create-cert",
        '{"id": "' +
        id +
        '", "domain": "' +
        domain +
        '", "cert": "' +
        cert +
        '"}',
        ( success ) => {
            var j = JSON.parse( success );
            var newNode = document.createElement( "div" );
            newNode.className = "input-group has-validation flex-nowrap mb-3";
            newNode.innerHTML = item;
            document.getElementById( "certs" ).appendChild( newNode );
            showSuccess( j.payload );
            document.getElementById( "certbutton" ).removeAttribute( "disabled" );
            document.getElementById( "certbutton" ).innerHTML = "Create";
            document.getElementById( "domain" ).value = "";
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "certbutton" ).removeAttribute( "disabled" );
            document.getElementById( "certbutton" ).innerHTML = "Create";
        }
    );
};

const addRoleItem = () => {
    var grandItem =
        document.getElementById( "grantlist" ).options[
            document.getElementById( "grantlist" ).selectedIndex
        ].text;
    var perms = "";
    var permlList = document.getElementsByClassName( "grantCheck" );
    for ( i = 0; i < permlList.length; i++ ) {
        if ( permlList[ i ].checked ) {
            if ( perms == "" ) {
                perms = permlList[ i ].id.replace( "grant-", "" ).toUpperCase();
            } else {
                perms =
                    perms +
                    "," +
                    permlList[ i ].id.replace( "grant-", "" ).toUpperCase();
            }
        }
    }

    if ( perms == "" ) {
        showError( "No permissions are selected" );
        return;
    }

    if ( perms.indexOf( "FULL" ) != -1 ) {
        perms = "*";
    }

    if ( document.getElementById( "grantResource" ).value == "" ) {
        document.getElementById( "grantResource" ).value = "*";
    }
    var limit = document.getElementById( "grantResource" ).value;

    var item = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" value-data='item.data' disabled value='item.value'>
        <span class="input-group-btn">
            <button class="btn btn-secondary rounded-0" type="button" onclick="removeListItem(this);">Remove</button>
        </span>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    // for ( i = 0; i < polList.length; i++ ) {
    //     if ( polList[ i ].getAttribute( 'value-data' ).indexOf( grandItem.replace( / /g, "" ).toLowerCase() + "::" ) != -1 ) {
    //         showWarning( "module policy already exists, please remove old policy first" );
    //         return;
    //     }
    // }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-3";
    newNode.innerHTML = item
        .replace( "item.data", grandItem.replace( / /g, "" ).toLowerCase() + "::" + perms.toLowerCase() + "::" + limit )
        .replace(
            "item.value",
            grandItem.replace( / /g, "" ).toLowerCase() + "::" + perms.toLowerCase() + "::" + limit
        );
    document.getElementById( "policies" ).appendChild( newNode );
};

const addOrderItem = ( sender ) => {
    var value = sender.id;
    var list = document.getElementById( "orders" );
    var item = `
        <div class="input-group has-validation flex-nowrap mb-1">
            <input id="orderModel" autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="${value}">
            <span class="input-group-text rounded-0 mb-0" style="width: 12%;">Plan</span>
            <select id="orderPlan" class="form-select rounded-0 isdata ">
                <option>Month</option>
                <option>Year</option>
            </select>
            <span class="input-group-text rounded-0 mb-0" style="width: 12%;">Region</span>
            <select id="orderRegion" class="form-select rounded-0 isdata ">
                <option>DE (North)</option>
                <option>DE (South)</option>
                <option>GB (Central)</option>
                <option>ES (North)</option>
                <option>USA (East)</option>
                <option>USA (West)</option>
            </select>
            <span class="input-group-text rounded-0 mb-0" style="width: 12%;">Amount</span>
            <select id="orderAmount" class="form-select rounded-0 isdata ">
                <option>1</option>
                <option>2</option>
                <option>3</option>
            </select>
            <span class="input-group-btn">
                <button class="btn btn-secondary rounded-0 mb-0" type="button" style="width: 100px;" onclick="removeListItem(this);">Remove</button>
            </span>
        </div>
    `;

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-0";
    newNode.innerHTML = item;
    list.appendChild( newNode );
};

const addLoadBalancerItem = ( ip, port ) => {
    if ( isNaN( port ) ) {
        showError( "Given port number is invalid" );
        return;
    }

    if ( ip.trim() == "" || port.trim() == "" ) {
        showError( "please enter ip and port" );
        return;
    }

    var dW = "30%";
    if ( ip.indexOf( "->" ) != -1 ) {
        dW = "20%";
    }

    if ( ip.indexOf( "->" ) != -1 ) {
        if ( ip.startsWith( "->" ) ) {
            showError( "please enter access port" );
            return;
        }
    }

    var list = document.getElementById( "ips" );
    var item = `
        <div class="input-group has-validation flex-nowrap mb-1">
            <span class="input-group-text rounded-0 mb-0" style="width: ${dW};">Destination</span>
            <input id="itemip" autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="${ip}:${port}">
            <span class="input-group-btn">
                <button class="btn btn-secondary rounded-0 mb-0" type="button" style="width: 100px;" onclick="removeListItem(this);">Remove</button>
            </span>
        </div>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].value == ip + ":" + port ) {
            showWarning( "Item already exists" );
            return;
        }
        if ( ip.indexOf( "->" ) != -1 ) {
            if ( polList[ i ].value.startsWith( ip.split( "-" )[ 0 ] ) ) {
                showWarning( "Item already exists" );
                return;
            }
        }
    }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-0";
    newNode.innerHTML = item;
    list.appendChild( newNode );
};

const addRouteItem = ( ip, port ) => {
    if ( ip.trim() == "" || port.trim() == "" ) {
        showError( "please enter route and gateway" );
        return;
    }

    var dW = "30%";
    if ( ip.indexOf( "->" ) != -1 ) {
        dW = "20%";
    }

    if ( ip.indexOf( "->" ) != -1 ) {
        if ( ip.startsWith( "->" ) ) {
            showError( "please enter route" );
            return;
        }
    }

    var list = document.getElementById( "ips" );
    var item = `
        <div class="input-group has-validation flex-nowrap mb-1">
            <span class="input-group-text rounded-0 mb-0" style="width: ${dW};">Destination</span>
            <input id="itemip" autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="${ip}">
            <span class="input-group-btn">
                <button class="btn btn-secondary rounded-0 mb-0" type="button" style="width: 100px;" onclick="removeListItem(this);">Remove</button>
            </span>
        </div>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].value == ip ) {
            showWarning( "Item already exists" );
            return;
        }
        if ( ip.indexOf( "->" ) != -1 ) {
            if ( polList[ i ].value.startsWith( ip.split( "-" )[ 0 ] ) ) {
                showWarning( "Item already exists" );
                return;
            }
        }
    }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-0";
    newNode.innerHTML = item;
    list.appendChild( newNode );
};

const addAPIItem = ( path, ac, dest ) => {
    if ( path == "" || dest == "" ) {
        showError( "Please enter information" );
        return;
    }
    if ( !path.startsWith( "/" ) ) {
        path = "/" + path;
    }
    var list = document.getElementById( "apilist" );
    var item = `
        <div class="input-group has-validation flex-nowrap mb-1">
            <span class="input-group-text rounded-0 mb-0" style="width: 5%;">API</span>
            <input id="itemip" autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="${path} => ${ac} => ${dest}">
            <span class="input-group-btn">
                <button class="btn btn-secondary rounded-0 mb-0" type="button" style="width: 100px;" onclick="removeListItem(this);">Remove</button>
            </span>
        </div>
    `;

    var polList = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < polList.length; i++ ) {
        if ( polList[ i ].value.indexOf( path + " =>" ) != -1 ) {
            showWarning( "Item already exists" );
            return;
        }
    }

    var newNode = document.createElement( "div" );
    newNode.className = "input-group has-validation flex-nowrap mb-0";
    newNode.innerHTML = item;
    list.appendChild( newNode );
    document.getElementById( "path" ).focus();
    window[ "apichanged" ] = true;
};

const genPassword = () => {
    var chars =
        "0123456789abcdefghijklmnopqrstuvwxyz!@#^*ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var passwordLength = 12;
    var password = "";
    for ( var i = 0; i <= passwordLength - 1; i++ ) {
        var randomNumber = Math.floor( Math.random() * chars.length );
        password += chars.substring( randomNumber, randomNumber + 1 );
    }
    return password;
};

const genKey = ( val = 32 ) => {
    var chars =
        "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var passwordLength = val;
    var password = "";
    for ( var i = 0; i <= passwordLength - 1; i++ ) {
        var randomNumber = Math.floor( Math.random() * chars.length );
        password += chars.substring( randomNumber, randomNumber + 1 );
    }
    return password;
};

const showModal = (
    caption,
    text,
    okBtnText = "OK",
    canelBtnText = "Cancel",
    modalSize = "",
    onOK = null,
    onCancel = null
) => {
    var scripts = document.getElementsByClassName( "coder" );
    while ( scripts[ 0 ] ) {
        scripts[ 0 ].parentNode.removeChild( scripts[ 0 ] );
    }

    var inputs = document.getElementsByTagName( "INPUT" );
    for ( i = 0; i < inputs.length; i++ ) {
        inputs[ i ].setAttribute( "autocomplete", "off" );
        inputs[ i ].setAttribute( "spellcheck", "false" );
    }
    var inputs = document.getElementsByTagName( "TEXTAREA" );
    for ( i = 0; i < inputs.length; i++ ) {
        inputs[ i ].setAttribute( "autocomplete", "off" );
        inputs[ i ].setAttribute( "spellcheck", "false" );
    }
    var inputs = document.getElementsByTagName( "FORM" );
    for ( i = 0; i < inputs.length; i++ ) {
        inputs[ i ].setAttribute( "autocomplete", "off" );
        inputs[ i ].setAttribute( "spellcheck", "false" );
    }

    document.getElementById( "customButton" ).style.display = "none";

    document.querySelector( ".modal-dialog" ).classList.remove( "modal-lg" );
    document.querySelector( ".modal-dialog" ).classList.remove( "modal-xl" );
    document
        .querySelector( ".modal-dialog" )
        .classList.remove( "modal-fullscreen" );
    if ( modalSize != "" ) {
        document.querySelector( ".modal-dialog" ).classList.add( modalSize );
    }
    if ( onOK != null ) {
        document.getElementById( "okButton" ).style.display = "block";
    }
    document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
    document.getElementById( "okButton" ).removeAttribute( "disabled" );
    document.getElementById( "modaltitle" ).innerHTML = caption;
    document.getElementById( "modaltext" ).innerHTML = text;
    document.getElementById( "okButton" ).innerText = okBtnText;
    document.getElementById( "cancelButton" ).innerText = canelBtnText;
    if ( okBtnText == "" ) {
        document.getElementById( "okButton" ).style.display = "none";
    } else {
        document.getElementById( "okButton" ).style.display = "block";
    }
    document.getElementById( "cancelButton" ).onclick = ( e ) => {
        if ( onCancel != null ) {
            onCancel();
        }
    };

    document.getElementById( "okButton" ).onclick = ( e ) => {
        if ( onOK != null ) {
            onOK();
        }
    };
    document.getElementById( "md" ).click();
    setTimeout( () => {
        try {
            document.querySelector( ".setfocus" ).focus();
        } catch {
            document.getElementById( "cancelButton" ).focus();
        }
        var scripts = document.getElementsByClassName( "coder" );
        for ( i = 0; i < scripts.length; i++ ) {
            eval( scripts[ i ].innerHTML );
        }
    }, 600 );
};

const showAbout = () => {
    let list = [ { CPRLIST } ];
    let vals = "";
    list.sort().forEach( function ( item ) {
        vals = vals + item + ", ";
    } );
    vals = vals.substring( 0, vals.length - 2 );

    document.querySelector( ".modal-dialog" ).classList.remove( "modal-lg" );
    document.querySelector( ".modal-dialog" ).classList.remove( "modal-xl" );
    document
        .querySelector( ".modal-dialog" )
        .classList.remove( "modal-fullscreen" );
    document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
    document.getElementById( "okButton" ).removeAttribute( "disabled" );
    document.getElementById( "customButton" ).style.display = "none";
    document.getElementById( "okButton" ).style.display = "none";
    document.getElementById( "modaltitle" ).innerHTML = "About";
    document.getElementById( "modaltext" ).innerHTML =
        `<center>
            <div style="height: 70px; width: 180px;">{LOGO-T-PNG}</div>
            <b style="font-size: 2rem;">{STACKTYPE} Edition</b><br><br>
            <b style="font-size: 1,8rem;">{NEXUS} {VERSION}</b><br>

            <div style="font-size: 0.85rem;">
            {STATS}<br><br>
            {CPR}. All Rights Reserved.<br>{TRADE}.
            <br><br>
            <div style="font-size: 0.85rem; display: {CPRSHOW};"><b>{CPRTITLE}</b><br>${vals}<br><br></div>
            Timezone: ` +
        Intl.DateTimeFormat().resolvedOptions().timeZone +
        `
            <br>
            License Expires: {EXPIRE-MONTH}{EXPIRE-YEAR}
            </div><br>
            &#128232; <a href="mailto:{SUPPORT}" style="font-size: 0.9rem;"><b>{SUPPORT}</b></a><br>
            &#127760; <a href="{MASTER}" target="_blank" style="font-size: 0.9rem;"><b>{MASTER}&nbsp;&nbsp;</b></a><br>
        </center>`;
    document.getElementById( "okButton" ).innerText = "OK";
    document.getElementById( "cancelButton" ).innerText = "Close";
    document.getElementById( "cancelButton" ).onclick = ( e ) => {
        document.getElementById( "quitButton" ).click();
    };
    document.getElementById( "md" ).click();
    setTimeout( () => {
        document.getElementById( "cancelButton" ).focus();
    }, 500 );
};

const showConsole = ( caption, frame ) => {
    var scripts = document.getElementsByClassName( "coder" );
    while ( scripts[ 0 ] ) {
        scripts[ 0 ].parentNode.removeChild( scripts[ 0 ] );
    }
    var scripts = document.getElementsByTagName( "IFRAME" );
    while ( scripts[ 0 ] ) {
        scripts[ 0 ].parentNode.removeChild( scripts[ 0 ] );
    }

    document.getElementById( "customButton" ).style.display = "none";
    document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
    document.getElementById( "okButton" ).removeAttribute( "disabled" );
    document.querySelector( ".modal-dialog" ).classList.remove( "modal-lg" );
    document.querySelector( ".modal-dialog" ).classList.remove( "modal-xl" );
    document.querySelector( ".modal-dialog" ).classList.add( "modal-fullscreen" );
    document.getElementById( "modaltitle" ).innerHTML = caption;
    document.getElementById( "modaltext" ).innerHTML = frame;
    document.getElementById( "okButton" ).style.display = "none";
    document.getElementById( "okButton" ).innerText = "OK";
    document.getElementById( "cancelButton" ).innerText = "Close";
    document.getElementById( "cancelButton" ).onclick = ( e ) => {
        document.getElementById( "quitButton" ).click();
    };
    document.getElementById( "md" ).click();
    setTimeout( () => {
        document.getElementsByTagName( "IFRAME" )[ 0 ].focus();
    }, 1000 );
};

const showExplainer = ( caption, frame ) => {
    document.getElementById( "customButton" ).style.display = "none";
    document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
    document.getElementById( "okButton" ).removeAttribute( "disabled" );
    document.querySelector( ".modal-dialog" ).classList.remove( "modal-lg" );
    document.querySelector( ".modal-dialog" ).classList.add( "modal-xl" );
    document.getElementById( "modaltitle" ).innerHTML = caption;
    document.getElementById( "modaltext" ).innerHTML = frame;
    document.getElementById( "okButton" ).style.display = "none";
    document.getElementById( "okButton" ).innerText = "OK";
    document.getElementById( "cancelButton" ).innerText = "Close";
    document.getElementById( "cancelButton" ).onclick = ( e ) => {
        document.getElementById( "quitButton" ).click();
    };
    document.getElementById( "md" ).click();
    //setTimeout(() => { document.getElementsByTagName('IFRAME')[0].focus(); }, 1000);
};

const showError = ( text, time = 15000, callback = null ) => {
    Toastify( {
        text: text,
        duration: time,
        newWindow: true,
        close: false,
        gravity: "bottom",
        position: "center",
        stopOnFocus: true,
        style: {
            background: "linear-gradient(to right, #ee3300, #ee3300)",
        },
        onClick: function () {
            if ( callback != null ) {
                callback();
            }
        }, // Callback after click
    } ).showToast();
};

const showInfo = ( text, time = 15000, callback = null ) => {
    Toastify( {
        text: text,
        duration: time,
        newWindow: true,
        close: false,
        gravity: "bottom",
        position: "center",
        stopOnFocus: true,
        style: {
            background: "linear-gradient(to right, {DEFCOLOR}, {DEFCOLOR})",
        },
        onClick: function () {
            if ( callback != null ) {
                callback();
            }
        }, // Callback after click
    } ).showToast();
};

const showWarning = ( text, time = 15000, callback = null ) => {
    Toastify( {
        text: text,
        duration: time,
        newWindow: true,
        close: false,
        gravity: "bottom",
        position: "center",
        stopOnFocus: true,
        style: {
            background: "linear-gradient(to right, darkorange, darkorange)",
        },
        onClick: function () {
            if ( callback != null ) {
                callback();
            }
        }, // Callback after click
    } ).showToast();
};

const showSuccess = ( text, time = 15000, callback = null ) => {
    Toastify( {
        text: text,
        duration: time,
        newWindow: true,
        close: false,
        gravity: "bottom",
        position: "center",
        stopOnFocus: true,
        style: {
            background: "linear-gradient(to right, #009000, #009000)",
        },
        onClick: function () {
            if ( callback != null ) {
                callback();
            }
        }, // Callback after click
    } ).showToast();
};

const saveData = ( api ) => {
    var data = {};
    var list = document.getElementsByClassName( "isdata" );
    for ( i = 0; i < list.length; i++ ) {
        if ( list[ i ].tagName == "INPUT" ) {
            if ( list[ i ].getAttribute( "type" ) == "checkbox" ) {
                data[ list[ i ].id ] = list[ i ].checked;
            } else if ( list[ i ].getAttribute( "type" ) == "radio" ) {
                data[ list[ i ].id ] = list[ i ].checked;
            } else if ( list[ i ].getAttribute( "type" ) == "text" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "email" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "password" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "number" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "range" ) {
                data[ list[ i ].id ] = list[ i ].value;
            }
        }
        if ( list[ i ].tagName == "TEXTAREA" ) {
            data[ list[ i ].id ] = list[ i ].value;
        }
        if ( list[ i ].tagName == "SELECT" ) {
            if (
                list[ i ].selectedIndex == -1 &&
                !list[ i ].hasAttribute( "disabled" )
            ) {
                showError(
                    "Missing information, please consult the documentation"
                );
                return "ERR";
            }
            var val = "";
            try {
                val = list[ i ].options[ list[ i ].selectedIndex ].value;
            } catch { }
            if ( val == "true" || val == "false" ) {
                data[ list[ i ].id ] = String( true ) == val;
            } else {
                data[ list[ i ].id ] = val;
            }
        }
        if ( list[ i ].tagName == "SPAN" ) {
            data[ list[ i ].id ] = list[ i ].innerText;
        }
    }

    var list = document.getElementsByClassName( "islist" );
    for ( i = 0; i < list.length; i++ ) {
        var row = [];
        var items = document.getElementsByClassName( "listitem" );
        for ( j = 0; j < items.length; j++ ) {
            var keyName = items[ j ].value;
            var obj = {};
            obj[ keyName ] = items[ j ].getAttribute( "value-data" );
            row.push( obj );
        }
        data[ list[ i ].id ] = row;
    }

    //special conditions or tasks per api
    if (
        api == "Serverless-fx" ||
        api == "Serverless-spark" ||
        api == "Serverless-flow" ||
        api == "Serverless-api"
    ) {
        try {
            if ( document.getElementById( "serverless-codeeditor" ) != null ) {
                data[ "pushCode" ] = window[ "editor" ].getValue();
            }
        } catch { }
    }

    return data;
};

const saveProp = () => {
    var data = {};
    var list = document.getElementsByClassName( "isprop" );
    for ( i = 0; i < list.length; i++ ) {
        if ( list[ i ].tagName == "INPUT" ) {
            if ( list[ i ].getAttribute( "type" ) == "checkbox" ) {
                data[ list[ i ].id ] = list[ i ].checked;
            } else if ( list[ i ].getAttribute( "type" ) == "radio" ) {
                data[ list[ i ].id ] = list[ i ].checked;
            } else if ( list[ i ].getAttribute( "type" ) == "text" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "email" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "password" ) {
                data[ list[ i ].id ] = list[ i ].value;
            } else if ( list[ i ].getAttribute( "type" ) == "number" ) {
                data[ list[ i ].id ] = list[ i ].value;
            }
        }
        if ( list[ i ].tagName == "TEXTAREA" ) {
            data[ list[ i ].id ] = list[ i ].value;
        }
        if ( list[ i ].tagName == "SELECT" ) {
            var val = list[ i ].options[ list[ i ].selectedIndex ].value;
            if ( val == "true" || val == "false" ) {
                data[ list[ i ].id ] = String( true ) == val;
            } else {
                data[ list[ i ].id ] = list[ i ].options[ list[ i ].selectedIndex ].value;
            }
        }
    }

    return data;
};

const composeCode = ( sender ) => {
    var folderName = sender.getAttribute( "folder" );
    ajax(
        "/api/solutionstacks",
        "compose",
        JSON.stringify( { marketID: sender.id, folder: folderName } ),
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.result == "OK" ) {
                const editor = ace.edit( "editor" );
                editor.setTheme( "ace/theme/{EDITORTHEME}" );
                editor.session.setMode( "ace/mode/yaml" );
                editor.session.setValue( j.payload, -1 );
                editor.setOptions( {
                    fontFamily: "monospace",
                    fontSize: "16px",
                } );
                window[ "editor" ] = editor;
                document.getElementById( "configure" ).innerHTML = j.html;
                document.getElementById( "codetab" ).click();
                eval( document.getElementById( "internalCoder" ).innerText );
                setTimeout( () => {
                    document.getElementById( "name" ).focus();
                }, 200 );
                if (
                    document.getElementById( "nav-title" ).innerText.trim() ==
                    "Magna-app"
                ) {
                    if ( document.getElementById( "deployto" ) != null ) {
                        for (
                            i = 0;
                            i <
                            document.getElementById( "dctarget" ).options.length;
                            i++
                        ) {
                            if (
                                document.getElementById( "dctarget" ).options[ i ]
                                    .value == selectedCard().id
                            ) {
                                document.getElementById( "dctarget" ).options[
                                    i
                                ].selected = true;
                                document
                                    .getElementById( "dctarget" )
                                    .setAttribute( "disabled", "true" );
                            }
                        }
                    }
                }
                if (
                    document.getElementById( "nav-title" ).innerText.trim() ==
                    "Magna-nodes"
                ) {
                    if ( document.getElementById( "deployto" ) != null ) {
                        for (
                            i = 0;
                            i <
                            document.getElementById( "dmtarget" ).options.length;
                            i++
                        ) {
                            if (
                                document.getElementById( "dmtarget" ).options[ i ]
                                    .value == selectedCard().id
                            ) {
                                document.getElementById( "dmtarget" ).options[
                                    i
                                ].selected = true;
                                document
                                    .getElementById( "dmtarget" )
                                    .setAttribute( "disabled", "true" );
                            }
                        }
                    }
                }
            } else {
                showError( "something went wrong, please try again" );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const removeNodeImage = ( sender, id ) => {
    if ( !event.shiftKey ) {
        if ( !_DELETE_CONFIRM_CODE ) {
            showError(
                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
            );
            return;
        }
    }
    var value = sender.parentNode.parentNode
        .getElementsByTagName( "input" )[ 0 ]
        .getAttribute( "value-data" );
    ajax(
        "/api/skynodes".toLowerCase(),
        "remove-image",
        '{"id": "' + id + '", "filename": "' + value + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
            var parent = sender.parentNode.parentNode.parentNode;
            parent.removeChild( sender.parentNode.parentNode );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

///

const node_Certificates = ( id ) => {
    if (
        document.getElementById( "status-" + id ).innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + id )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            var txt = document.getElementById( "status-" + id ).innerText;
            if ( txt.trim() != "" ) {
                showError(
                    "Node is not ready - " +
                    document.getElementById( "status-" + id ).innerText
                );
            } else {
                showError( "Loading please wait" );
            }
        }
        return;
    }

    ajax(
        "/api/skynodes".toLowerCase(),
        "certificates",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Sky Node Certificates",
                j.payload,
                "",
                "Close",
                "modal-lg",
                () => {
                    //OK disabled
                },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const node_Images = ( id ) => {
    if (
        document.getElementById( "status-" + id ).innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + id )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            var txt = document.getElementById( "status-" + id ).innerText;
            if ( txt.trim() != "" ) {
                showError(
                    "Node is not ready - " +
                    document.getElementById( "status-" + id ).innerText
                );
            } else {
                showError( "Loading please wait" );
            }
        }
        return;
    }

    ajax(
        "/api/skynodes".toLowerCase(),
        "images",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Sky Node Images",
                j.payload,
                "Upload",
                "Close",
                "modal-lg",
                () => {
                    //Upload Image
                },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const node_Decomission = ( id ) => {
    if ( document.getElementById( "status-" + id ).innerText.indexOf( "READY" ) == -1 ) {
        if ( ( document.getElementById( "status-" + id ).innerText.indexOf( "{NEBULA}" ) == -1 ) ||
            ( document.getElementById( "status-" + id ).innerText.indexOf( "Deploy" ) != -1 ) ) {
            //delete node
            delete_Item( id, "Sky Nodes" );
        } else {
            var txt = document.getElementById( "status-" + id ).innerText;
            if ( txt.trim() != "" ) {
                showError(
                    "Node is not ready - " +
                    document.getElementById( "status-" + id ).innerText
                );
            } else {
                showError( "Loading please wait" );
            }
        }
        return;
    }

    ajax(
        "/api/skynodes".toLowerCase(),
        "decomission",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Decomission {ANYNODE}",
                j.payload,
                "Proceed",
                "Cancel",
                "",
                () => {
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }

                    if (
                        !document.getElementById( "cleardata" ).checked &&
                        !document.getElementById( "remove" ).checked
                    ) {
                        showInfo( "Nothing to do" );
                        return;
                    }
                    var dec = JSON.stringify( {
                        id: document.getElementById( "id" ).value,
                        wipe: document.getElementById( "cleardata" ).checked,
                        remove: document.getElementById( "remove" ).checked,
                    } );
                    document.getElementById( "okButton" ).innerHTML =
                        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "true" );
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "true" );

                    ajax(
                        "/api/skynodes".toLowerCase(),
                        "proceed-decomission",
                        dec,
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            document.getElementById( "okButton" ).innerHTML =
                                "Proceed";
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                        },
                        ( error ) => {
                            document.getElementById( "okButton" ).innerHTML =
                                "Proceed";
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const login1 = () => {
    var form = document.getElementById( "docform1" );
    form.classList.add( "was-validated" );
    if ( !form.checkValidity() ) {
        return;
    }
    var uname = document.getElementById( "uname" ).value;
    var upass = document.getElementById( "upass" ).value;
    var data = JSON.stringify( { username: uname, password: upass } );
    document.getElementById( 'uname' ).setAttribute( "disabled", "true" );
    document.getElementById( 'upass' ).setAttribute( "disabled", "true" );
    document.getElementById( 'loginbutton' ).setAttribute( "disabled", "true" );
    showInfo( "Please wait while we verify your credentials" );
    ajax(
        "/login",
        "login",
        data,
        ( success ) => {
            document.getElementById( 'uname' ).removeAttribute( "disabled" );
            document.getElementById( 'upass' ).removeAttribute( "disabled" );
            document.getElementById( 'loginbutton' ).removeAttribute( "disabled" );
            var j = JSON.parse( success );
            if ( j.result == "OK" ) {
                location.href = "session";
            } else if ( j.result == "setup" ) {
                document.getElementById( "qrcode" ).setAttribute( "src", j.qrcode );
                document.getElementById( "secret" ).innerText = j.secret;
                document.getElementById( "login1" ).style.display = "none";
                document.getElementById( "login2" ).style.display = "block";
                document.getElementById( "login3" ).style.display = "none";
            } else if ( j.result == "pincode" ) {
                document.getElementById( "login1" ).style.display = "none";
                document.getElementById( "login2" ).style.display = "none";
                document.getElementById( "login3" ).style.display = "block";
                setTimeout( () => {
                    document.getElementById( "pincode" ).focus();
                }, 250 );
            }
        },
        ( error ) => {
            document.getElementById( 'uname' ).removeAttribute( "disabled" );
            document.getElementById( 'upass' ).removeAttribute( "disabled" );
            document.getElementById( 'loginbutton' ).removeAttribute( "disabled" );
            var j = JSON.parse( error );
            //document.getElementById( "errormessage1" ).innerHTML = j.message;
            //document.getElementById( "errormessage1" ).style.display = "block";
            showError( j.message );
        }
    );
};

const login2 = () => {
    var uname = document.getElementById( "uname" ).value;
    var upass = document.getElementById( "upass" ).value;
    var sec = document.getElementById( "secret" ).innerText.trim();
    var data = JSON.stringify( {
        username: uname,
        password: upass,
        secret: sec,
    } );
    ajax(
        "/login",
        "storekey",
        data,
        ( success ) => {
            document.getElementById( "login1" ).style.display = "none";
            document.getElementById( "login2" ).style.display = "none";
            document.getElementById( "login3" ).style.display = "block";
            setTimeout( () => {
                document.getElementById( "pincode" ).focus();
            }, 250 );
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "errormessage2" ).innerHTML = j.message;
            document.getElementById( "errormessage2" ).style.display = "block";
        }
    );
};

const login3 = () => {
    var form = document.getElementById( "docform3" );
    form.classList.add( "was-validated" );
    if ( !form.checkValidity() ) {
        return;
    }
    var uname = document.getElementById( "uname" ).value;
    var upass = document.getElementById( "upass" ).value;
    var pin = document.getElementById( "pincode" ).value;
    var data = JSON.stringify( {
        username: uname,
        password: upass,
        pincode: pin,
    } );
    ajax(
        "/login",
        "validate",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.result == "OK" ) {
                location.href = "session";
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "errormessage3" ).innerHTML = j.message;
            document.getElementById( "errormessage3" ).style.display = "block";
        }
    );
};

const logout = () => {
    ajax( "/logout", "", "", ( success ) => {
        var j = JSON.parse( success );
        if ( j.result == "OK" ) {
            location.href = "session";
        }
    } );
};

const list = ( sender, spinner = false ) => {
    var scripts = document.getElementsByClassName( "coder" );
    while ( scripts[ 0 ] ) {
        scripts[ 0 ].parentNode.removeChild( scripts[ 0 ] );
    }

    var search = "";
    try {
        search = document.getElementById( "searchfor" ).value;
    } catch { }

    if ( spinner ) {
        //addSpinner();
    }

    if ( _LIST_ANIMATION ) {
        var el = document.getElementById( "container" );
        el.style.transition = 'opacity 0s';
        el.style.opacity = 0;
        document.getElementById( 'loadSpinner' ).style.display = "block";
    }

    ajax(
        "/api/" +
        sender.innerText
            .trim()
            .toLowerCase()
            .replace( / /g, "" )
            .toLowerCase(),
        "list",
        '{"search": "' + search + '"}',
        listRes,
        listRes
    );

    selectNav(
        sender,
        sender.innerText.trim().toLowerCase() == "start" ||
        sender.innerText.trim().toLowerCase() == "dashboard" ||
        //(sender.innerText.trim().toLowerCase() == "sky view") ||
        sender.innerText.trim().toLowerCase() == "nodes" ||
        sender.innerText.trim().toLowerCase() == "documentation" ||
        sender.innerText.trim().toLowerCase() == "apiandclireference" ||
        sender.innerText.trim().toLowerCase() == "tutorials"
    );
};

const listRes = ( data = null ) => {
    const dateObj = new Date();
    const month = dateObj.getUTCMonth() + 1;
    const year = dateObj.getUTCFullYear();

    var lice = false;
    try {
        if ( _lcm < month && _lcy < year ) {
            lice = true;
        } else if ( _lcy < year ) {
            lice = true;
        }
    } catch { }

    if ( lice ) {
        try {
            document.getElementById( 'licewarn' ).style.display = "block";
        } catch { }
    }

    if ( data != "" ) {
        var j = JSON.parse( data );
        if ( j.result != "ERR" ) {
            if ( j.payload.trim() != "" ) {
                var scrollTop = document.getElementById( "container-parent" ).scrollTop;

                if ( _LIST_ANIMATION ) {
                    var el = document.getElementById( "container" );
                    el.style.opacity = 0;
                    if ( document.getElementById( 'nav-title' ).innerText.trim() != "Start" ) {
                        document.getElementById( "container" ).innerHTML = "<div style='height: 85px;'>&nbsp;</div>" + j.payload;
                    } else {
                        document.getElementById( "container" ).innerHTML = j.payload;
                    }
                    void el.offsetWidth;
                    el.style.transition = 'opacity 0.3s';
                    setTimeout( () => {
                        el.style.opacity = 1;
                        document.getElementById( 'loadSpinner' ).style.display = "none";
                    }, 750 );
                } else {
                    if ( document.getElementById( 'nav-title' ).innerText.trim() != "Start" ) {
                        document.getElementById( "container" ).innerHTML = "<div style='height: 85px;'>&nbsp;</div>" + j.payload;
                    } else {
                        document.getElementById( "container" ).innerHTML = j.payload;
                    }
                    setTimeout( () => {
                        document.getElementById( 'loadSpinner' ).style.display = "none";
                    }, 550 );
                }

                var itemsCount = document.getElementsByClassName( 'card' ).length;
                setTimeout( () => {
                    document.getElementById( "container-parent" ).scrollTop = scrollTop;
                    var minCounter = 2;
                    if ( document.getElementById( 'nav-title' ).innerText.trim() == "Start" ) {
                        minCounter = 0;
                    }
                    if ( document.getElementById( 'nav-title' ).innerText.trim() == "Sky Link" ) {
                        minCounter = 3;
                    }
                    var itemsLabel = "Items";
                    if ( ( itemsCount - minCounter ) == 1 ) {
                        itemsLabel = "Item";
                    }
                    document.getElementById( 'items-count' ).innerText = ( itemsCount - minCounter ) + " " + itemsLabel;
                }, 500 );
                try {
                    document.getElementById( "searchfor" ).value = j.search;
                    searchCard();
                    adjustSizing();
                    setTimeout( () => {
                        //try {document.getElementsByClassName("card")[2].classList.add("selected");} catch {}
                        document.getElementById( "searchfor" ).focus();
                    }, 250 );
                } catch { }
                document.activeElement.blur();
            } else {
                addNothing();
                document.getElementById( 'items-count' ).innerText = "0 Items";
            }
        } else {
            addError( j.message );
            document.getElementById( 'items-count' ).innerText = "0 Items";
        }
    }
    hideSidebar();

    setTimeout( () => {
        var scripts = document.getElementsByClassName( "coder" );
        for ( i = 0; i < scripts.length; i++ ) {
            eval( scripts[ i ].innerHTML );
        }
        const boxImages = document.getElementsByClassName( "modal-image" );
        for ( i = 0; i < boxImages.length; i++ ) {
            boxImages[ i ].style.boxShadow = '0 3px 6px rgba(0, 0, 0, 0.16), 0 3px 6px rgba(0, 0, 0, 0.23)';
        }
    }, 100 );
};

const getNetworkList = ( sender, apiname, limited = false, instanceID = "" ) => {
    if ( sender.selectedIndex != -1 ) {
        var id = sender.options[ sender.selectedIndex ].value;
        document.getElementById(
            "networkspinner"
        ).innerHTML = `<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>`;
        ajax(
            "/api/" + apiname,
            "networklist",
            '{"id": "' + id + '", "instanceid": "' + instanceID + '"}',
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "network" ).innerHTML = j.payload;
                document.getElementById( "networkspinner" ).innerText = "Network";

                if ( apiname == "instances-xvm" ) {
                    document.getElementById( "boot" ).innerHTML = j.isolist;
                    document.getElementById( "gpu" ).innerHTML = j.gpulist;
                    setTimeout( () => {
                        var option = document.createElement( "option" );
                        option.text = "xcNET";
                        document.getElementById( "network" ).add( option );
                        var option = document.createElement( "option" );
                        option.text = "xcLAN";
                        document.getElementById( "network" ).add( option );
                    }, 500 );
                }
                if ( apiname == "instances-cn" || apiname == "instances-vm" ) {
                    if ( !limited ) {
                        document.getElementById( "os" ).innerHTML = j.isolist;
                        document.getElementById( "gpu" ).innerHTML = j.gpulist;
                    }

                    setTimeout( () => {
                        var option = document.createElement( "option" );
                        option.text = "xcNET";
                        document.getElementById( "network" ).add( option );
                        var option = document.createElement( "option" );
                        option.text = "xcLAN";
                        document.getElementById( "network" ).add( option );
                    }, 500 );
                }
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    } else {
        showError( "No compatible nodes found" );
    }
};

const getNodeStatus = ( statusID, nodeID ) => {
    ajax(
        "/api/skynodes".toLowerCase(),
        "node-status",
        '{"id": "' + nodeID + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( statusID ).innerHTML =
                '<span style="color: green;">' + j.message + "</span>";
            document.getElementById( "os-" + nodeID ).innerHTML =
                '<img src="assets/img/' +
                j.os +
                '.png" style="width: 20px;" title="' +
                ( ( j.os != "linux" ) ? j.os.toUpperCase() : 'AGENT FAILED' ) +
                '" />';
            var stats = JSON.parse( j.nodestats );

            var cl = "#1ebe54";
            if ( ( stats[ "cpu" ][ "load" ] * 100.001 ) / j.model[ "cpu" ] >= 92 ) {
                cl = "red";
                showError( "High CPU Usage Alert", 3000 );
            } else if (
                ( stats[ "cpu" ][ "load" ] * 100.001 ) / j.model[ "cpu" ] >= 80
            ) {
                showWarning( "High CPU Usage Warning", 3000 );
                cl = "orange";
            }
            if ( ( ( stats[ "cpu" ][ "load" ] * 100.001 ) / j.model[ "cpu" ] ).toFixed( 0 ) > 100 ) {
                var html =
                    '<div title="CPU Used %" class="pie" style="--c:' +
                    cl +
                    ";--p:" +
                    "100" +
                    '"> ' +
                    "100" +
                    "</div>";
            } else {
                var html =
                    '<div title="CPU Used %" class="pie" style="--c:' +
                    cl +
                    ";--p:" +
                    ( ( stats[ "cpu" ][ "load" ] * 100.001 ) / j.model[ "cpu" ] ).toFixed( 0 ) +
                    '"> ' +
                    ( ( stats[ "cpu" ][ "load" ] * 100.001 ) / j.model[ "cpu" ] ).toFixed( 0 ) +
                    "</div>";
            };
            var cl = "#1ebe54";
            if ( stats[ "mem" ][ "load" ] > 100 ) {
                stats[ "mem" ][ "load" ] = 100;
            }
            if ( stats[ "mem" ][ "load" ] >= 92 ) {
                cl = "red";
                showError( "High RAM Usage Alert", 3000 );
            } else if ( stats[ "mem" ][ "load" ] >= 80 ) {
                cl = "orange";
                showWarning( "High RAM Usage Warning", 3000 );
            }
            var html =
                html +
                " / " +
                '<div title="RAM Used %" class="pie" style="--c:' +
                cl +
                ";--p:" +
                stats[ "mem" ][ "load" ].toFixed( 0 ) +
                '"> ' +
                stats[ "mem" ][ "load" ].toFixed( 0 ) +
                "</div>";

            var cl = "#1ebe54";
            if ( stats[ "disk" ][ "used" ] > 100 ) {
                stats[ "disk" ][ "used" ] = 100;
            }
            if ( stats[ "disk" ][ "used" ] >= 92 ) {
                cl = "red";
                showError( "High DISK Usage Alert", 3000 );
            } else if ( stats[ "disk" ][ "used" ] >= 80 ) {
                cl = "orange";
                showWarning( "High DISK Usage Warning", 3000 );
            }
            var html =
                html +
                " / " +
                '<div title="DISK Used %" class="pie" style="--c:' +
                cl +
                ";--p:" +
                stats[ "disk" ][ "used" ].toFixed( 0 ) +
                '"> ' +
                stats[ "disk" ][ "used" ].toFixed( 0 ) +
                "</div>";

            html = "<span style='font-size: 1rem'>" + '&nbsp;&nbsp;<b> ' + j.model.cpu + '</b>&nbsp;&nbsp;' + " / " + '&nbsp;&nbsp;<b>' + j.model.mem.toFixed( 0 ) + '</b>&nbsp;&nbsp;' + " / " + '&nbsp;<b>' + j.model.disk + "</b></span><br>" + html;

            document.getElementById( "stats-" + nodeID ).innerHTML = html;

            document.getElementById( "statsmodel-" + nodeID ).innerHTML =
                "<span style='font-size: 0.75rem;'>" + j.model.model + "</span>";
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( statusID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
            document.getElementById( "os-" + nodeID ).innerHTML =
                '<img src="assets/img/linux.png" style="width: 20px;" title="ATTENTION" />';
            document.getElementById( "stats-" + nodeID ).innerHTML =
                "N.A. / N.A. / N.A.";
        }
    );
};

const getSAPIfromID = ( id = "" ) => {
    if ( id.startsWith( "V7st-" ) ) { return "solutionstacks"; }
    if ( id.startsWith( "V7dt-" ) ) { return "desktops"; }
    if ( id.startsWith( "V7cs-" ) ) { return "codespaces"; }
    if ( id.startsWith( "V7vm-" ) ) { return "instances-vm"; }
    if ( id.startsWith( "V7dm-" ) ) { return "magna-nodes"; }
    if ( id.startsWith( "V7ds-" ) ) { return "datastream"; }
    if ( id.startsWith( "V7sp-" ) ) { return "dataspark-nodes"; }
    if ( id.startsWith( "V7db-" ) ) { return "databright"; }
    if ( id.startsWith( "V7lm-" ) ) { return "ingeniallm"; }
    if ( id.startsWith( "V7ss-" ) ) { return "datainsight"; }
    if ( id.startsWith( "V7sr-" ) ) { return "dataspark-solaris"; }
    if ( id.startsWith( "V7xvm-" ) ) { return "instances-xvm"; }
    if ( id.startsWith( "V7ag-" ) ) { return "accessgates"; }
    return "instances-cn";
};

const getContainerStatus = ( cloudID, containerID, ipID, statusID ) => {
    var sapi = document.getElementById( "nav-title" ).innerText.trim().replace( / /g, "" ).toLowerCase();
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( containerID );
    }
    ajax(
        "/api/" + sapi,
        "status",
        '{"cloudid": "' + cloudID + '", "containerid": "' + containerID + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( ipID ).innerHTML = j.ipaddress.replace( /,/g, "<br>" );
            document.getElementById( statusID ).innerHTML = j.status;
            document.getElementById( "os-" + containerID ).innerHTML =
                '<img src="assets/img/' +
                j.os +
                '.png" style="width: 20px;" title="' +
                ( ( j.os != "linux" ) ? j.os.toUpperCase() : 'AGENT FAILED' ) +
                '" />';

            var cpuLabel = "CPU Used %";
            if ( !containerID.startsWith( "V7vm-" ) ) {
                cpuLabel = "CPU Impact %";
            }

            var html = "";
            var cl = "#1ebe54";
            if ( j.cpuStat >= 92 ) {
                cl = "red";
                showError( "High CPU Usage Alert", 3000 );
            } else if ( j.cpuStat >= 80 ) {
                showWarning( "High CPU Usage Warning", 3000 );
                cl = "orange";
            }
            html =
                html +
                '&nbsp;&nbsp;-&nbsp;&nbsp;<div title="' +
                cpuLabel +
                '" class="pie" style="--c:' +
                cl +
                ";--p:" +
                j.cpuStat +
                '">' +
                j.cpuStat +
                "</div> /";

            var cl = "#1ebe54";
            if ( j.memStat >= 92 ) {
                cl = "red";
                showError( "High RAM Usage Alert", 3000 );
            } else if ( j.memStat >= 80 ) {
                showWarning( "High RAM Usage Warning", 3000 );
                cl = "orange";
            }
            html =
                html +
                '&nbsp;&nbsp;<div title="RAM Used %" class="pie" style="--c:' +
                cl +
                ";--p:" +
                j.memStat +
                '">' +
                j.memStat +
                "</div> /";

            var cl = "#1ebe54";
            if ( j.diskStat >= 92 ) {
                cl = "red";
                showError( "High DISK Usage Alert", 3000 );
            } else if ( j.diskStat >= 80 ) {
                showWarning( "High DISK Usage Warning", 3000 );
                cl = "orange";
            }
            html =
                html +
                '&nbsp;&nbsp;<div title="DISK Used %" class="pie" style="--c:' +
                cl +
                ";--p:" +
                j.diskStat +
                '">' +
                j.diskStat +
                "</div>";

            document.getElementById( "stats-" + containerID ).innerHTML = html;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( ipID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
            document.getElementById( statusID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
            document.getElementById( "os-" + containerID ).innerHTML =
                '<img src="assets/img/' +
                j.os +
                '.png" style="width: 20px;" title="' +
                ( ( j.os != "linux" ) ? j.os.toUpperCase() : 'AGENT FAILED' ) +
                '" />';
            document.getElementById( "stats-" + containerID ).innerHTML = "";
        }
    );
    try {
        if (
            document
                .getElementById( "appName-" + containerID )
                .getAttribute( "data-isapp" ) == "1"
        ) {
            document.getElementById( "openApp-" + containerID ).style.display = "block";
        } else {
            document.getElementById( "openApp-" + containerID ).style.display = "none";
        }
    } catch { }
};

const getAvailableVPNPeers = () => {
    if ( document.getElementById( "cloudnode" ).options.length > 0 ) {
        document.getElementById(
            "peerspinner"
        ).innerHTML = `<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>`;
        document.getElementById( "peer" ).innerHTML = "";
        var cloudID =
            document.getElementById( "cloudnode" ).options[
                document.getElementById( "cloudnode" ).selectedIndex
            ].value;
        ajax(
            "/api/vpnmanager",
            "peerlist",
            JSON.stringify( { cloudnode: cloudID } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "peer" ).innerHTML = j.payload;
                document.getElementById( "peerspinner" ).innerHTML =
                    "Available Peers";
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    }
};

const getVirtualMachineStatus = ( cloudID, vmID, macID, ipID, statusID ) => {
    ajax(
        "/api/instances-xvm",
        "status",
        '{"cloudid": "' +
        cloudID +
        '", "vmid": "' +
        vmID +
        '", "mac": "' +
        macID +
        '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( ipID ).innerHTML = j.ipaddress;
            document.getElementById( statusID ).innerHTML = j.status;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( ipID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
            document.getElementById( statusID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
        }
    );
};

const getPrivateNetworkStatus = ( cloudID, networkID, statusID ) => {
    ajax(
        "/api/privatenetwork",
        "status",
        '{"cloudid": "' + cloudID + '", "networkid": "' + networkID + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( statusID ).innerHTML = j.status;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( statusID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
        }
    );
};

const getNameServerStatus = ( itemID, statusID ) => {
    ajax(
        "/api/nameserver",
        "status",
        '{"id": "' + itemID + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( statusID ).innerHTML = j.status;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( statusID ).innerHTML =
                '<span style="color: red;">' + j.message + "</span>";
        }
    );
};

const CheckPassword = ( inputtxt ) => {
    var passw = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,30}$/;
    if ( inputtxt.match( passw ) ) {
        return true;
    } else {
        return false;
    }
};

const explainer_video = ( tag ) => {
    showExplainer( tag, "Hello World" );
};

const changePassword = () => {
    ajax(
        "/api/passwd",
        "pwd",
        null,
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Change Password",
                j.payload,
                "Change",
                "Cancel",
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var pass1 = document.getElementById( "pass1" ).value;
                    var pass2 = document.getElementById( "pass2" ).value;
                    var oldpass = document.getElementById( "current" ).value;
                    if ( !CheckPassword( pass1 ) ) {
                        showError(
                            "The password does not meet the policy requirements."
                        );
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Change";
                        return;
                    }
                    if ( pass1 != pass2 ) {
                        showError( "Password don't match" );
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Change";
                        return;
                    }
                    ajax(
                        "/api/passwd",
                        "change",
                        JSON.stringify( { pwd: pass1, old: oldpass } ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const changeTheme = ( userEmail ) => {
    ajax(
        "/api/identities",
        "theme",
        JSON.stringify( { email: userEmail } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Change Theme",
                j.payload,
                "Save",
                "Cancel",
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "identities" );
                    ajax(
                        "/api/identities",
                        "save",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            setTimeout( () => {
                                showSuccess( j.payload );
                                location.reload();
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const new_Item = ( id, api ) => {
    document.getElementsByClassName( "modal-dialog" )[ 0 ].style.width = "";
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    ajax(
        "/api/" + sapi,
        "new",
        null,
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            mSize = "";
            if ( okCaption == "Deploy" ) {
                mSize = "modal-xl";
            }
            if ( sapi == "vpnmanager" ) {
                mSize = "modal-lg";
                okCaption = "Save";
            }
            if ( sapi == "roles" ) {
                mSize = "modal-lg";
            }
            if ( sapi == "secretkeys" ) {
                mSize = "modal-lg";
            }
            if ( sapi == "icstickets" ) {
                mSize = "modal-lg";
            }
            if ( sapi == "siemcollector" ) {
                mSize = "modal-lg";
            }
            showModal(
                api,
                j.payload,
                okCaption,
                cancelCaption,
                mSize,
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( api );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        try {
                            document.getElementById(
                                "deploy-status"
                            ).style.display = "none";
                        } catch { }
                        return;
                    }
                    if (
                        sapi == "serverless-fx" ||
                        sapi == "serverless-spark" ||
                        sapi == "serverless-flow" ||
                        sapi == "serverless-api" ||
                        sapi == "objectstorage" ||
                        sapi == "notificationgate" ||
                        sapi == "secretkeys" ||
                        sapi == "nameserver" ||
                        sapi == "rapidstorage"
                    ) {
                        var uniqueNames =
                            document.getElementsByClassName( "uniqueName" );
                        for ( i = 0; i < uniqueNames.length; i++ ) {
                            if (
                                uniqueNames[ i ].innerText.trim() ==
                                data.name.trim()
                            ) {
                                showError( "Item already exists" );
                                document
                                    .getElementById( "cancelButton" )
                                    .removeAttribute( "disabled" );
                                document
                                    .getElementById( "okButton" )
                                    .removeAttribute( "disabled" );
                                document.getElementById( "okButton" ).innerHTML =
                                    okCaption;
                                return;
                            }
                            try {
                                if (
                                    uniqueNames[ i ].innerText.trim() ==
                                    "RUN (" + data.serviceport.trim() + ")"
                                ) {
                                    showError( "Port already exists" );
                                    document
                                        .getElementById( "cancelButton" )
                                        .removeAttribute( "disabled" );
                                    document
                                        .getElementById( "okButton" )
                                        .removeAttribute( "disabled" );
                                    document.getElementById(
                                        "okButton"
                                    ).innerHTML = okCaption;
                                    return;
                                }
                            } catch { }
                        }
                    }
                    if (
                        sapi == "instances-cn" ||
                        sapi == "magna-nodes" ||
                        sapi == "instances-vm" ||
                        sapi == "databright" ||
                        sapi == "datainsight" ||
                        sapi == "codespaces" ||
                        sapi == "datastream" ||
                        sapi == "desktops" ||
                        sapi == "accessgates" ||
                        sapi == "dataspark-nodes" ||
                        sapi == "dataspark-solaris" ||
                        sapi == "kubernetesmachines"
                    ) {
                        showInfo(
                            "provisioning instance, this might take a minute..."
                        );
                    }
                    if ( sapi == "ingeniallm" ) {
                        showInfo(
                            "provisioning instance, this might take a while depending on the size of the model..."
                        );
                    }
                    if ( sapi == "identities" ) {
                        if (
                            !CheckPassword(
                                document.getElementById( "upass" ).value
                            )
                        ) {
                            showError(
                                "The password does not meet the policy requirements."
                            );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            return;
                        }
                    }
                    ajax(
                        "/api/" + sapi,
                        "save",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                            try {
                                document.getElementById(
                                    "deploy-status"
                                ).style.display = "none";
                            } catch { }
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            try {
                document.getElementById( "deploy-status" ).style.display = "none";
            } catch { }
        }
    );
};

const edit_Item = ( id, api, itemType = "" ) => {
    document.getElementsByClassName( "modal-dialog" )[ 0 ].style.width = "";

    if ( itemType != "" ) {
        if ( itemType == "X Virtual Machine Disk" ) {
            showError( "Can not open a X Virtual Machine Disk" );
            return;
        }
    }
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    if ( itemType == "node" ) {
        sapi = "skynodes";
    }
    var apicmd = "edit";
    if ( id.indexOf( "***" ) != -1 ) {
        id = id.replace( "***", "" );
        apicmd = "config";
    }
    var mSize = "";
    var okButton = "Update";
    var closeButton = "Cancel";
    if ( sapi == "vpnmanager" ) {
        mSize = "modal-lg";
    }
    if ( sapi == "serverless-fx" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "serverless-spark" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "serverless-flow" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "serverless-api" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "siemcollector" ) {
        mSize = "modal-lg";
        okButton = "Update";
        var closeButton = "Cancel";
    }
    if ( sapi == "systemwatch" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "flow-fx" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
    }
    if ( sapi == "serverless-json" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
    }
    if ( sapi == "serverless-sql" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
    }
    if ( sapi == "repositories" ) {
        mSize = "modal-fullscreen";
        okButton = "Save";
        var closeButton = "Close";
        api = "&nbsp;";
    }
    if ( sapi == "objectstorage" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
        api = "&nbsp;";
    }
    if ( sapi == "magna-buckets" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
        api = "&nbsp;";
    }
    if ( sapi == "rapidstorage" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
        api = "&nbsp;";
    }
    if ( sapi == "blockstorage" ) {
        mSize = "modal-fullscreen";
        okButton = "";
        var closeButton = "Close";
        api = "&nbsp;";
    }
    if ( sapi == "roles" ) {
        mSize = "modal-lg";
    }
    if ( sapi == "secretkeys" ) {
        mSize = "modal-lg";
    }
    if ( sapi == "icstickets" ) {
        mSize = "modal-lg";
    }
    if ( api == "Start" ) {
        api = "Edit";
    }
    ajax(
        "/api/" + sapi,
        apicmd,
        JSON.stringify( { id: id } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                api,
                j.payload,
                okButton,
                closeButton,
                mSize,
                () => {
                    //save

                    if (
                        ( sapi == "instances-xvm" ||
                            sapi == "instances-cn" ||
                            sapi == "instances-vm" ||
                            sapi == "codespaces" ||
                            sapi == "solutionstacks" ||
                            sapi == "magna-nodes" ||
                            sapi == "databright" ||
                            sapi == "ingeniallm" ||
                            sapi == "datastream" ||
                            sapi == "dataspark-nodes" ||
                            sapi == "datainsight" ||
                            sapi == "dataspark-solaris" ||
                            sapi == "desktops" ) &&
                        apicmd != "config"
                    ) {
                        if (
                            document.getElementById( "status-" + id ).innerText ==
                            "RUNNING"
                        ) {
                            showError( "Please stop the instance to update" );
                            return;
                        }
                    }

                    if ( sapi == "identities" ) {
                        if (
                            !CheckPassword(
                                document.getElementById( "upass" ).value
                            )
                        ) {
                            showError(
                                "The password does not meet the policy requirements."
                            );
                            return;
                        }
                    }

                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( api );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Update";
                        return;
                    }
                    var savecmd = "save";
                    if ( apicmd != "edit" ) {
                        savecmd = "save" + apicmd;
                    }
                    ajax(
                        "/api/" + sapi,
                        savecmd,
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Update";
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    if (
                        sapi == "serverless-fx" ||
                        sapi == "serverless-spark" ||
                        sapi == "serverless-flow" ||
                        sapi == "repositories"
                    ) {
                        if ( window[ "editorchanged" ] ) {
                            document.getElementById(
                                "super-modal-back"
                            ).style.display = "block";
                            document.getElementById(
                                "super-modal-text"
                            ).innerText =
                                "The changes you made will be lost since this function hasn't been saved or deployed yet, continue?";
                            document.getElementById( "super-modal" ).style.top =
                                "0px";
                            document.getElementById( "smNOButton" ).focus();
                            document.getElementById( "smOKButton" ).onclick = (
                                e
                            ) => {
                                window[ "editorchanged" ] = false;
                                document.getElementById(
                                    "super-modal-back"
                                ).style.display = "none";
                                document.getElementById(
                                    "super-modal"
                                ).style.top = "-180px";
                                document.getElementById( "quitButton" ).click();
                            };
                            document.getElementById( "smNOButton" ).onclick = (
                                e
                            ) => {
                                document.getElementById(
                                    "super-modal-back"
                                ).style.display = "none";
                                document.getElementById(
                                    "super-modal"
                                ).style.top = "-180px";
                                return;
                            };
                            return;
                        }
                    }
                    if ( sapi == "flow-fx" ) {
                        if ( window[ "flowchanged" ] ) {
                            document.getElementById(
                                "super-modal-back"
                            ).style.display = "block";
                            document.getElementById(
                                "super-modal-text"
                            ).innerText =
                                "The changes you made will be lost since this flow hasn't been saved yet, continue?";
                            document.getElementById( "super-modal" ).style.top =
                                "0px";
                            document.getElementById( "smNOButton" ).focus();
                            document.getElementById( "smOKButton" ).onclick = (
                                e
                            ) => {
                                window[ "editorchanged" ] = false;
                                document.getElementById(
                                    "super-modal-back"
                                ).style.display = "none";
                                document.getElementById(
                                    "super-modal"
                                ).style.top = "-180px";
                                document.getElementById( "quitButton" ).click();
                            };
                            document.getElementById( "smNOButton" ).onclick = (
                                e
                            ) => {
                                document.getElementById(
                                    "super-modal-back"
                                ).style.display = "none";
                                document.getElementById(
                                    "super-modal"
                                ).style.top = "-180px";
                                return;
                            };
                            return;
                        }
                    }
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const delete_Item = ( id, api ) => {
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    var delMessage = "";
    if ( _DELETE_CONFIRM_CODE ) {
        delMessage = `<b>You are about to perform an <span style="color: red;">ireversable delete operation</span> which might result in data loss.</b>
                    <br><br>
                    Please confirm this operation by entering the code below.
                    <br><br>
                    Confirmation Code
                    <input type="text" class="form-control rounded-0 mb-3" value="${id}" style="border: none; background: none; cursor: text;" disabled>
                    <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0 mb-0" id="delete-confirmation" placeholder="Enter Confirmation Code">
                    `;
    } else {
        delMessage = `<b>You are about to perform an <span style="color: red;">ireversable delete operation</span> which might result in data loss.</b><br><br>Do you want to continue?`;
    }

    showModal(
        document.getElementById( "nav-title" ).innerText + " Delete Operation",
        delMessage,
        "Delete",
        "Cancel",
        "",
        () => {
            if ( _DELETE_CONFIRM_CODE ) {
                if (
                    document.getElementById( "delete-confirmation" ).value != id
                ) {
                    showError( "Confirmation Code is not correct." );
                    return;
                }
            }
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
            ajax(
                "/api/" + sapi,
                "delete",
                JSON.stringify( { id: id } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "quitButton" ).click();
                    list( document.getElementById( "nav-title" ), false );
                    setTimeout( () => {
                        showSuccess( j.payload );
                    }, 500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        showError( j.message );
                    }, 500 );
                }
            );
        },
        () => {
            //cancel
            document.getElementById( "quitButton" ).click();
        }
    );
};

const setup_Wine = ( id ) => {
    ajax( "/api/desktops".toLowerCase(), "wine", '{"id":"' + id + '"}', ( dialog ) => {
        var j = JSON.parse( dialog );
        showModal(
            "Install Wine",
            j.payload,
            "Install", "Cancel", "",
            () => {
                //save
                document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
                var data = {
                    id: document.getElementById( 'id' ).value,
                    operator: document.getElementById( 'operator' ).value
                };
                ajax(
                    "/api/desktops",
                    "install-wine",
                    JSON.stringify( data ),
                    ( success ) => {
                        var j = JSON.parse( success );
                        document.getElementById( "quitButton" ).click();
                        setTimeout( () => {
                            showSuccess( j.payload );
                        }, 500 );
                    },
                    ( error ) => {
                        document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML = "Install";
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                //cancel
                document.getElementById( "quitButton" ).click();
            }
        );
    } );
};

const start_Progress = ( id ) => {
    _progress_TT = setInterval( () => {
        ajax(
            "/api/skynodes".toLowerCase(),
            "progress",
            JSON.stringify( { id: id } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "depprogress" ).style.width =
                    j.progress + "%";
                document
                    .getElementById( "depprogress" )
                    .setAttribute( "aria-valuenow", j.progress );
                document.getElementById( "deptext" ).innerHTML =
                    j.progress.trim() + "% - " + j.text.trim();
            },
            ( error ) => {
                //do nothing - suppress reboot errors
            }
        );
    }, 5000 );
};

const stop_Progress = () => {
    clearInterval( _progress_TT );
};

const deploy_V7PSCloud = ( id ) => {
    if ( document.getElementById( "status-" + id ).innerText.indexOf( "Deploy Nebula" ) == -1 ) {
        showError(
            "Nebula is already deployed"
        );
        return;
    }

    ajax(
        "/api/skynodes".toLowerCase(),
        "deploy",
        JSON.stringify( { id: id } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var DEPLOYOS = j.deployos;
            showModal(
                "{NEBULA}",
                j.payload,
                "Deploy",
                "Cancel",
                "modal-lg",
                () => {
                    //save
                    if (
                        document.getElementById( "okButton" ).innerText.trim() !=
                        "Deploy"
                    ) {
                        return;
                    }

                    if ( !document.getElementById( "license" ).checked ) {
                        showError( "Please accept the license agreement" );
                        return;
                    }

                    document.getElementById( "deploying" ).style.display =
                        "block";
                    document.getElementById( "depstatus" ).style.display =
                        "block";
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );

                    start_Progress( id );

                    ajax(
                        "/api/skynodes".toLowerCase(),
                        "install-step1",
                        JSON.stringify( { id: id, os: DEPLOYOS } ),
                        ( step1 ) => {
                            var msg1 = JSON.parse( step1 );
                            document.getElementById( "logs" ).value =
                                document.getElementById( "logs" ).value +
                                msg1.logs;

                            ajax(
                                "/api/skynodes".toLowerCase(),
                                "install-step2",
                                JSON.stringify( { id: id, os: DEPLOYOS } ),
                                ( step2 ) => {
                                    var msg2 = JSON.parse( step2 );
                                    document.getElementById( "logs" ).value =
                                        document.getElementById( "logs" ).value +
                                        msg2.logs;

                                    ajax(
                                        "/api/skynodes".toLowerCase(),
                                        "install-step3",
                                        JSON.stringify( {
                                            id: id,
                                            os: DEPLOYOS,
                                        } ),
                                        ( step3 ) => {
                                            var msg3 = JSON.parse( step3 );
                                            document.getElementById(
                                                "logs"
                                            ).value =
                                                document.getElementById( "logs" )
                                                    .value + msg3.logs;

                                            ajax(
                                                "/api/skynodes".toLowerCase(),
                                                "install-step4",
                                                JSON.stringify( {
                                                    id: id,
                                                    os: DEPLOYOS,
                                                } ),
                                                ( step4 ) => {
                                                    stop_Progress();
                                                    var msg4 =
                                                        JSON.parse( step4 );
                                                    document.getElementById(
                                                        "deptext"
                                                    ).innerHTML = msg4.payload;
                                                    document
                                                        .getElementById(
                                                            "depprogress"
                                                        )
                                                        .classList.remove(
                                                            "bg-info"
                                                        );
                                                    document
                                                        .getElementById(
                                                            "depprogress"
                                                        )
                                                        .classList.add(
                                                            "bg-success"
                                                        );
                                                    document.getElementById(
                                                        "depprogress"
                                                    ).style.width = "100%";
                                                    document
                                                        .getElementById(
                                                            "depprogress"
                                                        )
                                                        .setAttribute(
                                                            "aria-valuenow",
                                                            "100"
                                                        );
                                                    document.getElementById(
                                                        "okButton"
                                                    ).style.display = "none";
                                                    document.getElementById(
                                                        "cancelButton"
                                                    ).innerHTML = "Finish";
                                                    document
                                                        .getElementById(
                                                            "cancelButton"
                                                        )
                                                        .removeAttribute(
                                                            "disabled"
                                                        );
                                                    document.getElementById(
                                                        "logs"
                                                    ).value =
                                                        document.getElementById(
                                                            "logs"
                                                        ).value + msg4.logs;
                                                },
                                                ( err4 ) => {
                                                    stop_Progress();
                                                    document
                                                        .getElementById(
                                                            "cancelButton"
                                                        )
                                                        .removeAttribute(
                                                            "disabled"
                                                        );
                                                    document
                                                        .getElementById(
                                                            "okButton"
                                                        )
                                                        .removeAttribute(
                                                            "disabled"
                                                        );
                                                    document.getElementById(
                                                        "okButton"
                                                    ).innerHTML = "Deploy";
                                                    var j = JSON.parse( err4 );
                                                    showError( j.message );
                                                    document.getElementById(
                                                        "deptext"
                                                    ).innerHTML =
                                                        '<div style="color: red; text-align: left;">ERROR: ' +
                                                        j.message +
                                                        "</div>";
                                                    document.getElementById(
                                                        "logs"
                                                    ).value =
                                                        document.getElementById(
                                                            "logs"
                                                        ).value + j.logs;
                                                }
                                            );
                                        },
                                        ( err3 ) => {
                                            stop_Progress();
                                            document
                                                .getElementById( "cancelButton" )
                                                .removeAttribute( "disabled" );
                                            document
                                                .getElementById( "okButton" )
                                                .removeAttribute( "disabled" );
                                            document.getElementById(
                                                "okButton"
                                            ).innerHTML = "Deploy";
                                            var j = JSON.parse( err3 );
                                            showError( j.message );
                                            document.getElementById(
                                                "deptext"
                                            ).innerHTML =
                                                '<div style="color: red; text-align: left;">ERROR: ' +
                                                j.message +
                                                "</div>";
                                            document.getElementById(
                                                "logs"
                                            ).value =
                                                document.getElementById( "logs" )
                                                    .value + j.logs;
                                        }
                                    );
                                },
                                ( err2 ) => {
                                    stop_Progress();
                                    document
                                        .getElementById( "cancelButton" )
                                        .removeAttribute( "disabled" );
                                    document
                                        .getElementById( "okButton" )
                                        .removeAttribute( "disabled" );
                                    document.getElementById(
                                        "okButton"
                                    ).innerHTML = "Deploy";
                                    var j = JSON.parse( err2 );
                                    showError( j.message );
                                    document.getElementById(
                                        "deptext"
                                    ).innerHTML =
                                        '<div style="color: red; text-align: left;">ERROR: ' +
                                        j.message +
                                        "</div>";
                                    document.getElementById( "logs" ).value =
                                        document.getElementById( "logs" ).value +
                                        j.logs;
                                }
                            );
                        },
                        ( err1 ) => {
                            stop_Progress();
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Deploy";
                            var j = JSON.parse( err1 );
                            showError( j.message );
                            document.getElementById( "deptext" ).innerHTML =
                                '<div style="color: red; text-align: left;">ERROR: ' +
                                j.message +
                                "</div>";
                            document.getElementById( "logs" ).value =
                                document.getElementById( "logs" ).value + j.logs;
                        }
                    );
                },
                () => {
                    //cancel
                    if (
                        document
                            .getElementById( "cancelButton" )
                            .innerText.trim() == "Finish"
                    ) {
                        ajax(
                            "/api/skynodes".toLowerCase(),
                            "install-step5",
                            JSON.stringify( { id: id } ),
                            ( success ) => {
                                var j = JSON.parse( success );
                                showSuccess( j.payload );
                            }
                        );
                    }
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_CloudConsole = ( id ) => {
    var asUser = false;
    if (
        document.getElementById( "status-" + id ).innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + id )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            showError(
                "Node is not ready - " +
                document.getElementById( "status-" + id ).innerText
            );
        }
        return;
    }
    if (
        document
            .getElementById( "status-" + id )
            .innerText.indexOf( "root enabled" ) == -1
    ) {
        asUser = true;
    }
    var forceNewTab = false;
    if ( event.shiftKey ) {
        forceNewTab = true;
    }
    ajax(
        "/api/skynodes".toLowerCase(),
        "console",
        JSON.stringify( { id: id, systemuser: asUser } ),
        ( success ) => {
            var j = JSON.parse( success );
            var user = j.username;
            var pass = j.password;
            var address = j.address;
            var tabAddress = `${address}?username=${user}&password=${pass}`;
            var randName = ( Math.random() + 1 ).toString( 36 ).substring( 7 );
            var frame = `
                <iframe name="${randName}" src="${address}?username=${user}&password=${pass}"
                    style="width: 100%; height: 98.75%; background-color: #000000; border: solid 3px #000000; margin:0; padding:0; overflow:hidden;">
                    Your browser doesn't support iframes
                </iframe>
                `;
            if ( j.console == "frame" && !forceNewTab ) {
                showConsole( "Console Session: <b>" + j.ip + "</b>", frame );
            } else {
                window.open( tabAddress );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_InstanceConsole = ( id, apiname, ip, instanceID ) => {
    var sapi = apiname.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( instanceID );
    }
    if ( ip.trim().indexOf( "\n" ) != -1 ) {
        ip = ip.trim().split( "\n" )[ 1 ];
    }
    if ( sapi == "instances-cn" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "instances-vm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "solutionstacks" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "magna-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "databright" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datastream" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datainsight" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-solaris" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "desktops" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "codespaces" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "accessgates" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "ingeniallm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else {
        if ( ip.trim() != "RUNNING" && sapi != "instances-xvm" ) {
            showError( "Please start virtual machine first" );
            return;
        }
    }
    var forceNewTab = false;
    if ( event.shiftKey ) {
        forceNewTab = true;
    }
    ajax(
        "/api/" + sapi,
        "console",
        JSON.stringify( { id: id, ip: ip, instanceID: instanceID } ),
        ( success ) => {
            var j = JSON.parse( success );
            var user = j.username;
            var pass = j.password;
            var address = j.address;
            var tabAddress = `${address}?username=${user}&password=${pass}`;
            var randName = ( Math.random() + 1 ).toString( 36 ).substring( 7 );
            var frame = `
                <iframe name="${randName}" src="${address}?username=${user}&password=${pass}"
                    style="width: 100%; height: 98.75%; background-color: #000000; border: solid 3px #000000; margin:0; padding:0; overflow:hidden;">
                    Your browser doesn't support iframes
                </iframe>
                `;
            if ( j.console == "frame" && !forceNewTab ) {
                showConsole( "Console Session: <b>" + j.name + "</b>", frame );
            } else {
                window.open( tabAddress );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const edit_AccessPoints = ( agID ) => {
    ajax( "/api/accessgates", "accesspoints", JSON.stringify( { id: agID } ),
        ( success ) => {
            var j = JSON.parse( success );
            showModal( "Access Points", j.payload, "Save", "Cancel", "modal-lg",
                ( ok ) => {
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );

                    var ipsData = "";
                    var list = document.getElementsByClassName( 'listitem' );
                    for ( i = 0; i < list.length; i++ ) {
                        if ( ipsData == "" ) {
                            ipsData = list[ i ].value;
                        } else {
                            ipsData = ipsData + "," + list[ i ].value;
                        }
                    }
                    var data = {
                        id: document.getElementById( 'id' ).value,
                        operator: document.getElementById( 'operator' ).value,
                        ips: ipsData
                    };
                    ajax( "/api/accessgates", "set-accesspoints", JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );

                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                        }
                    );
                },
                ( cancel ) => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const edit_Routes = ( agID ) => {
    ajax( "/api/accessgates", "routes", JSON.stringify( { id: agID } ),
        ( success ) => {
            var j = JSON.parse( success );
            showModal( "Routes", j.payload, "Save", "Cancel", "modal-lg",
                ( ok ) => {
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );

                    var ipsData = "";
                    var list = document.getElementsByClassName( 'listitem' );
                    for ( i = 0; i < list.length; i++ ) {
                        if ( ipsData == "" ) {
                            ipsData = list[ i ].value;
                        } else {
                            ipsData = ipsData + "," + list[ i ].value;
                        }
                    }
                    var data = {
                        id: document.getElementById( 'id' ).value,
                        operator: document.getElementById( 'operator' ).value,
                        ips: ipsData
                    };
                    ajax( "/api/accessgates", "set-routes", JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );

                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                        }
                    );
                },
                ( cancel ) => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_InstanceConsoleVnc = ( id, apiname, ip, instanceID ) => {
    var sapi = apiname.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( instanceID );
    }
    if ( sapi == "instances-cn" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "instances-vm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "solutionstacks" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "desktops" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "magna-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "databright" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datastream" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datainsight" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-solaris" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "codespaces" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "ingeniallm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else {
        if ( ip.trim() != "RUNNING" ) {
            showError( "Please start virtual machine first" );
            return;
        }
    }
    var forceNewTab = false;
    if ( event.shiftKey ) {
        forceNewTab = true;
    }
    ajax(
        "/api/" + sapi,
        "console-vnc",
        JSON.stringify( { id: id, ip: ip, instanceID: instanceID } ),
        ( success ) => {
            var j = JSON.parse( success );
            var user = j.username;
            var pass = j.password;
            var address = j.address;
            var tabAddress = `${address}?username=${user}&password=${pass}`;
            var randName = ( Math.random() + 1 ).toString( 36 ).substring( 7 );
            var frame = `
                <iframe name="${randName}" src="${address}?username=${user}&password=${pass}"
                    style="width: 100%; height: 98.75%; background-color: #000000; border: solid 3px #000000; margin:0; padding:0; overflow:hidden;">
                    Your browser doesn't support iframes
                </iframe>
                `;
            if ( j.console == "frame" && !forceNewTab ) {
                showConsole( "Console Session: <b>" + j.name + "</b>", frame );
            } else {
                window.open( tabAddress );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_InstanceConsoleRdp = ( id, apiname, ip, instanceID ) => {
    var sapi = apiname.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( instanceID );
    }
    if ( sapi == "instances-cn" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "instances-vm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "solutionstacks" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "desktops" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "magna-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "databright" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datastream" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-nodes" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "datainsight" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "dataspark-solaris" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "codespaces" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else if ( sapi == "ingeniallm" ) {
        if ( ip.trim() == "" ) {
            showError( "No IP visible, can not connect" );
            return;
        }
    } else {
        if ( ip.trim() != "RUNNING" ) {
            showError( "Please start virtual machine first" );
            return;
        }
    }
    var forceNewTab = false;
    if ( event.shiftKey ) {
        forceNewTab = true;
    }
    ajax(
        "/api/" + sapi,
        "console-rdp",
        JSON.stringify( { id: id, ip: ip, instanceID: instanceID } ),
        ( success ) => {
            var j = JSON.parse( success );
            var user = j.username;
            var pass = j.password;
            var address = j.address;
            var tabAddress = `${address}?username=${user}&password=${pass}`;
            var randName = ( Math.random() + 1 ).toString( 36 ).substring( 7 );
            var frame = `
                <iframe name="${randName}" src="${address}?username=${user}&password=${pass}"
                    style="width: 100%; height: 98.75%; background-color: #000000; border: solid 3px #000000; margin:0; padding:0; overflow:hidden;">
                    Your browser doesn't support iframes
                </iframe>
                `;
            if ( j.console == "frame" && !forceNewTab ) {
                showConsole( "Console Session: <b>" + j.name + "</b>", frame );
            } else {
                window.open( tabAddress );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const cmd_Instance = ( id, apiname, cmd ) => {
    var sapi = apiname.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    if ( cmd == "stop" ) {
        if ( document.getElementById( "status-" + id ).innerText == "STOPPED" ) {
            showError( "Instance already stopped" );
            return;
        }
        showModal(
            "Stop Instance",
            "You are about to stop an instance, continue?",
            "Stop",
            "Cancel",
            "",
            () => {
                if ( !event.shiftKey ) {
                    if ( !_DELETE_CONFIRM_CODE ) {
                        showError(
                            "Stop Operation Protection! Please hold the shift key to confirm this operation."
                        );
                        return;
                    }
                }
                document.getElementById( "quitButton" ).click();
                showInfo( "Command issued, please wait" );
                ajax(
                    "/api/" + sapi,
                    cmd,
                    JSON.stringify( { id: id } ),
                    ( success ) => {
                        var j = JSON.parse( success );
                        //list( document.getElementById( "nav-title" ), false );
                        if ( sapi == "instances-xvm" ) {
                            setTimeout( () => {
                                getVirtualMachineStatus( j.cloudid, id, j.mac, "ip-" + id, "status-" + id );
                                showSuccess( j.payload );
                            }, 1000 );
                        } else {
                            setTimeout( () => {
                                getContainerStatus( j.cloudid, id, "ip-" + id, "status-" + id );
                                showSuccess( j.payload );
                            }, 1000 );
                        }
                    },
                    ( error ) => {
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                //cancel
                document.getElementById( "quitButton" ).click();
            }
        );
    } else if ( cmd == "start" ) {
        if ( document.getElementById( "status-" + id ).innerText == "RUNNING" ) {
            showError( "Instance already started" );
            return;
        }
        showInfo( "Command was issued, please wait..." );

        ajax(
            "/api/" + sapi,
            cmd,
            JSON.stringify( { id: id } ),
            ( success ) => {
                var j = JSON.parse( success );
                //list( document.getElementById( "nav-title" ), false );
                if ( sapi == "instances-xvm" ) {
                    setTimeout( () => {
                        getVirtualMachineStatus( j.cloudid, id, j.mac, "ip-" + id, "status-" + id );
                        showSuccess( j.payload );
                    }, 1000 );
                } else {
                    setTimeout( () => {
                        getContainerStatus( j.cloudid, id, "ip-" + id, "status-" + id );
                        showSuccess( j.payload );
                    }, 1000 );
                }
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    }
};

const initFreeIPRange = ( sender ) => {
    var id = sender.options[ sender.selectedIndex ].value;
    document.getElementById(
        "networkspinner"
    ).innerHTML = `<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>`;
    ajax(
        "/api/privatenetwork",
        "initiprange",
        '{"id": "' + id + '"}',
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "network" ).innerHTML = j.payload;
            document.getElementById( "networkspinner" ).innerText = "Network";
            setFreeIPRange();
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const setFreeIPRange = () => {
    var ipRange =
        document.getElementById( "network" ).options[
            document.getElementById( "network" ).selectedIndex
        ].value;
    var ipMask =
        document.getElementById( "mask" ).options[
            document.getElementById( "mask" ).selectedIndex
        ].value;

    if ( ipMask == "24" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".255";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".254";
        document.getElementById( "maskip" ).innerHTML = "255.255.255.0";
        document.getElementById( "total" ).innerHTML = "253";
    } else if ( ipMask == "23" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".255";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            "1" +
            ".254";
        document.getElementById( "maskip" ).innerHTML = "255.255.254.0";
        document.getElementById( "total" ).innerHTML = "509";
    } else if ( ipMask == "22" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".255";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            "3" +
            ".254";
        document.getElementById( "maskip" ).innerHTML = "255.255.252.0";
        document.getElementById( "total" ).innerHTML = "1021";
    } else if ( ipMask == "21" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".255";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            "7" +
            ".254";
        document.getElementById( "maskip" ).innerHTML = "255.255.248.0";
        document.getElementById( "total" ).innerHTML = "2045";
    } else if ( ipMask == "20" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".255";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            "15" +
            ".254";
        document.getElementById( "maskip" ).innerHTML = "255.255.240.0";
        document.getElementById( "total" ).innerHTML = "4093";
    } else if ( ipMask == "30" ) {
        document.getElementById( "gateway" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".1";
        document.getElementById( "minip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "broadcast" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".3";
        document.getElementById( "maxip" ).innerHTML =
            ipRange.split( "." )[ 0 ] +
            "." +
            ipRange.split( "." )[ 1 ] +
            "." +
            ipRange.split( "." )[ 2 ] +
            ".2";
        document.getElementById( "maskip" ).innerHTML = "255.255.255.252";
        document.getElementById( "total" ).innerHTML = "1";
    }
};

const backup_Instance = ( id, api, itemType = "" ) => {
    if ( itemType != "" ) {
        if ( itemType == "X Virtual Machine Disk" ) {
            showError( "Can not backup a X Virtual Machine Disk" );
            return;
        }
    }

    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    ajax(
        "/api/" + sapi,
        "backup",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Backup " + api,
                j.payload,
                "",
                "Close",
                "",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const template_Operations = ( id, api ) => {
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    ajax(
        "/api/" + sapi,
        "template",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Template Operations",
                j.payload,
                "Proceed",
                "Cancel",
                "",
                () => {
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Template Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }

                    document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );

                    var data = {
                        id: document.getElementById( 'id' ).value,
                        operation: document.getElementById( 'operation' ).options[ document.getElementById( 'operation' ).selectedIndex ].value
                    };
                    ajax( "/api/" + sapi, "process-template", JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            list( document.getElementById( "nav-title" ), false );
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML = "Proceed";
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const snapshot_Instance = ( id, api, itemType = "" ) => {
    if ( itemType != "" ) {
        if ( itemType == "X Virtual Machine Disk" ) {
            showError( "Can not snapshot a X Virtual Machine Disk" );
            return;
        }
    }

    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    ajax(
        "/api/" + sapi,
        "snapshot",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Snapshot " + api,
                j.payload,
                "",
                "Close",
                "",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const clone_Instance = ( id, api ) => {
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }
    ajax(
        "/api/" + sapi,
        "clone",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Clone " + api,
                j.payload,
                "Clone",
                "Cancel",
                "",
                () => {
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    if ( sapi == "instances-vm" ) {
                        if (
                            document.getElementById( "status-" + id ).innerText ==
                            "RUNNING"
                        ) {
                            showError(
                                "Can not start a clone on an active system, please stop the instance first"
                            );
                            return;
                        }
                    }
                    if ( sapi == "instances-xvm" ) {
                        if ( document.getElementById( "status-" + id ).innerText != "RUNNING" &&
                            document.getElementById( "template-" + id ).innerHTML.trim() == "" ) {
                            showError( "Can not start a clone on an inactive system, please start the instance first" );
                            return;
                        }
                    }
                    document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
                    var cloneFrom = document.getElementById( "clonefrom" ).value;
                    var newName = document.getElementById( "name" ).value;
                    var oldName = document.getElementById( "oldname" ).value;
                    var isclonetype = "";
                    try { isclonetype = document.getElementById( "clonetype" ).options[ document.getElementById( "clonetype" ).selectedIndex ].value; } catch { }
                    ajax(
                        "/api/" + sapi,
                        "start-clone",
                        JSON.stringify( {
                            newname: newName,
                            clonefrom: cloneFrom,
                            oldname: oldName,
                            clonetype: isclonetype
                        } ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML = "Clone";
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const migrate_Instance = ( id, api ) => {
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }

    ajax(
        "/api/" + sapi,
        "migrate",
        '{"id": "' + id + '"}',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Migrate " + api,
                j.payload,
                "Migrate",
                "Cancel",
                "",
                () => {
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );

                    var sourceid = document.getElementById( "sourceid" ).value;
                    var cloudnode =
                        document.getElementById( "cloudnode" ).options[
                            document.getElementById( "cloudnode" ).selectedIndex
                        ].value;
                    var migrateas =
                        document.getElementById( "migrate" ).options[
                            document.getElementById( "migrate" ).selectedIndex
                        ].value;

                    ajax(
                        "/api/" + sapi,
                        "start-migrate",
                        JSON.stringify( {
                            sourceid: sourceid,
                            tocloudnode: cloudnode,
                            migrateas: migrateas,
                        } ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Migrate";
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const deploySolution = () => {
    eval( document.getElementById( "preDeploy" ).innerText );
};

const deployLoadBalancer = () => {
    if ( document.getElementById( "name" ).value == "" ) {
        showError( "Please enter a name" );
        return;
    }
    var polList = document.getElementsByClassName( "listitem" );
    if ( polList.length == 0 ) {
        showError( "Please add destination ip and port" );
        return;
    }
    if ( polList.length <= 1 ) {
        if ( document.getElementById( "balance" ).selectedIndex > 0 ) {
            showError(
                "Multiple destinations are required for selected balance method"
            );
            return;
        }
    }

    if (
        document.getElementById( "type" ).selectedIndex == 0 ||
        document.getElementById( "type" ).selectedIndex == 1 ||
        document.getElementById( "type" ).selectedIndex == 2 ||
        document.getElementById( "type" ).selectedIndex == 3
    ) {
        if ( document.getElementById( "sourceurl" ).value == "" ) {
            showError( "Please enter a domain" );
            return;
        }
    } else {
        if ( document.getElementById( "sourceport" ).value == "" ) {
            showError( "Please enter a port number" );
            return;
        } else {
            if ( isNaN( document.getElementById( "sourceport" ).value ) ) {
                showError( "Port number is invalid" );
                return;
            } else {
                var tmp = document.getElementById( "sourceport" ).value;
                if (
                    parseInt( tmp ) == 80 ||
                    parseInt( tmp ) == 443 ||
                    parseInt( tmp ) == 2318
                ) {
                    showError( "This port number is reserved" );
                    return;
                }
            }
        }
    }

    if ( document.getElementById( "balance" ).selectedIndex == 0 ) {
        if ( polList.length > 1 ) {
            showError( "This balance mode only supports one destination" );
            return;
        }
    }

    var dests = "";
    for ( i = 0; i < polList.length; i++ ) {
        if ( dests == "" ) {
            dests = polList[ i ].value;
        } else {
            dests = dests + "," + polList[ i ].value;
        }
    }

    var okCaption = "Create";
    if ( document.getElementById( "editmode" ).value == "1" ) {
        okCaption = "Update";
    }

    var data = {
        id: document.getElementById( "id" ).value,
        operator: document.getElementById( "operator" ).value,
        name: document.getElementById( "name" ).value,
        cloudnode:
            document.getElementById( "cloudnode" ).options[
                document.getElementById( "cloudnode" ).selectedIndex
            ].value,
        type: document.getElementById( "type" ).options[
            document.getElementById( "type" ).selectedIndex
        ].value,
        balance:
            document.getElementById( "balance" ).options[
                document.getElementById( "balance" ).selectedIndex
            ].value,
        sourceurl: document.getElementById( "sourceurl" ).value,
        sourceport: document.getElementById( "sourceport" ).value,
        destinations: dests,
    };

    document.getElementById( "okButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
    ajax(
        "/api/loadbalancer",
        "save",
        JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "quitButton" ).click();
            list( document.getElementById( "nav-title" ), false );
            setTimeout( () => {
                showSuccess( j.payload );
            }, 500 );
        },
        ( error ) => {
            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
            document.getElementById( "okButton" ).removeAttribute( "disabled" );
            document.getElementById( "okButton" ).innerHTML = okCaption;
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getLoadBalancerStatus = ( cloudid, itemid, pinglist ) => {
    ajax(
        "/api/loadbalancer",
        "ping",
        JSON.stringify( { cloudnode: cloudid, id: itemid, pings: pinglist } ),
        ( success ) => {
            var list = "";
            var j = JSON.parse( success );
            j.payload.split( "\n" ).forEach( ( item ) => {
                if ( !item.includes( "Host Unreachable from" ) ) {
                    if ( item.includes( "alive" ) ) {
                        list =
                            list +
                            "<span style='color: green;'>" +
                            item +
                            "</span><br>";
                    } else {
                        list =
                            list +
                            "<span style='color: red;'>" +
                            item +
                            "</span><br>";
                    }
                }
            } );
            document.getElementById( "dest-" + itemid ).innerHTML = list;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "dest-" + itemid ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const generateVPNCertificate = () => {
    var peerItem =
        document.getElementById( "peer" ).options[
            document.getElementById( "peer" ).options.selectedIndex
        ].value;
    var cloudID =
        document.getElementById( "cloudnode" ).options[
            document.getElementById( "cloudnode" ).options.selectedIndex
        ].value;
    ajax(
        "/api/vpnmanager",
        "generate",
        JSON.stringify( { cloudnode: cloudID, peer: peerItem } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "cert" ).value = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const add_CodeFile = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        showError( "Please save or deploy first" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    if ( getSelectedCodeFile().classList.contains( "code-folder" ) ) {
        var parents = "";
        var node = getSelectedCodeFile().parentNode;

        try {
            while ( node.id != "file-tree" ) {
                if ( node.id != "file-tree" && node.id != "filelist" ) {
                    parents = node.id.split( "#" )[ 1 ] + "/" + parents;
                }
                node = node.parentNode.parentNode;
            }
        } catch { }
        document.getElementById( "newfilename" ).value =
            parents +
            getSelectedCodeFile().innerText.trim().split( "\n" )[ 0 ] +
            "/";
    }
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if ( newFilename.trim() != "" ) {
            var data = {
                filename: newFilename,
                id: sID,
                cloudnode: cloudID,
                gitrepo: document.getElementById( "gitrepo" ).value.trim(),
            };
            if ( newFilename.indexOf( "." ) == -1 && newFilename != "Dockerfile" ) {
                showError( "Please specify file extention" );
                return;
            }
            ajax(
                "/api/serverless-fx",
                "new-file",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "filelist" ).innerHTML = j.payload;
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    window[ "editor" ].setValue( "", -1 );
                    window[ "editor" ].focus();
                    document.getElementById( "activecodefile" ).value =
                        newFilename;
                    document.getElementById( "modaltitle" ).innerText =
                        "Serverless-fx - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    window[ "editor" ]
                        .getSession()
                        .setUndoManager( new ace.UndoManager() );
                    setTimeout( () => {
                        fileTree( "file-tree" );
                        document.getElementById( "file-tree" ).style.display =
                            "block";
                        unselectCodeFiles();
                        selectCodefileByName( newFilename );
                    }, 500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a file name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const add_CodeFolder = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        showError( "Please save or deploy first" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    if ( getSelectedCodeFile().classList.contains( "code-folder" ) ) {
        var parents = "";
        var node = getSelectedCodeFile().parentNode;

        try {
            while ( node.id != "file-tree" ) {
                if ( node.id != "file-tree" && node.id != "filelist" ) {
                    parents = node.id.split( "#" )[ 1 ] + "/" + parents;
                }
                node = node.parentNode.parentNode;
            }
        } catch { }
        document.getElementById( "newfilename" ).value =
            parents +
            getSelectedCodeFile().innerText.trim().split( "\n" )[ 0 ] +
            "/";
    }
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            var data = {
                filename: newFilename,
                id: sID,
                cloudnode: cloudID,
                gitrepo: document.getElementById( "gitrepo" ).value.trim(),
            };
            ajax(
                "/api/serverless-fx",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "filelist" ).innerHTML = j.payload;
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    document.getElementById( "modaltitle" ).innerText =
                        "Serverless-fx - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    fileTree( "file-tree" );
                    document.getElementById( "file-tree" ).style.display =
                        "block";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const upload_CodeFile = ( fileName, sID, cloudID ) => {
    //later
};

const edit_CodeFile = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        document.getElementById( "super-modal-back" ).style.display = "block";
        document.getElementById( "super-modal-text" ).innerText =
            "Your changes you made will be lost, continue?";
        document.getElementById( "super-modal" ).style.top = "0px";
        document.getElementById( "smNOButton" ).focus();
        document.getElementById( "smOKButton" ).onclick = ( e ) => {
            ajax(
                "/api/serverless-fx",
                "read-file",
                JSON.stringify( {
                    filename: fileName,
                    id: sID,
                    cloudnode: cloudID,
                } ),
                ( success ) => {
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    document.getElementById( "super-modal" ).style.top = "-180px";
                    var j = JSON.parse( success );
                    window[ "editor" ].setValue( j.payload, -1 );
                    window[ "editor" ].focus();
                    selectCodefileByName( fileName );
                    document.getElementById( "activecodefile" ).value = fileName;
                    document.getElementById( "modaltitle" ).innerText =
                        "Serverless-fx - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
                    window[ "editor" ]
                        .getSession()
                        .setUndoManager( new ace.UndoManager() );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        };
        document.getElementById( "smNOButton" ).onclick = ( e ) => {
            document.getElementById( "super-modal-back" ).style.display = "none";
            document.getElementById( "super-modal" ).style.top = "-180px";
        };
    } else {
        ajax(
            "/api/serverless-fx",
            "read-file",
            JSON.stringify( { filename: fileName, id: sID, cloudnode: cloudID } ),
            ( success ) => {
                var j = JSON.parse( success );
                window[ "editor" ].setValue( j.payload, -1 );
                window[ "editor" ].focus();
                document.getElementById( "activecodefile" ).value = fileName;
                document.getElementById( "modaltitle" ).innerText =
                    "Serverless-fx - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    }
};

const delete_CodeFile = ( fileName, sID, cloudID ) => {
    if ( fileName.indexOf( "v7ess_" ) != -1 ) {
        showError( "Can not delete the main file" );
        return;
    }

    if ( getSelectedCodeFile() == null ) {
        showError( "Please select a file" );
        return;
    }

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete the file [" +
        fileName.split( "/" )[ fileName.split( "/" ).length - 1 ] +
        "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        ajax(
            "/api/serverless-fx",
            "delete-file",
            JSON.stringify( {
                filename: fileName,
                id: sID,
                cloudnode: cloudID,
                gitrepo: document.getElementById( "gitrepo" ).value.trim(),
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "filelist" ).innerHTML = j.payload;
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                window[ "editor" ].setValue( j.code, -1 );
                window[ "editor" ].focus();
                fileTree( "file-tree" );
                document.getElementById( "file-tree" ).style.display = "block";
                selectCodefileByName( j.filename );
                document.getElementById( "activecodefile" ).value = j.filename;
                document.getElementById( "modaltitle" ).innerText =
                    "Serverless-fx - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const delete_CodeFolder = ( folderName, sID, cloudID ) => {
    if ( getSelectedCodeFile() == null ) {
        showError( "Please select a folder" );
        return;
    }

    var parents = "";
    var node = getSelectedCodeFile().parentNode;

    try {
        while ( node.id != "file-tree" ) {
            if ( node.id != "file-tree" && node.id != "filelist" ) {
                parents = node.id.split( "#" )[ 1 ] + "/" + parents;
            }
            node = node.parentNode.parentNode;
        }
    } catch { }

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete the folder [" +
        folderName.split( "\n" )[ 0 ] +
        "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        ajax(
            "/api/serverless-fx",
            "delete-folder",
            JSON.stringify( {
                filename: parents + folderName.split( "\n" )[ 0 ],
                id: sID,
                cloudnode: cloudID,
                gitrepo: document.getElementById( "gitrepo" ).value.trim(),
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "filelist" ).innerHTML = j.payload;
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                window[ "editor" ].setValue( j.code, -1 );
                window[ "editor" ].focus();
                fileTree( "file-tree" );
                document.getElementById( "file-tree" ).style.display = "block";
                selectCodefileByName( j.filename );
                document.getElementById( "activecodefile" ).value = j.filename;
                document.getElementById( "modaltitle" ).innerText =
                    "Serverless-fx - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const getServerlessFXStatus = ( fxID, fxName, cloudID ) => {
    ajax(
        "/api/serverless-fx",
        "status",
        JSON.stringify( { id: fxID, name: fxName, cloudnode: cloudID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + fxID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + fxID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const getServerlessSparkStatus = ( fxID, fxName, cloudID ) => {
    ajax(
        "/api/serverless-spark",
        "status",
        JSON.stringify( { id: fxID, name: fxName, cloudnode: cloudID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + fxID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + fxID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const getServerlessFlowStatus = ( fxID, fxName, cloudID ) => {
    ajax(
        "/api/serverless-flow",
        "status",
        JSON.stringify( { id: fxID, name: fxName, cloudnode: cloudID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + fxID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + fxID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const updateFWCommand = () => {
    var cmd = "A- ";
    if ( document.getElementById( "fromrule" ).selectedIndex == 0 ) {
        cmd = cmd + " from any ";
    } else {
        cmd = cmd + " from " + document.getElementById( "fromip" ).value + " ";
    }
    if ( document.getElementById( "proto" ).selectedIndex == 1 ) {
        cmd = cmd + " proto tcp ";
    }
    if ( document.getElementById( "proto" ).selectedIndex == 2 ) {
        cmd = cmd + " proto udp ";
    }
    if ( document.getElementById( "torule" ).selectedIndex == 0 ) {
        cmd = cmd + " to any ";
    } else {
        cmd = cmd + " to " + document.getElementById( "toip" ).value + " ";
    }
    if ( document.getElementById( "portrule" ).selectedIndex == 1 ) {
        cmd = cmd + " port " + document.getElementById( "port" ).value;
    }

    document.getElementById( "command" ).value = cmd;
};

const unselectCodeFiles = () => {
    var selList = document.getElementsByClassName( "code-file" );
    for ( i = selList.length - 1; i > -1; i-- ) {
        selList[ i ].classList.remove( "fileselected" );
    }
    var selList = document.getElementsByClassName( "code-folder" );
    for ( i = selList.length - 1; i > -1; i-- ) {
        selList[ i ].classList.remove( "fileselected" );
    }
};

const getSelectedCodeFile = () => {
    var node = null;

    var selList = document.getElementsByClassName( "code-folder" );
    for ( i = selList.length - 1; i > -1; i-- ) {
        if ( selList[ i ].classList.contains( "fileselected" ) ) {
            node = selList[ i ];
            break;
        }
    }

    if ( node == null ) {
        var selList = document.getElementsByClassName( "code-file" );
        for ( i = selList.length - 1; i > -1; i-- ) {
            if ( selList[ i ].classList.contains( "fileselected" ) ) {
                node = selList[ i ];
                break;
            }
        }
    }

    return node;
};

const selectCodeFile = ( sender, isRepo = false ) => {
    if ( !window[ "editorchanged" ] ) {
        unselectCodeFiles();
        setTimeout( () => {
            sender.classList.add( "fileselected" );
            if ( !isRepo ) {
                if ( sender.innerText.indexOf( "v7ess_function" ) != -1 ) {
                    document
                        .getElementById( "fileDelButton" )
                        .setAttribute( "disabled", "true" );
                } else {
                    document
                        .getElementById( "fileDelButton" )
                        .removeAttribute( "disabled" );
                }
            }
        }, 50 );
    }
};

const selectCodefileByName = ( file, isRepo = false ) => {
    var selList = document.getElementsByClassName( "code-file" );
    for ( i = selList.length - 1; i > -1; i-- ) {
        selList[ i ].classList.remove( "fileselected" );
        if ( selList[ i ].getAttribute( "ondblclick" ).indexOf( file ) != -1 ) {
            selList[ i ].classList.add( "fileselected" );
            if ( !isRepo ) {
                if ( file.indexOf( "v7ess_function" ) != -1 ) {
                    document
                        .getElementById( "fileDelButton" )
                        .setAttribute( "disabled", "true" );
                } else {
                    document
                        .getElementById( "fileDelButton" )
                        .removeAttribute( "disabled" );
                }
            }
        }
    }
};

const get_CodeSubFolder = ( refID, nodeID, sender ) => {
    var folderID = refID.split( "#" )[ 0 ];
    var folderName = refID.split( "#" )[ 1 ];

    var parents = "";
    var node = sender.parentNode;

    try {
        while ( node.id != "file-tree" ) {
            if ( node.id != "file-tree" && node.id != "filelist" ) {
                parents = node.id.split( "#" )[ 1 ] + "/" + parents;
            }
            node = node.parentNode.parentNode;
        }
    } catch { }

    ajax(
        "/api/serverless-fx",
        "get-folder",
        JSON.stringify( {
            id: folderID,
            folder: parents + folderName,
            cloudnode: nodeID,
        } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( refID ).innerHTML = j.payload;
            fileTree( "file-tree" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getServerlessAPIStatus = ( fxID, fxName, cloudID ) => {
    ajax(
        "/api/serverless-api",
        "status",
        JSON.stringify( { id: fxID, name: fxName, cloudnode: cloudID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + fxID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + fxID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const edit_PasswordStatus = ( id, status ) => {
    if (
        document.getElementById( "status-" + id ).innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + id )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            showError(
                "Node is not ready - " +
                document.getElementById( "status-" + id ).innerText
            );
        }
        return;
    }
    showModal(
        "Root Login",
        "You are about to <b>" +
        status +
        "</b> the password login for the root user, continue?",
        "Yes",
        "No",
        "",
        () => {
            ajax(
                "/api/skynodes".toLowerCase(),
                "password-status",
                JSON.stringify( { id: id, status: status } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    list( document.getElementById( "nav-title" ), false );
                    document.getElementById( "quitButton" ).click();
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showSuccess( j.message );
                }
            );
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const delete_RepoBranch = ( sender, repoName, repoID, cloudID ) => {
    var branchName =
        sender.parentNode.parentNode.querySelector( ".listitem" ).value;
    if ( branchName == "main" ) {
        showError( "The main branch can not be deleted" );
        return;
    }

    if (
        document.getElementById( "branchcombo" ).options[
            document.getElementById( "branchcombo" ).selectedIndex
        ].value == branchName
    ) {
        showError( "Can not delete a branch that is in the Branch View" );
        return;
    }

    var data = JSON.stringify( {
        id: repoID,
        cloudnode: cloudID,
        reponame: repoName,
        branch: branchName,
    } );
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete the branch [" + branchName + "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "delete-branch",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                sender.parentNode.parentNode.parentNode.removeChild(
                    sender.parentNode.parentNode
                );

                for (
                    i = 0;
                    i < document.getElementById( "branchcombo" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "branchcombo" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "branchcombo" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "branchAselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "branchAselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "branchAselect" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "branchBselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "branchBselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "branchBselect" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "mergeAselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "mergeAselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "mergeAselect" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "mergeBselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "mergeBselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "mergeBselect" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "filterBranch" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "filterBranch" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "filterBranch" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "pullAselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "pullAselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "pullAselect" ).remove( i );
                        break;
                    }
                }

                for (
                    i = 0;
                    i < document.getElementById( "pullBselect" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "pullBselect" ).options[ i ]
                            .value == branchName
                    ) {
                        document.getElementById( "pullBselect" ).remove( i );
                        break;
                    }
                }

                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                showSuccess( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const create_RepoBranch = ( repoName, repoID, cloudID ) => {
    var listTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
    <span class="input-group-text rounded-0" style="width: 130px;"><b>Branch</b></span>
    <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="{BRANCH}">
    <span class="input-group-btn">
        <button class="btn btn-secondary rounded-0" style="width: 120px;" type="button" onclick="delete_RepoBranch(this, '${repoName}', '${repoID}', '${cloudID}');">Delete</button>
    </span></div>`;

    var listItems = document.getElementsByClassName( "listitem" );
    for ( i = 0; i < listItems.length; i++ ) {
        if ( listItems[ i ].value == document.getElementById( "branchname" ).value ) {
            showError( "Branch already exists" );
            return;
        }
    }

    if ( document.getElementById( "branchname" ).value.trim() == "" ) {
        showError( "Please enter a branch name" );
        return;
    }

    if ( document.getElementById( "branchname" ).value.trim().indexOf( " " ) != -1 ) {
        showError( "Branch name can not contain spaces" );
        return;
    }

    document.getElementById( "createRepoBranchButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document
        .getElementById( "createRepoBranchButton" )
        .setAttribute( "disabled", "true" );

    var data = JSON.stringify( {
        id: repoID,
        cloudnode: cloudID,
        reponame: repoName,
        branch: document.getElementById( "branchname" ).value.replace( /:/g, " " ),
    } );
    ajax(
        "/api/repositories",
        "create-branch",
        data,
        ( success ) => {
            var realBranch = document.getElementById( "branchname" ).value;
            if ( realBranch.indexOf( ":" ) != -1 ) {
                realBranch = realBranch.substring( 0, realBranch.indexOf( ":" ) );
            }
            var j = JSON.parse( success );
            var item = document.createElement( "div" );
            item.innerHTML = listTemplate.replace( "{BRANCH}", realBranch );
            document.getElementById( "branchlist" ).appendChild( item );

            var option = document.createElement( "option" );
            option.text = "Branch View: " + realBranch;
            option.value = realBranch;
            document.getElementById( "branchcombo" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "branchAselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "branchBselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "mergeAselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "mergeBselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "pullAselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "pullBselect" ).add( option );

            var option = document.createElement( "option" );
            option.text = realBranch;
            option.value = realBranch;
            document.getElementById( "filterBranch" ).add( option );

            document.getElementById( "branchname" ).value = "";
            showSuccess( j.payload );
            document.getElementById( "createRepoBranchButton" ).innerHTML =
                "Create";
            document
                .getElementById( "createRepoBranchButton" )
                .removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "createRepoBranchButton" ).innerHTML =
                "Create";
            document
                .getElementById( "createRepoBranchButton" )
                .removeAttribute( "disabled" );
        }
    );
};

const do_RepoCompare = ( repoName, repoID, cloudID ) => {
    var aBranch =
        document.getElementById( "branchAselect" ).options[
            document.getElementById( "branchAselect" ).selectedIndex
        ].value;
    var bBranch =
        document.getElementById( "branchBselect" ).options[
            document.getElementById( "branchBselect" ).selectedIndex
        ].value;
    if ( aBranch == bBranch ) {
        showError( "Can not compare the same branch" );
        return;
    }

    window[ "diff" ].setValue( "", -1 );

    var data = JSON.stringify( {
        reponame: repoName,
        id: repoID,
        cloudnode: cloudID,
        brancha: aBranch,
        branchb: bBranch,
    } );

    document.getElementById( "compareButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document.getElementById( "compareButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/repositories",
        "compare",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            window[ "diff" ].setValue( j.payload, -1 );
            document.getElementById( "compareButton" ).innerHTML = "Compare";
            document
                .getElementById( "compareButton" )
                .removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "compareButton" ).innerHTML = "Compare";
            document
                .getElementById( "compareButton" )
                .removeAttribute( "disabled" );
        }
    );
};

const do_RepoGitLog = ( repoName, repoID, cloudID ) => {
    window[ "logs" ].setValue( "", -1 );

    var data = JSON.stringify( {
        reponame: repoName,
        id: repoID,
        cloudnode: cloudID,
        branch: document.getElementById( "filterBranch" ).options[
            document.getElementById( "filterBranch" ).selectedIndex
        ].value,
        filter: document.getElementById( "gitlogfilter" ).value,
    } );

    document.getElementById( "gitlogButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document.getElementById( "gitlogButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/repositories",
        "gitlog",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            window[ "logs" ].setValue( j.payload, -1 );
            document.getElementById( "gitlogButton" ).innerHTML = "Show";
            document.getElementById( "gitlogButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "gitlogButton" ).innerHTML = "Show";
            document.getElementById( "gitlogButton" ).removeAttribute( "disabled" );
        }
    );
};

const do_RepoMerge = ( repoName, repoID, cloudID ) => {
    var aBranch =
        document.getElementById( "mergeAselect" ).options[
            document.getElementById( "mergeAselect" ).selectedIndex
        ].value;
    var bBranch =
        document.getElementById( "mergeBselect" ).options[
            document.getElementById( "mergeBselect" ).selectedIndex
        ].value;
    if ( aBranch == bBranch ) {
        showError( "Can not merge the same branch" );
        return;
    }

    var mergeTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
    <span class="input-group-text rounded-0" style="width: 130px;"><b>Commit</b></span>
    <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="{BRANCH}">
    <span class="input-group-btn">
        <button class="btn btn-secondary rounded-0 undoMergeButton" style="width: 120px;" type="button" onclick="undo_RepoMerge(this, 'item.name', 'item.id', 'item.cloudnode');">Rollback</button>
    </span></div>`;

    document.getElementById( "mergeButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document.getElementById( "mergeButton" ).setAttribute( "disabled", "true" );

    var data = JSON.stringify( {
        reponame: repoName,
        id: repoID,
        cloudnode: cloudID,
        brancha: aBranch,
        branchb: bBranch,
    } );

    document.getElementById( "spinner" ).style.display = "";
    ajax(
        "/api/repositories",
        "merge",
        data,
        ( success ) => {
            var j = JSON.parse( success );

            var mergeList = "";
            for ( var i = 0; i < j.data.split( "\n" ).length; i++ ) {
                if ( j.data.split( "\n" )[ i ].trim() != "" ) {
                    if ( j.data.split( "\n" )[ i ].trim().indexOf( "commit " ) != -1 ) {
                        mergeList =
                            mergeList +
                            mergeTemplate
                                .replace(
                                    "{BRANCH}",
                                    j.data
                                        .split( "\n" )
                                    [ i ].trim()
                                        .replace( "commit ", "" )
                                        .trim() +
                                    " : " +
                                    j.data.split( "\n" )[ i + 1 ].trim()
                                )
                                .replace( "item.name", repoName )
                                .replace( "item.id", repoID )
                                .replace( "item.cloudnode", cloudID );
                    }
                }
            }

            document.getElementById( "mergehistory" ).innerHTML = mergeList;

            document.querySelectorAll( ".tabiClass" )[ 0 ].click();
            do_RepoLoadFiles( repoName, repoID, cloudID );

            if (
                document.getElementsByClassName( "undoMergeButton" ).length != 0
            ) {
                document
                    .getElementsByClassName( "undoMergeButton" )[ 0 ]
                    .setAttribute( "disabled", true );
            }
            showSuccess( j.payload );
            document.getElementById( "mergeButton" ).innerHTML = "Merge";
            document.getElementById( "mergeButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            document.getElementById( "spinner" ).style.display = "none";
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "mergeButton" ).innerHTML = "Merge";
            document.getElementById( "mergeButton" ).removeAttribute( "disabled" );
        }
    );
};

const undo_RepoMerge = ( sender, repoName, repoID, cloudID ) => {
    var rollback =
        sender.parentNode.parentNode.querySelector( ".listitem" ).value;
    var bBranch =
        document.getElementById( "mergeBselect" ).options[
            document.getElementById( "mergeBselect" ).selectedIndex
        ].value;
    rollback = rollback.substring( 0, rollback.indexOf( ":" ) );
    var data = JSON.stringify( {
        id: repoID,
        cloudnode: cloudID,
        reponame: repoName,
        backoff: rollback,
        branch: bBranch,
    } );
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to rollback this merge, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        document.getElementById( "spinner" ).style.display = "";
        ajax(
            "/api/repositories",
            "rollback",
            data,
            ( success ) => {
                var mergeTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
                <span class="input-group-text rounded-0" style="width: 130px;"><b>Commit</b></span>
                <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="{BRANCH}">
                <span class="input-group-btn">
                    <button class="btn btn-secondary rounded-0 undoMergeButton" style="width: 120px;" type="button" onclick="undo_RepoMerge(this, 'item.name', 'item.id', 'item.cloudnode');">Rollback</button>
                </span></div>`;

                var j = JSON.parse( success );

                var mergeList = "";
                for ( var i = 0; i < j.data.split( "\n" ).length; i++ ) {
                    if ( j.data.split( "\n" )[ i ].trim() != "" ) {
                        if (
                            j.data.split( "\n" )[ i ].trim().indexOf( "commit " ) !=
                            -1
                        ) {
                            mergeList =
                                mergeList +
                                mergeTemplate
                                    .replace(
                                        "{BRANCH}",
                                        j.data
                                            .split( "\n" )
                                        [ i ].trim()
                                            .replace( "commit ", "" )
                                            .trim() +
                                        " : " +
                                        j.data.split( "\n" )[ i + 1 ].trim()
                                    )
                                    .replace( "item.name", repoName )
                                    .replace( "item.id", repoID )
                                    .replace( "item.cloudnode", cloudID );
                        }
                    }
                }

                document.getElementById( "mergehistory" ).innerHTML = mergeList;

                if (
                    document.getElementsByClassName( "undoMergeButton" ).length !=
                    0
                ) {
                    document
                        .getElementsByClassName( "undoMergeButton" )[ 0 ]
                        .setAttribute( "disabled", true );
                }

                document.querySelectorAll( ".tabiClass" )[ 0 ].click();
                do_RepoLoadFiles( repoName, repoID, cloudID );

                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                showSuccess( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "spinner" ).style.display = "none";
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const get_RepoMergeHistory = ( sender, repoName, repoID, cloudID ) => {
    var data = JSON.stringify( {
        id: repoID,
        cloudnode: cloudID,
        reponame: repoName,
        branch: sender.options[ sender.selectedIndex ].value,
    } );
    ajax(
        "/api/repositories",
        "merge-history",
        data,
        ( success ) => {
            var mergeTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
            <span class="input-group-text rounded-0" style="width: 130px;"><b>Commit</b></span>
            <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="{BRANCH}">
            <span class="input-group-btn">
                <button class="btn btn-secondary rounded-0 undoMergeButton" style="width: 120px;" type="button" onclick="undo_RepoMerge(this, 'item.name', 'item.id', 'item.cloudnode');">Rollback</button>
            </span></div>`;

            var j = JSON.parse( success );

            var mergeList = "";
            for ( var i = 0; i < j.payload.split( "\n" ).length; i++ ) {
                if ( j.payload.split( "\n" )[ i ].trim() != "" ) {
                    if (
                        j.payload.split( "\n" )[ i ].trim().indexOf( "commit " ) != -1
                    ) {
                        mergeList =
                            mergeList +
                            mergeTemplate
                                .replace(
                                    "{BRANCH}",
                                    j.payload
                                        .split( "\n" )
                                    [ i ].trim()
                                        .replace( "commit ", "" )
                                        .trim() +
                                    " : " +
                                    j.payload.split( "\n" )[ i + 1 ].trim()
                                )
                                .replace( "item.name", repoName )
                                .replace( "item.id", repoID )
                                .replace( "item.cloudnode", cloudID );
                    }
                }
            }

            document.getElementById( "mergehistory" ).innerHTML = mergeList;

            if (
                document.getElementsByClassName( "undoMergeButton" ).length != 0
            ) {
                document
                    .getElementsByClassName( "undoMergeButton" )[ 0 ]
                    .setAttribute( "disabled", true );
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const do_RepoLoadFiles = ( repoName, repoID, cloudID ) => {
    var data = JSON.stringify( {
        id: repoID,
        cloudnode: cloudID,
        reponame: repoName,
        branch: document.getElementById( "branchcombo" ).options[
            document.getElementById( "branchcombo" ).selectedIndex
        ].value,
    } );
    ajax(
        "/api/repositories",
        "load-files",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "filelist" ).innerHTML = j.payload;
            window[ "editor" ].session.setValue( j.code, -1 );
            window[ "editor" ].focus();
            window[ "editorchanged" ] = false;
            document.getElementById( "activecodefile" ).value = j.activefile;
            document.getElementById( "modaltitle" ).innerText =
                document.getElementById( "name" ).innerText +
                ".repo - (" +
                document.getElementById( "activecodefile" ).value +
                ")";
            setTimeout( () => {
                fileTree( "file-tree" );
                document.getElementById( "file-tree" ).style.display = "block";
                unselectCodeFiles();
                selectCodefileByName( j.activefile, true );
                window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
            }, 500 );
            setTimeout( () => {
                document.getElementById( "spinner" ).style.display = "none";
            }, 1500 );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const edit_RepoFile = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        document.getElementById( "super-modal-back" ).style.display = "block";
        document.getElementById( "super-modal-text" ).innerText =
            "Your changes you made will be lost, continue?";
        document.getElementById( "super-modal" ).style.top = "0px";
        document.getElementById( "smNOButton" ).focus();
        document.getElementById( "smOKButton" ).onclick = ( e ) => {
            ajax(
                "/api/repositories",
                "read-file",
                JSON.stringify( {
                    filename: fileName,
                    id: sID,
                    cloudnode: cloudID,
                    branch: document.getElementById( "branchcombo" ).options[
                        document.getElementById( "branchcombo" ).selectedIndex
                    ].value,
                } ),
                ( success ) => {
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    document.getElementById( "super-modal" ).style.top = "-180px";
                    var j = JSON.parse( success );
                    window[ "editor" ].setValue( j.payload, -1 );
                    window[ "editor" ].focus();
                    selectCodefileByName( fileName );
                    document.getElementById( "activecodefile" ).value = fileName;
                    document.getElementById( "modaltitle" ).innerText =
                        document.getElementById( "name" ).innerText +
                        ".repo - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
                    window[ "editor" ]
                        .getSession()
                        .setUndoManager( new ace.UndoManager() );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        };
        document.getElementById( "smNOButton" ).onclick = ( e ) => {
            document.getElementById( "super-modal-back" ).style.display = "none";
            document.getElementById( "super-modal" ).style.top = "-180px";
        };
    } else {
        ajax(
            "/api/repositories",
            "read-file",
            JSON.stringify( {
                filename: fileName,
                id: sID,
                cloudnode: cloudID,
                branch: document.getElementById( "branchcombo" ).options[
                    document.getElementById( "branchcombo" ).selectedIndex
                ].value,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                window[ "editor" ].setValue( j.payload, -1 );
                window[ "editor" ].focus();
                document.getElementById( "activecodefile" ).value = fileName;
                document.getElementById( "modaltitle" ).innerText =
                    document.getElementById( "name" ).innerText +
                    ".repo - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    }
};

const get_RepoSubFolder = ( refID, nodeID, sender ) => {
    var folderID = refID.split( "#" )[ 0 ];
    var folderName = refID.split( "#" )[ 1 ];

    var parents = "";
    var node = sender.parentNode;

    try {
        while ( node.id != "file-tree" ) {
            if ( node.id != "file-tree" && node.id != "filelist" ) {
                parents = node.id.split( "#" )[ 1 ] + "/" + parents;
            }
            node = node.parentNode.parentNode;
        }
    } catch { }

    ajax(
        "/api/repositories",
        "get-folder",
        JSON.stringify( {
            id: folderID,
            folder: parents + folderName,
            cloudnode: nodeID,
            branch: document.getElementById( "branchcombo" ).options[
                document.getElementById( "branchcombo" ).selectedIndex
            ].value,
        } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( refID ).innerHTML = j.payload;
            fileTree( "file-tree" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const delete_RepoFile = ( fileName, repoName, sID, cloudID ) => {
    if ( fileName.indexOf( ".DO-NOT-DELETE.HASH" ) != -1 ) {
        showError( "Can not delete the .DO-NOT-DELETE.HASH file" );
        return;
    }

    if ( getSelectedCodeFile() == null ) {
        showError( "Please select a file" );
        return;
    }

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete the file [" +
        fileName.split( "/" )[ fileName.split( "/" ).length - 1 ] +
        "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "delete-file",
            JSON.stringify( {
                filename: fileName,
                reponame: repoName,
                id: sID,
                cloudnode: cloudID,
                branch: document.getElementById( "branchcombo" ).options[
                    document.getElementById( "branchcombo" ).selectedIndex
                ].value,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "filelist" ).innerHTML = j.payload;
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                window[ "editor" ].setValue( j.code, -1 );
                window[ "editor" ].focus();
                fileTree( "file-tree" );
                document.getElementById( "file-tree" ).style.display = "block";
                selectCodefileByName( j.activefile );
                document.getElementById( "activecodefile" ).value = j.activefile;
                document.getElementById( "modaltitle" ).innerText =
                    document.getElementById( "name" ).innerText +
                    ".repo - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ].session.setMode( "ace/mode/" + j.syntax );
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
                get_RepoMergeHistory(
                    document.getElementById( "mergeBselect" ),
                    repoName,
                    sID,
                    cloudID
                );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const delete_RepoFolder = ( folderName, repoName, sID, cloudID ) => {
    if ( getSelectedCodeFile() == null ) {
        showError( "Please select a folder" );
        return;
    }

    var parents = "";
    var node = getSelectedCodeFile().parentNode;

    try {
        while ( node.id != "file-tree" ) {
            if ( node.id != "file-tree" && node.id != "filelist" ) {
                parents = node.id.split( "#" )[ 1 ] + "/" + parents;
            }
            node = node.parentNode.parentNode;
        }
    } catch { }

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete the folder [" +
        folderName.split( "\n" )[ 0 ] +
        "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "delete-folder",
            JSON.stringify( {
                filename: parents + folderName.split( "\n" )[ 0 ],
                reponame: repoName,
                id: sID,
                cloudnode: cloudID,
                branch: document.getElementById( "branchcombo" ).options[
                    document.getElementById( "branchcombo" ).selectedIndex
                ].value,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "filelist" ).innerHTML = j.payload;
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                window[ "editor" ].setValue( j.code, -1 );
                window[ "editor" ].focus();
                fileTree( "file-tree" );
                document.getElementById( "file-tree" ).style.display = "block";
                selectCodefileByName( j.activefile );
                document.getElementById( "activecodefile" ).value = j.activefile;
                document.getElementById( "modaltitle" ).innerText =
                    document.getElementById( "name" ).innerText +
                    ".repo - (" +
                    document.getElementById( "activecodefile" ).value +
                    ")";
                window[ "editorchanged" ] = false;
                window[ "editor" ]
                    .getSession()
                    .setUndoManager( new ace.UndoManager() );
                get_RepoMergeHistory(
                    document.getElementById( "mergeBselect" ),
                    repoName,
                    sID,
                    cloudID
                );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const add_RepoFile = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        showError( "Please save first" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    if ( getSelectedCodeFile().classList.contains( "code-folder" ) ) {
        var parents = "";
        var node = getSelectedCodeFile().parentNode;

        try {
            while ( node.id != "file-tree" ) {
                if ( node.id != "file-tree" && node.id != "filelist" ) {
                    parents = node.id.split( "#" )[ 1 ] + "/" + parents;
                }
                node = node.parentNode.parentNode;
            }
        } catch { }
        document.getElementById( "newfilename" ).value =
            parents +
            getSelectedCodeFile().innerText.trim().split( "\n" )[ 0 ] +
            "/";
    }
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if ( newFilename.trim() != "" ) {
            var data = {
                filename: newFilename,
                id: sID,
                cloudnode: cloudID,
                branch: document.getElementById( "branchcombo" ).options[
                    document.getElementById( "branchcombo" ).selectedIndex
                ].value,
            };
            if ( newFilename.indexOf( "." ) == -1 && newFilename != "Dockerfile" ) {
                showError( "Please specify file extention" );
                return;
            }
            ajax(
                "/api/repositories",
                "new-file",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "filelist" ).innerHTML = j.payload;
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    window[ "editor" ].setValue( "", -1 );
                    window[ "editor" ].focus();
                    document.getElementById( "activecodefile" ).value =
                        newFilename;
                    document.getElementById( "modaltitle" ).innerText =
                        document.getElementById( "name" ).innerText +
                        ".repo - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    window[ "editor" ]
                        .getSession()
                        .setUndoManager( new ace.UndoManager() );
                    document.querySelectorAll( ".tabiClass" )[ 0 ].click();
                    setTimeout( () => {
                        fileTree( "file-tree" );
                        document.getElementById( "file-tree" ).style.display =
                            "block";
                        unselectCodeFiles();
                        selectCodefileByName( newFilename );
                    }, 500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a file name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const add_RepoFolder = ( fileName, sID, cloudID ) => {
    if ( window[ "editorchanged" ] ) {
        showError( "Please save first" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    if ( getSelectedCodeFile().classList.contains( "code-folder" ) ) {
        var parents = "";
        var node = getSelectedCodeFile().parentNode;

        try {
            while ( node.id != "file-tree" ) {
                if ( node.id != "file-tree" && node.id != "filelist" ) {
                    parents = node.id.split( "#" )[ 1 ] + "/" + parents;
                }
                node = node.parentNode.parentNode;
            }
        } catch { }
        document.getElementById( "newfilename" ).value =
            parents +
            getSelectedCodeFile().innerText.trim().split( "\n" )[ 0 ] +
            "/";
    }
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            var data = {
                filename: newFilename,
                id: sID,
                cloudnode: cloudID,
                branch: document.getElementById( "branchcombo" ).options[
                    document.getElementById( "branchcombo" ).selectedIndex
                ].value,
            };
            ajax(
                "/api/repositories",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "filelist" ).innerHTML = j.payload;
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                    document.getElementById( "modaltitle" ).innerText =
                        document.getElementById( "name" ).innerText +
                        ".repo - (" +
                        document.getElementById( "activecodefile" ).value +
                        ")";
                    window[ "editorchanged" ] = false;
                    document.querySelectorAll( ".tabiClass" )[ 0 ].click();
                    fileTree( "file-tree" );
                    document.getElementById( "file-tree" ).style.display =
                        "block";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const do_RepoPullRequest = ( repoName, repoID, cloudID ) => {
    var aBranch =
        document.getElementById( "pullAselect" ).options[
            document.getElementById( "pullAselect" ).selectedIndex
        ].value;
    var bBranch =
        document.getElementById( "pullBselect" ).options[
            document.getElementById( "pullBselect" ).selectedIndex
        ].value;
    if ( aBranch == bBranch ) {
        showError( "Can not merge the same branch" );
        return;
    }

    var mergeTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
    <span class="input-group-text rounded-0" style="width: 200px;"><b id="mergeColor" style="color: red;">Merge Request</b></span>
    <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control pullsListItem rounded-0" disabled data-index="{INDEX}" value="{BRANCH}">
    <span class="input-group-btn">
        <button class="btn btn-secondary rounded-0 approveMergeButton" style="width: 120px;" type="button" onclick="approve_RepoMerge(this, '${repoName}', '${repoID}', '${cloudID}');">Approve</button>
    </span>
    <span class="input-group-btn">
        <button class="btn btn-secondary rounded-0 closeMergeButton" style="width: 120px;" type="button" onclick="close_RepoMerge(this, '${repoName}', '${repoID}', '${cloudID}');">Close</button>
    </span>
    <span class="input-group-btn">
        <button class="btn btn-secondary rounded-0 mergeApprovedButton" style="width: 120px;" type="button" onclick="do_PullMerge(this, '${repoName}', '${repoID}', '${cloudID}');">Merge</button>
    </span></div>`;

    document.getElementById( "pullButton" ).innerHTML =
        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
    document.getElementById( "pullButton" ).setAttribute( "disabled", "true" );

    var data = JSON.stringify( {
        reponame: repoName,
        id: repoID,
        cloudnode: cloudID,
        brancha: aBranch,
        branchb: bBranch,
        email: document.getElementById( "useremail" ).value,
    } );
    ajax(
        "/api/repositories",
        "create-pull",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            var div = document.createElement( "div" );
            if (
                document
                    .getElementById( "pulllist" )
                    .innerText.indexOf( "no requests are" ) != -1
            ) {
                document.getElementById( "pulllist" ).innerHTML = "";
            }
            div.innerHTML = mergeTemplate
                .replace(
                    "{BRANCH}",
                    document.getElementById( "useremail" ).value +
                    " : " +
                    aBranch +
                    " >> " +
                    bBranch +
                    " : " +
                    j.index.split( "|" )[ 1 ]
                )
                .replace( "{INDEX}", j.index.split( "|" )[ 0 ] );
            document.getElementById( "pulllist" ).append( div );
            showSuccess( j.payload );
            document.getElementById( "pullButton" ).innerHTML = "Create";
            document.getElementById( "pullButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "pullButton" ).innerHTML = "Create";
            document.getElementById( "pullButton" ).removeAttribute( "disabled" );
        }
    );
};

const approve_RepoMerge = ( sender, repoName, repoID, cloudID ) => {
    var pullID = sender.parentNode.parentNode
        .querySelector( ".pullsListItem" )
        .getAttribute( "data-index" );
    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "closed" ) != -1
    ) {
        showError( "This request is closed" );
        return;
    }
    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "approved" ) != -1
    ) {
        showError( "This request is already approved" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to approve this request, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "approve-pull",
            JSON.stringify( {
                reponame: repoName,
                id: repoID,
                cloudnode: cloudID,
                pullid: pullID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                sender.parentNode.parentNode.querySelector(
                    ".pullsListItem"
                ).value = j.payload;
                showSuccess( "Merge request has been approved" );
                sender.parentNode.parentNode.querySelector(
                    "#mergeColor"
                ).style.color = "green";
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const close_RepoMerge = ( sender, repoName, repoID, cloudID ) => {
    var pullID = sender.parentNode.parentNode
        .querySelector( ".pullsListItem" )
        .getAttribute( "data-index" );
    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "closed" ) != -1
    ) {
        showError( "This request is closed" );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to close this request, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "close-pull",
            JSON.stringify( {
                reponame: repoName,
                id: repoID,
                cloudnode: cloudID,
                pullid: pullID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                sender.parentNode.parentNode.querySelector(
                    ".pullsListItem"
                ).value = j.payload;
                showSuccess( "Merge request has been closed" );
                sender.parentNode.parentNode.querySelector(
                    "#mergeColor"
                ).style.color = "red";
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const do_PullMerge = ( sender, repoName, repoID, cloudID ) => {
    var pullID = sender.parentNode.parentNode
        .querySelector( ".pullsListItem" )
        .getAttribute( "data-index" );
    var tmp = sender.parentNode.parentNode
        .querySelector( ".pullsListItem" )
        .value.split( ":" )[ 1 ];
    var aBranch = tmp.replace( ">>", "|" ).split( "|" )[ 0 ].trim();
    var bBranch = tmp.replace( ">>", "|" ).split( "|" )[ 1 ].trim();

    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "closed" ) != -1
    ) {
        showError( "This request is closed" );
        return;
    }
    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "merged" ) != -1
    ) {
        showError( "This request has been merged" );
        return;
    }
    if (
        sender.parentNode.parentNode
            .querySelector( ".pullsListItem" )
            .value.indexOf( "approved" ) == -1
    ) {
        showError(
            "This request requires an approval from an authorized idendity"
        );
        return;
    }
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to execute this merge request, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "merge-pull",
            JSON.stringify( {
                reponame: repoName,
                id: repoID,
                cloudnode: cloudID,
                pullid: pullID,
                brancha: aBranch,
                branchb: bBranch,
            } ),
            ( success ) => {
                var mergeTemplate = `<div class="input-group has-validation flex-nowrap mb-3" >
                <span class="input-group-text rounded-0" style="width: 130px;"><b>Commit</b></span>
                <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control listitem rounded-0" disabled value="{BRANCH}">
                <span class="input-group-btn">
                    <button class="btn btn-secondary rounded-0 undoMergeButton" style="width: 120px;" type="button" onclick="undo_RepoMerge(this, 'item.name', 'item.id', 'item.cloudnode');">Rollback</button>
                </span></div>`;

                var j = JSON.parse( success );

                var mergeList = "";
                for ( var i = 0; i < j.data.split( "\n" ).length; i++ ) {
                    if ( j.data.split( "\n" )[ i ].trim() != "" ) {
                        if (
                            j.data.split( "\n" )[ i ].trim().indexOf( "commit " ) !=
                            -1
                        ) {
                            mergeList =
                                mergeList +
                                mergeTemplate
                                    .replace(
                                        "{BRANCH}",
                                        j.data
                                            .split( "\n" )
                                        [ i ].trim()
                                            .replace( "commit ", "" )
                                            .trim() +
                                        " : " +
                                        j.data.split( "\n" )[ i + 1 ].trim()
                                    )
                                    .replace( "item.name", repoName )
                                    .replace( "item.id", repoID )
                                    .replace( "item.cloudnode", cloudID );
                        }
                    }
                }

                document.getElementById( "mergehistory" ).innerHTML = mergeList;

                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                sender.parentNode.parentNode.querySelector(
                    ".pullsListItem"
                ).value = j.payload;
                showSuccess( "Merge request has been executed" );
                sender.parentNode.parentNode.querySelector(
                    "#mergeColor"
                ).style.color = "blue";

                document.getElementById( "mergehistory" ).innerHTML = mergeList;

                if (
                    document.getElementsByClassName( "undoMergeButton" ).length !=
                    0
                ) {
                    document
                        .getElementsByClassName( "undoMergeButton" )[ 0 ]
                        .setAttribute( "disabled", true );
                }

                document.querySelectorAll( ".tabiClass" )[ 0 ].click();
                do_RepoLoadFiles( repoName, repoID, cloudID );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const delete_RepoClosedPullRequest = ( repoName, repoID, cloudID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to delete all closed merge requests, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        ajax(
            "/api/repositories",
            "delete-closedpulls",
            JSON.stringify( {
                reponame: repoName,
                id: repoID,
                cloudnode: cloudID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "superform-modal" ).style.top = "-180px";
                document.getElementById( "super-modal-back" ).style.display =
                    "none";
                showSuccess( j.payload );
                var items = document.getElementsByClassName( "pullsListItem" );
                for ( i = items.length - 1; i > -1; i-- ) {
                    if ( items[ i ].value.indexOf( "closed" ) != -1 ) {
                        items[ i ].parentNode.parentNode.removeChild(
                            items[ i ].parentNode
                        );
                    }
                }
                if (
                    document.getElementsByClassName( "pullsListItem" ).length == 0
                ) {
                    document.getElementById( "pulllist" ).innerHTML =
                        "<center>no requests are pending</center>";
                }
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const do_NodeLinkClick = ( nodeCMD ) => {
    if ( nodeCMD.indexOf( "edit-node-link" ) != -1 ) {
        edit_NodeLink(
            nodeCMD.split( "," )[ 1 ],
            nodeCMD.split( "," )[ 2 ],
            nodeCMD.split( "," )[ 3 ]
        );
    }
};

const updateMermaid = () => {
    mermaid.initialize( {
        startOnLoad: false,
        securityLevel: "loose",
        width: "100%",
        nodeTextColor: "#ffffff",
        fontFamily: "montserrat",
        primaryColor: "0094FF",
        primaryTextColor: "#ffffff",
        flowchart: { useMaxWidth: true, htmlLabels: true, curve: "cardinal" },
    } );
    mermaid.run( {
        querySelector: ".mermaid",
    } );
    document.querySelector( ".mermaid" ).style.display = "block";
};

const create_NodeLink = () => {
    if (
        document.getElementById( "cloudnodeFrom" ).selectedIndex != -1 &&
        document.getElementById( "cloudnodeTo" ).selectedIndex != -1
    ) {
        var fromNode =
            document.getElementById( "cloudnodeFrom" ).options[
                document.getElementById( "cloudnodeFrom" ).selectedIndex
            ].value;
        var toNode =
            document.getElementById( "cloudnodeTo" ).options[
                document.getElementById( "cloudnodeTo" ).selectedIndex
            ].value;
        var ipRange = document.getElementById( "iprange" ).value;

        if ( ipRange.trim() == "" ) {
            showError( "Please enter a IP range" );
            return;
        }

        if ( fromNode == toNode ) {
            showError( "Can not link the same node" );
            return;
        }

        document.getElementById(
            "createLinkButton"
        ).innerHTML = `<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>`;
        document
            .getElementById( "createLinkButton" )
            .setAttribute( "disabled", "true" );

        ajax(
            "/api/skylink".toLowerCase(),
            "create-link",
            JSON.stringify( {
                fromid: fromNode,
                toid: toNode,
                iprange: ipRange,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                list( document.getElementById( "nav-title" ), false );
                showSuccess( "The process was successfully completed" );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "createLinkButton" ).innerHTML =
                    "Create Link";
                document
                    .getElementById( "createLinkButton" )
                    .removeAttribute( "disabled" );
            }
        );
    } else {
        showError( "No nodes found" );
    }
};

const edit_NodeLink = ( id, fromID, toID ) => {
    var data = JSON.stringify( { fromid: fromID, toid: toID, id: id } );
    ajax(
        "/api/skylink".toLowerCase(),
        "edit",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showModal(
                "Sky Link",
                j.payload,
                "",
                "Close",
                "",
                () => {
                    //save
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const action_NodeLink = ( sender, cmd ) => {
    var data = JSON.stringify( {
        fromid: document.getElementById( "fromid" ).value,
        toid: document.getElementById( "toid" ).value,
        id: document.getElementById( "id" ).value,
        command: cmd,
    } );

    if ( cmd == "DELETE" ) {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
    }

    sender.innerHTML = `<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>`;
    sender.setAttribute( "disabled", "true" );

    ajax(
        "/api/skylink".toLowerCase(),
        "save",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.test ) {
                showInfo( j.payload, 10000 );
                document.getElementById( "cancelButton" ).click();
            } else {
                showSuccess( j.payload );
                list( document.getElementById( "nav-title" ), false );
                document.getElementById( "cancelButton" ).click();
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            sender.removeAttribute( "disabled" );
        }
    );
};

const listGrants = ( sender ) => {
    var grants = sender.options[ sender.selectedIndex ].value;
    var template = `<div class="form-check form-switch" style="float: left; margin-right: 20px;">
                        <input class="form-check-input grantCheck rounded-0" type="checkbox" onchange='onGrantChange(this);' role="switch" id="{ID}">
                        <label class="form-check-label" for="{ID}">{NAME}</label>
                    </div>`;
    var grantList = `<div class="form-check form-switch" style="float: left; margin-right: 20px;">
                    <input class="form-check-input grantCheck rounded-0" type="checkbox" onchange='onGrantChange(this);' role="switch" id="grant-full">
                    <label class="form-check-label" for="grant-full">full</label>
</div>`;
    grants.split( "," ).sort().forEach( function ( item ) {
        if ( item != "" ) {
            grantList =
                grantList +
                template
                    .replace( /{ID}/g, "grant-" + item )
                    .replace( "{NAME}", item );
        }
    } );
    document.getElementById( "grants" ).innerHTML = grantList;
    document.getElementById( "grantResource" ).value = "";

    // ajax(
    //     "/api/roles",
    //     "list-resources",
    //     JSON.stringify( {
    //         name: document.getElementById( "grantlist" ).options[
    //             document.getElementById( "grantlist" ).selectedIndex
    //         ].text,
    //         operator: document.getElementById( "operator" ).value,
    //     } ),
    //     ( success ) => {
    //         var j = JSON.parse( success );
    //         document.getElementById( "grantResource" ).innerHTML = j.payload;
    //     },
    //     ( error ) => {
    //         var j = JSON.parse( error );
    //         showError( j.message );
    //     }
    // );
};

const onGrantChange = ( sender ) => {
    if ( sender.id == "grant-full" ) {
        var checklist = document.getElementsByClassName( "grantCheck" );
        for ( i = 0; i < checklist.length; i++ ) {
            checklist[ i ].checked = sender.checked;
        }
    } else {
        if ( sender.id != "grant-full" ) {
            document.getElementById( "grant-full" ).checked = false;
        }
    }
};

const getQueueStatus = ( itemID, cloudID, itemName ) => {
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
    } );
    ajax(
        "/api/serverless-mq",
        "status",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + itemID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + itemID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const getEventStatus = ( itemID, cloudID, itemName ) => {
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
    } );
    ajax(
        "/api/eventhub",
        "status",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + itemID ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + itemID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const purge_MQStorage = ( itemID, itemName, cloudID ) => {
    var delMessage = `<b>You are about to perform an <span style="color: red;">ireversable purge operation</span> which will delete all messages in the queue.</b><br><br>Do you want to continue?`;

    showModal(
        "Purge Queue",
        delMessage,
        "Purge",
        "Cancel",
        "",
        () => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );

            var data = JSON.stringify( {
                id: itemID,
                cloudnode: cloudID,
                name: itemName,
            } );
            ajax(
                "/api/serverless-mq",
                "purge",
                data,
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        showSuccess( j.payload );
                    }, 500 );
                    setTimeout( () => {
                        list( document.getElementById( "nav-title" ), false );
                    }, 1500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        showError( j.message );
                    }, 500 );
                }
            );
        },
        () => {
            //cancel
            document.getElementById( "quitButton" ).click();
        }
    );
};

const sendReceive_MQStorage = ( itemID, itemName, cloudID ) => {
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
    } );
    ajax(
        "/api/serverless-mq",
        "edit",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showModal(
                "Send/Receive Messages",
                j.payload,
                "",
                "Close",
                "modal-lg",
                () => { },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        () => {
            showError( "Something went wrong, please try again" );
        }
    );
};

const sendmessage_MQStorage = () => {
    var itemID = document.getElementById( "id" ).value;
    var itemName = document.getElementById( "name" ).value;
    var cloudID = document.getElementById( "cloudnode" ).value;
    var messageData = document.getElementById( "sendmessage" ).value;

    if ( messageData.trim() == "" ) {
        showError( "Please enter message/data" );
        return;
    }

    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
        postdata: messageData,
    } );

    ajax(
        "/api/serverless-mq",
        "send",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const receive_MQStorage = ( ack ) => {
    var itemID = document.getElementById( "id" ).value;
    var itemName = document.getElementById( "name" ).value;
    var cloudID = document.getElementById( "cloudnode" ).value;
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
        delete: ack,
    } );

    ajax(
        "/api/serverless-mq",
        "receive",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "receivemessage" ).value = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const mirror_BlockStorage = ( itemID, itemName, cloudID, itemType ) => {
    if ( itemType != "" ) {
        if ( itemType == "X Virtual Machine Disk" ) {
            showError( "Can not mirror a X Virtual Machine Disk" );
            return;
        }
    }
    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        type: itemType,
    } );
    ajax( "/api/blockstorage", "mirror", data, ( dialog ) => {
        var j = JSON.parse( dialog );
        showModal(
            "Mirror Block Storage",
            j.payload,
            "Mirror",
            "Cancel",
            "",
            () => {
                if ( document.getElementById( "devices" ).selectedIndex == -1 ) {
                    showError( "No compatible devices found" );
                    return;
                }

                var folderCheck =
                    document.getElementById( "devices" ).options[
                        document.getElementById( "devices" ).selectedIndex
                    ].text;
                if ( folderCheck != "Disable Mirror" ) {
                    if (
                        folderCheck.indexOf(
                            "[" + document.getElementById( "name" ).value + "]"
                        ) == -1
                    ) {
                        showError(
                            "Destination folder name must be identical to the source name"
                        );
                        return;
                    }
                }

                var data = JSON.stringify( {
                    id: document.getElementById( "id" ).value,
                    operator: document.getElementById( "operator" ).value,
                    cloudnode: document.getElementById( "cloudid" ).value,
                    type: document.getElementById( "type" ).value,
                    name: document.getElementById( "name" ).value,
                    deviceid:
                        document.getElementById( "devices" ).options[
                            document.getElementById( "devices" ).selectedIndex
                        ].value,
                    cleardata: document.getElementById( "cleardata" ).checked,
                } );

                document.getElementById( "okButton" ).innerHTML =
                    '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                document
                    .getElementById( "cancelButton" )
                    .setAttribute( "disabled", "yes" );
                document
                    .getElementById( "okButton" )
                    .setAttribute( "disabled", "yes" );

                ajax(
                    "/api/blockstorage",
                    "do-mirror",
                    data,
                    ( success ) => {
                        var j = JSON.parse( success );
                        showSuccess( j.payload );
                        list( document.getElementById( "nav-title" ), false );
                        document.getElementById( "quitButton" ).click();
                    },
                    ( error ) => {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Mirror";
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                document.getElementById( "quitButton" ).click();
            }
        );
    } );
};

const attach_BlockStorage = ( itemID, itemName, cloudID, itemType ) => {
    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        type: itemType,
    } );
    ajax( "/api/blockstorage", "attach", data, ( dialog ) => {
        var j = JSON.parse( dialog );
        showModal(
            "Attach Block Storage",
            j.payload,
            "Attach",
            "Cancel",
            "",
            () => {
                if ( document.getElementById( "instances" ).selectedIndex == -1 ) {
                    showError( "No compatible instances found" );
                    return;
                }

                var data = JSON.stringify( {
                    id: document.getElementById( "id" ).value,
                    operator: document.getElementById( "operator" ).value,
                    cloudnode: document.getElementById( "cloudid" ).value,
                    type: document.getElementById( "type" ).value,
                    name: document.getElementById( "name" ).value,
                    instanceid:
                        document.getElementById( "instances" ).options[
                            document.getElementById( "instances" ).selectedIndex
                        ].value,
                } );

                document.getElementById( "okButton" ).innerHTML =
                    '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                document
                    .getElementById( "cancelButton" )
                    .setAttribute( "disabled", "yes" );
                document
                    .getElementById( "okButton" )
                    .setAttribute( "disabled", "yes" );

                ajax(
                    "/api/blockstorage",
                    "do-attach",
                    data,
                    ( success ) => {
                        var j = JSON.parse( success );
                        showSuccess( j.payload );
                        list( document.getElementById( "nav-title" ), false );
                        document.getElementById( "quitButton" ).click();
                    },
                    ( error ) => {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Attach";
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                document.getElementById( "quitButton" ).click();
            }
        );
    } );
};

const detach_BlockStorage = ( itemID, itemName, cloudID, itemType ) => {
    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        type: itemType,
    } );
    ajax( "/api/blockstorage", "detach", data, ( dialog ) => {
        var j = JSON.parse( dialog );
        showModal(
            "Detach Block Storage",
            j.payload,
            "Detach",
            "Cancel",
            "",
            () => {
                if ( document.getElementById( "instances" ).selectedIndex == -1 ) {
                    showError( "No compatible instances found" );
                    return;
                }

                var data = JSON.stringify( {
                    id: document.getElementById( "id" ).value,
                    operator: document.getElementById( "operator" ).value,
                    cloudnode: document.getElementById( "cloudid" ).value,
                    type: document.getElementById( "type" ).value,
                    name: document.getElementById( "name" ).value,
                    instanceid:
                        document.getElementById( "instances" ).options[
                            document.getElementById( "instances" ).selectedIndex
                        ].value,
                } );

                document.getElementById( "okButton" ).innerHTML =
                    '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                document
                    .getElementById( "cancelButton" )
                    .setAttribute( "disabled", "yes" );
                document
                    .getElementById( "okButton" )
                    .setAttribute( "disabled", "yes" );

                ajax(
                    "/api/blockstorage",
                    "do-detach",
                    data,
                    ( success ) => {
                        var j = JSON.parse( success );
                        showSuccess( j.payload );
                        list( document.getElementById( "nav-title" ), false );
                        document.getElementById( "quitButton" ).click();
                    },
                    ( error ) => {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Detach";
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                document.getElementById( "quitButton" ).click();
            }
        );
    } );
};

const delete_BlockStorage = ( itemID, itemName, cloudID, itemType ) => {
    if ( document.getElementById( "attached-" + itemID ).innerText.trim() != "0" ) {
        showError(
            "Can not delete a storage while instances are attached to it"
        );
        return;
    }
    if (
        document.getElementById( "mirror-" + itemID ).innerText.trim() !=
        "DISABLED"
    ) {
        showError( "Can not delete a storage while mirror is active" );
        return;
    }
    delete_Item( itemID, document.getElementById( "nav-title" ).innerText );
};

const searchServices = () => {
    var input, filter, li, i, txtValue;
    input = document.getElementById( "searchServices" );
    filter = input.value.toUpperCase();

    li = document.getElementsByClassName( "nav-group" );
    for ( i = 0; i < li.length; i++ ) {
        li[ i ].classList.add( "show" );
    }

    li = document.getElementsByClassName( "nav-link" );
    for ( i = 0; i < li.length; i++ ) {
        txtValue = li[ i ].textContent || li[ i ].innerText;
        if ( txtValue.toUpperCase().indexOf( filter ) > -1 ) {
            li[ i ].style.display = "";
        } else {
            li[ i ].style.display = "none";
        }
    }

    if ( input.value.trim() == "" ) {
        li = document.getElementsByClassName( "nav-group" );
        for ( i = 0; i < li.length; i++ ) {
            li[ i ].classList.remove( "show" );
        }
        li = document.getElementsByClassName( "nav-link" );
        for ( i = 0; i < li.length; i++ ) {
            li[ i ].style.display = "";
        }
    }
};

const listServices = ( sender ) => {
    ajax(
        "/api/start",
        "list-services",
        JSON.stringify( { index: sender.selectedIndex } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "sidemenu" ).innerHTML = atob( j.payload );
            setTimeout( () => {
                new SimpleBar( document.getElementById( "sidebar" ) );
            }, 100 );
        }
    );
};

const setSampleJson = ( sender ) => {
    if ( sender.selectedIndex == 0 ) {
        window[ "editor" ].setValue(
            '{\n  "collection": "contacts",\n  "record": {\n    "name": "John",\n    "age": 29,\n    "insured": true\n  }\n}\n',
            -1
        );
    } else if ( sender.selectedIndex == 1 ) {
        window[ "editor" ].setValue(
            '{\n  "collection": "contacts",\n  "where": "@name == \'John\' || @name == \'Johnathan\' && @age > 28 && @insured == true"\n}\n',
            -1
        );
    } else if ( sender.selectedIndex == 2 ) {
        window[ "editor" ].setValue(
            '{\n  "collection": "contacts",\n  "record": {\n    "name": "Johnathan",\n    "age": 32,\n    "insured": true,\n    "newfield": "has a new car"\n  },\n  "cid": 0\n}\n',
            -1
        );
    } else if ( sender.selectedIndex == 3 ) {
        window[ "editor" ].setValue(
            '{\n  "collection": "contacts",\n  "cid": 0\n}\n',
            -1
        );
    } else if ( sender.selectedIndex == 4 ) {
        window[ "editor" ].setValue( '{}\n', -1 );
    } else if ( sender.selectedIndex == 5 ) {
        window[ "editor" ].setValue(
            '{\n  "collection": "contacts"\n}\n',
            -1
        );
    }
    window[ "editor" ].getSession().setUndoManager( new ace.UndoManager() );
};

const database_Json_Post = () => {
    var data = {
        id: document.getElementById( 'id' ).value,
        postdata: window[ "editor" ].getValue()
    };
    var cmd =
        document.getElementById( "cmd" ).options[
            document.getElementById( "cmd" ).selectedIndex
        ].value;
    ajax(
        "/api/serverless-json",
        cmd,
        JSON.stringify( data ),
        ( success ) => {
            document.getElementById( "result" ).value = JSON.stringify(
                JSON.parse( success ),
                null,
                2
            );
        },
        ( error ) => {
            document.getElementById( "result" ).value = JSON.stringify(
                JSON.parse( error ),
                null,
                2
            );
        }
    );
};

const database_SQL_Post = () => {
    var jData = window[ "editor" ].getValue();
    var cmd =
        document.getElementById( "cmd" ).options[
            document.getElementById( "cmd" ).selectedIndex
        ].value;
    ajax(
        "/api/serverless-sql",
        cmd,
        jData,
        ( success ) => {
            document.getElementById( "result" ).value = JSON.stringify(
                JSON.parse( success ),
                null,
                2
            );
        },
        ( error ) => {
            document.getElementById( "result" ).value = JSON.stringify(
                JSON.parse( error ),
                null,
                2
            );
        }
    );
};

const positionMobile = ( ev ) => {
    mobile_last_move = ev;
};

const allowDrop = ( ev ) => {
    ev.preventDefault();
};

const drag = ( ev ) => {
    if ( ev.type === "touchstart" ) {
        mobile_item_selec = ev.target
            .closest( ".drag-drawflow" )
            .getAttribute( "type" );
    } else {
        ev.dataTransfer.setData( "node", ev.target.getAttribute( "type" ) );
    }
};

const drop = ( ev ) => {
    if ( ev.type === "touchend" ) {
        var parentdrawflow = document
            .elementFromPoint(
                mobile_last_move.touches[ 0 ].clientX,
                mobile_last_move.touches[ 0 ].clientY
            )
            .closest( "#drawflow" );
        if ( parentdrawflow != null ) {
            addNodeToDrawFlow(
                mobile_item_selec,
                mobile_last_move.touches[ 0 ].clientX,
                mobile_last_move.touches[ 0 ].clientY
            );
        }
        mobile_item_selec = "";
    } else {
        ev.preventDefault();
        var data = ev.dataTransfer.getData( "node" );
        addNodeToDrawFlow( data, ev.clientX, ev.clientY );
    }
};

const addNodeToDrawFlow = ( name, pos_x, pos_y ) => {
    if ( window[ "flow" ].editor_mode === "fixed" ) {
        return false;
    }
    pos_x =
        pos_x *
        ( window[ "flow" ].precanvas.clientWidth /
            ( window[ "flow" ].precanvas.clientWidth * window[ "flow" ].zoom ) ) -
        window[ "flow" ].precanvas.getBoundingClientRect().x *
        ( window[ "flow" ].precanvas.clientWidth /
            ( window[ "flow" ].precanvas.clientWidth * window[ "flow" ].zoom ) );
    pos_y =
        pos_y *
        ( window[ "flow" ].precanvas.clientHeight /
            ( window[ "flow" ].precanvas.clientHeight * window[ "flow" ].zoom ) ) -
        window[ "flow" ].precanvas.getBoundingClientRect().y *
        ( window[ "flow" ].precanvas.clientHeight /
            ( window[ "flow" ].precanvas.clientHeight * window[ "flow" ].zoom ) );

    var data = JSON.stringify( { name: name } );
    ajax(
        "/api/flow-fx",
        "flow-template",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            window[ "flow" ].addNode(
                name,
                j.payload.input,
                j.payload.output,
                pos_x,
                pos_y,
                name,
                j.payload.data,
                j.payload.html
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const doSaveFlowFX = () => {
    if ( document.getElementById( "name" ).value.trim() == "" ) {
        showError( "please enter a name" );
        return;
    }
    document.getElementById( "designer" ).value = btoa(
        JSON.stringify( window[ "flow" ].export() )
    );
    var data = JSON.stringify( {
        name: document.getElementById( "name" ).value,
        comments: document.getElementById( "comments" ).value,
        id: document.getElementById( "fid" ).value,
        operator: document.getElementById( "operator" ).value,
        designer: document.getElementById( "designer" ).value,
        loglevel:
            document.getElementById( "loglevel" ).options[
                document.getElementById( "loglevel" ).selectedIndex
            ].value,
    } );

    ajax(
        "/api/flow-fx",
        "save",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
            window[ "flowchanged" ] = false;
            document.getElementById( "modaltitle" ).innerText =
                "Flow-fx (" + document.getElementById( "name" ).value + ")";
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const showFlowProperties = ( id, flowType ) => {
    var data = JSON.stringify( { name: flowType } );
    ajax(
        "/api/flow-fx",
        "flow-prop",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            j.payload.html = j.payload.html
                .replace(
                    /item.flowname/g,
                    window[ "flow" ].drawflow.flowfx.module.data[ id ].name
                )
                .replace( /item.flow-id/g, id );

            if ( j.payload.html.indexOf( "item." ) != -1 ) {
                for ( var key of Object.keys(
                    window[ "flow" ].drawflow.flowfx.module.data[ id ].data
                ) ) {
                    var clName = window[ "flow" ].drawflow.flowfx.module.data[ id ].class;
                    var cmdName = clName.replace( window[ "flow" ].drawflow.flowfx.module.data[ id ].data.apiname + "-", "" );
                    var apiName = window[ "flow" ].drawflow.flowfx.module.data[ id ].data.apiname;
                    var checked = "";
                    try {
                        //console.log( key + " : " + window[ "flow" ].drawflow.flowfx.module.data[ id ].data[ key ] );
                        if ( window[ "flow" ].drawflow.flowfx.module.data[ id ].data[ key ].toString() == 'true' ) {
                            checked = "checked";
                        }
                    } catch { }
                    var keyValue = window[ "flow" ].drawflow.flowfx.module.data[ id ].data[ key ];
                    if ( key == "output" ) {
                        if ( keyValue.trim() == "i" ) {
                            keyValue = `{
    "result": "?input.result?",
    "payload": "?input.payload?",
    "message": "?input.message?"
}`;
                        }
                        if ( keyValue.trim() == "a" ) {
                            keyValue = `{
    "result": "?api.result?",
    "payload": "?api.payload?",
    "message": "?api.message?"
}`;
                        }
                        if ( keyValue.trim() == "c" ) {
                            keyValue = `{
    "result": "?code.result?",
    "payload": "?code.payload?",
    "message": "?code.message?"
}`;
                        }
                        window[ "flow" ].drawflow.flowfx.module.data[ id ].data[ key ] = keyValue;
                    }
                    if ( keyValue.toString().trim() != "" ) {
                        j.payload.html = j.payload.html
                            .replace( "item." + key, keyValue )
                            .replace( "item-" + keyValue.toString(), "selected" )
                            .replace( "check." + key, checked )
                            .replace( "item.classname", "<b><i>" + apiName + "</i></b> Command: <b><i>" + cmdName + "</i></b>" );
                    }
                }
            }

            let ls = [];
            if ( j.payload.html.indexOf( "item." ) != -1 ) {
                var tmp = j.payload.html;
                while ( tmp.indexOf( "id=" ) != -1 ) {
                    key = tmp.substring( tmp.indexOf( "id=" ) + 4 );
                    key = key.substring( 0, key.indexOf( '"' ) );
                    tmp = tmp.substring( tmp.indexOf( "id=" ) + key.length + 1 );
                    ls.push( key.replace( /"/g, "" ).replace( / /g ), "" );
                }
            }

            for ( i = 0; i < ls.length; i++ ) {
                if ( ls[ i ].trim() != "" ) {
                    if ( !ls[ i ].startsWith( "flow" ) ) {
                        j.payload.html = j.payload.html.replace( "item." + ls[ i ], "" );
                    }
                }
            }

            j.payload.html = j.payload.html.replace( "item.classname", window[ "flow" ].drawflow.flowfx.module.data[ id ].class );

            document.getElementById( "properties" ).innerHTML = j.payload.html;
            document.getElementById( "properties" ).classList.add( 'slidein' );
            document.getElementById( "properties" ).classList.remove( 'slideout' );
            try {
                document.getElementById( 'pid' ).value = document.getElementById( 'fid' ).value;
            } catch { }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const updateFlowProp = () => {
    var id = parseInt( document.getElementById( "flow-id" ).value );
    var data = saveProp();
    window[ "flow" ].drawflow.flowfx.module.data[ id ].name =
        document.getElementById( "flow-name" ).value;
    window[ "flow" ].drawflow.flowfx.module.data[ id ].data = data;
    var t = document.querySelector(
        ".drawflow-node[id='node-" + id + "'] .drawflow_content_node"
    );
    t.innerHTML =
        "<div>" + document.getElementById( "flow-name" ).value + "</div>";
    window[ "flow" ].drawflow.flowfx.module.data[ id ].html =
        "<div>" + document.getElementById( "flow-name" ).value + "</div>";
    window[ "flowchanged" ] = true;
    window[ "flow" ].updateConnectionNodes( `node-${id}` );
    if ( data.output != undefined ) {
        if (
            data.output.trim() == "i" ||
            data.output.trim() == "a" ||
            data.output.trim() == "c"
        ) {
            showFlowProperties( id, window[ "flow" ].drawflow.flowfx.module.data[ id ].class );
        }
    }
};

const loadS3Files = ( itemID, itemName, cloudID ) => {
    document.getElementById(
        "s3list"
    ).innerHTML = `<center><div style="margin-top: 50px;" id="spinner" class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span></div><br>LOADING</center>`;

    document.getElementById( "selectall" ).checked = false;

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        path: document.getElementById( "path" ).value,
        cloudnode: cloudID,
        showversions: document.getElementById( "showversions" ).checked,
        search: document.getElementById( "searchfor" ).value,
    } );

    document.getElementById( "searchButton" ).innerHTML =
        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
    document.getElementById( "searchButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/objectstorage",
        "list-bucket",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.payload == "" ) {
                document.getElementById( "s3list" ).innerHTML =
                    "<center><br><br>this bucket is empty</center>";
            } else {
                document.getElementById( "s3list" ).innerHTML = j.payload;
            }
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "s3list" ).innerHTML =
                "<center><br><br><span style='color: red;'>" +
                j.message +
                "</span></center>";
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        }
    );
};

const newS3Folder = ( itemID, itemName, cloudID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    document.getElementById( "newfilename" ).value =
        document.getElementById( "path" ).value + "/";
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            document.getElementById( "superform-modal" ).style.top = "-180px";
            document.getElementById( "super-modal-back" ).style.display = "none";
            showInfo( "Command was issued, please wait" );
            var data = {
                path: newFilename,
                id: itemID,
                name: itemName,
                cloudnode: cloudID,
            };
            ajax(
                "/api/objectstorage",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "searchButton" ).click();
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const openS3Folder = ( itemID, itemName, cloudID, item ) => {
    var path = document.getElementById( "path" ).value;
    if ( item != "" ) {
        path = path + "/" + item.replace( "/", "" );
        document.getElementById( "path" ).value = path;
        loadS3Files( itemID, itemName, cloudID );
    } else {
        var tmp = "";
        if ( path != itemName ) {
            for ( i = 0; i < path.split( "/" ).length - 1; i++ ) {
                if ( tmp == "" ) {
                    tmp = path.split( "/" )[ i ];
                } else {
                    tmp = tmp + "/" + path.split( "/" )[ i ];
                }
            }
        }
        document.getElementById( "path" ).value = tmp;
        loadS3Files( itemID, itemName, cloudID );
    }
};

const downloadS3File = ( itemID, itemName, cloudID, item ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to download the file [" + item + "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        showInfo( "Command issued, please wait" );
        ajax(
            "/api/objectstorage",
            "download-file",
            JSON.stringify( {
                filename: item,
                id: itemID,
                name: itemName,
                path: document.getElementById( "path" ).value,
                cloudnode: cloudID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                window.open( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const deleteS3File = ( itemID, itemName, cloudID, item ) => {
    var checks = document.getElementsByClassName( "form-check-input" );
    var files = [];
    for ( i = 0; i < checks.length; i++ ) {
        if ( checks[ i ].id != "showversions" && checks[ i ].id != "selectall" ) {
            if ( checks[ i ].checked ) {
                files.push( { name: checks[ i ].id } );
            }
        }
    }

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        path: document.getElementById( "path" ).value,
        items: files,
    } );

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about delete files/folders, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        showInfo( "Command issued, please wait" );
        document.getElementById( "deleteButton" ).innerHTML =
            "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
        document
            .getElementById( "deleteButton" )
            .setAttribute( "disabled", "true" );
        ajax(
            "/api/objectstorage",
            "delete-file",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
                document.getElementById( "searchButton" ).click();
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const loadR3Files = ( itemID, itemName, cloudID ) => {
    document.getElementById(
        "s3list"
    ).innerHTML = `<center><div style="margin-top: 50px;" id="spinner" class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span></div><br>LOADING</center>`;

    document.getElementById( "selectall" ).checked = false;

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        path: document.getElementById( "path" ).value,
        cloudnode: cloudID,
        search: document.getElementById( "searchfor" ).value,
    } );

    document.getElementById( "searchButton" ).innerHTML =
        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
    document.getElementById( "searchButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/rapidstorage",
        "list-bucket",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.payload == "" ) {
                document.getElementById( "s3list" ).innerHTML =
                    "<center><br><br>this bucket is empty</center>";
            } else {
                document.getElementById( "s3list" ).innerHTML = j.payload;
            }
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "s3list" ).innerHTML =
                "<center><br><br><span style='color: red;'>" +
                j.message +
                "</span></center>";
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        }
    );
};

const newR3Folder = ( itemID, itemName, cloudID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    document.getElementById( "newfilename" ).value =
        document.getElementById( "path" ).value + "/";
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            document.getElementById( "superform-modal" ).style.top = "-180px";
            document.getElementById( "super-modal-back" ).style.display = "none";
            showInfo( "Command was issued, please wait" );
            var data = {
                path: newFilename,
                id: itemID,
                name: itemName,
                cloudnode: cloudID,
            };
            ajax(
                "/api/rapidstorage",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "searchButton" ).click();
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const openR3Folder = ( itemID, itemName, cloudID, item ) => {
    var path = document.getElementById( "path" ).value;
    if ( item != "" ) {
        path = path + "/" + item.replace( "/", "" );
        document.getElementById( "path" ).value = path;
        loadR3Files( itemID, itemName, cloudID );
    } else {
        var tmp = "";
        if ( path != itemName ) {
            for ( i = 0; i < path.split( "/" ).length - 1; i++ ) {
                if ( tmp == "" ) {
                    tmp = path.split( "/" )[ i ];
                } else {
                    tmp = tmp + "/" + path.split( "/" )[ i ];
                }
            }
        }
        document.getElementById( "path" ).value = tmp;
        loadR3Files( itemID, itemName, cloudID );
    }
};

const downloadR3File = ( itemID, itemName, cloudID, item ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to download the file [" + item + "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        showInfo( "Command issued, please wait" );
        ajax(
            "/api/rapidstorage",
            "download-file",
            JSON.stringify( {
                filename: item,
                id: itemID,
                name: itemName,
                path: document.getElementById( "path" ).value,
                cloudnode: cloudID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                window.open( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const deleteR3File = ( itemID, itemName, cloudID, item ) => {
    var checks = document.getElementsByClassName( "form-check-input" );
    var files = [];
    for ( i = 0; i < checks.length; i++ ) {
        if ( checks[ i ].id != "showversions" && checks[ i ].id != "selectall" ) {
            if ( checks[ i ].checked ) {
                files.push( { name: checks[ i ].id } );
            }
        }
    }

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        path: document.getElementById( "path" ).value,
        items: files,
    } );

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about delete files/folders, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        showInfo( "Command issued, please wait" );
        document.getElementById( "deleteButton" ).innerHTML =
            "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
        document
            .getElementById( "deleteButton" )
            .setAttribute( "disabled", "true" );
        ajax(
            "/api/rapidstorage",
            "delete-file",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
                document.getElementById( "searchButton" ).click();
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const loadB3Files = ( itemID, itemName, cloudID ) => {
    document.getElementById(
        "s3list"
    ).innerHTML = `<center><div style="margin-top: 50px;" id="spinner" class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span></div><br>LOADING</center>`;

    document.getElementById( "selectall" ).checked = false;

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        path: document.getElementById( "path" ).value,
        cloudnode: cloudID,
        search: document.getElementById( "searchfor" ).value,
    } );

    document.getElementById( "searchButton" ).innerHTML =
        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
    document.getElementById( "searchButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/blockstorage",
        "list-bucket",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.payload == "" ) {
                document.getElementById( "s3list" ).innerHTML =
                    "<center><br><br>this storage is empty</center>";
            } else {
                document.getElementById( "s3list" ).innerHTML = j.payload;
            }
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "s3list" ).innerHTML =
                "<center><br><br><span style='color: red;'>" +
                j.message +
                "</span></center>";
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        }
    );
};

const newB3Folder = ( itemID, itemName, cloudID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    document.getElementById( "newfilename" ).value =
        document.getElementById( "path" ).value + "/";
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            document.getElementById( "superform-modal" ).style.top = "-180px";
            document.getElementById( "super-modal-back" ).style.display = "none";
            showInfo( "Command was issued, please wait" );
            var data = {
                path: newFilename,
                id: itemID,
                name: itemName,
                cloudnode: cloudID,
            };
            ajax(
                "/api/blockstorage",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "searchButton" ).click();
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const openB3Folder = ( itemID, itemName, cloudID, item ) => {
    var path = document.getElementById( "path" ).value;
    if ( item != "" ) {
        path = path + "/" + item.replace( "/", "" );
        document.getElementById( "path" ).value = path;
        loadB3Files( itemID, itemName, cloudID );
    } else {
        var tmp = "";
        if ( path != itemName ) {
            for ( i = 0; i < path.split( "/" ).length - 1; i++ ) {
                if ( tmp == "" ) {
                    tmp = path.split( "/" )[ i ];
                } else {
                    tmp = tmp + "/" + path.split( "/" )[ i ];
                }
            }
        }
        document.getElementById( "path" ).value = tmp;
        loadB3Files( itemID, itemName, cloudID );
    }
};

const downloadB3File = ( itemID, itemName, cloudID, item ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to download the file [" + item + "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        showInfo( "Command issued, please wait" );
        ajax(
            "/api/blockstorage",
            "download-file",
            JSON.stringify( {
                filename: item,
                id: itemID,
                name: itemName,
                path: document.getElementById( "path" ).value,
                cloudnode: cloudID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                window.open( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const deleteB3File = ( itemID, itemName, cloudID, item ) => {
    var checks = document.getElementsByClassName( "form-check-input" );
    var files = [];
    for ( i = 0; i < checks.length; i++ ) {
        if ( checks[ i ].id != "showversions" && checks[ i ].id != "selectall" ) {
            if ( checks[ i ].checked ) {
                files.push( { name: checks[ i ].id } );
            }
        }
    }

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
        path: document.getElementById( "path" ).value,
        items: files,
    } );

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about delete files/folders, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        showInfo( "Command issued, please wait" );
        document.getElementById( "deleteButton" ).innerHTML =
            "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
        document
            .getElementById( "deleteButton" )
            .setAttribute( "disabled", "true" );
        ajax(
            "/api/blockstorage",
            "delete-file",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
                document.getElementById( "searchButton" ).click();
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const change_IP = ( itemID, module ) => {
    var data = JSON.stringify( { id: itemID } );
    ajax(
        "/api/" + module.toLowerCase().replace( / /g, "" ),
        "change-ip",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showModal(
                "IP Settings",
                j.payload,
                "Save",
                "Cancel",
                "",
                () => {
                    var data = JSON.stringify( {
                        id: itemID,
                        ip: document.getElementById( "ip" ).value,
                    } );
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    ajax(
                        "/api/" + module.toLowerCase().replace( / /g, "" ),
                        "set-ip",
                        data,
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        () => {
            showError( "Something went wrong, please try again" );
        }
    );
};

const join_DockerSwarmMember = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-app",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-app",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_DockerSwarmMember = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-app",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-app",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const node_Restart = ( nodeID ) => {
    if (
        document
            .getElementById( "status-" + nodeID )
            .innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + nodeID )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            showError(
                "Node is not ready - " +
                document.getElementById( "status-" + nodeID ).innerText
            );
        }
        return;
    }
    showModal(
        "Restart Services",
        "<b style='color: red;'>CAUTION</b><br>You are about to restart all node and cloud core services, which may result in data loss, continue?<br><br>This action will not affect any running instances.",
        "Yes",
        "No",
        "",
        () => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Service Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
            ajax(
                "/api/skynodes".toLowerCase(),
                "restart-services",
                JSON.stringify( { id: nodeID } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "quitButton" ).click();
                },
                ( error ) => {
                    document
                        .getElementById( "cancelButton" )
                        .removeAttribute( "disabled" );
                    document
                        .getElementById( "okButton" )
                        .removeAttribute( "disabled" );
                    document.getElementById( "okButton" ).innerHTML = "Yes";
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const node_Reboot = ( nodeID ) => {
    if (
        document
            .getElementById( "status-" + nodeID )
            .innerText.indexOf( "READY" ) == -1
    ) {
        if (
            document
                .getElementById( "status-" + nodeID )
                .innerText.indexOf( "{SKYNAME} Connect" ) != -1
        ) {
            showError( "Node is not ready, please deploy {NEBULA} first" );
        } else {
            showError(
                "Node is not ready - " +
                document.getElementById( "status-" + nodeID ).innerText
            );
        }
        return;
    }
    showModal(
        "Restart Services",
        "You are about to reboot this node, continue?",
        "Yes",
        "No",
        "",
        () => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Node Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
            ajax(
                "/api/skynodes".toLowerCase(),
                "reboot",
                JSON.stringify( { id: nodeID } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "quitButton" ).click();
                },
                ( error ) => {
                    document
                        .getElementById( "cancelButton" )
                        .removeAttribute( "disabled" );
                    document
                        .getElementById( "okButton" )
                        .removeAttribute( "disabled" );
                    document.getElementById( "okButton" ).innerHTML = "Yes";
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const getDCDeploymentStatus = ( itemID ) => {
    var api = document.getElementById( "nav-title" ).innerText;
    api = api.replace( / /g, "" ).toLowerCase();
    ajax(
        "/api/" + api,
        "deployment-status",
        JSON.stringify( { id: itemID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "deploymentstatus-" + itemID ).innerHTML =
                "<span style='color: green;'>" + j.payload + "</span>";
            document.getElementById( "serviceports-" + itemID ).innerHTML =
                j.serviceports;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "deploymentstatus-" + itemID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
            document.getElementById( "serviceports-" + itemID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
        }
    );
};

const scale_DockerClusterSolution = ( clusterID, operatorID ) => {
    if (
        document
            .getElementById( "deploymentstatus-" + clusterID )
            .innerText.trim() == "none"
    ) {
        showError( "there is no solution to scale on this cluster" );
        return;
    }

    ajax(
        "/api/magna-app",
        "scale",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Scale Solution",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = {
                        id: clusterID,
                        operator: operatorID,
                        solution: document.getElementById( "solution" ).value,
                        scale: document.getElementById( "scale" ).value,
                    };
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-app",
                        "scale-solution",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const remove_DockerClusterSolution = ( clusterID, operatorID ) => {
    if (
        document
            .getElementById( "deploymentstatus-" + clusterID )
            .innerText.trim() == "none"
    ) {
        showError( "there is no solution to remove on this cluster" );
        return;
    }

    ajax(
        "/api/magna-app",
        "remove",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Remove Solution",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = {
                        id: clusterID,
                        operator: operatorID,
                        solution: document.getElementById( "solution" ).value,
                    };
                    ajax(
                        "/api/magna-app",
                        "remove-solution",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const remove_DockerMachineSolution = ( itemID ) => {
    ajax(
        "/api/magna-nodes",
        "remove",
        JSON.stringify( { id: itemID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Remove Solution",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = {
                        id: itemID,
                        solution: document.getElementById( "solution" ).value,
                    };
                    ajax(
                        "/api/magna-nodes",
                        "remove-solution",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const join_MassiveDBCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-db",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var test = document.getElementById(
                        "members-" + clusterID
                    ).innerText;
                    let m = test.split( "/" )[ 0 ];
                    let a = test.split( "/" )[ 1 ];
                    if ( parseInt( m ) != parseInt( a ) ) {
                        showError(
                            "please wait for all nodes to come online before you join a new member"
                        );
                        return;
                    }
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-db",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_MassiveDBCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-db",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/magna-db",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getDCDatabaseStatus = ( itemID ) => {
    var api = document.getElementById( "nav-title" ).innerText;
    api = api.replace( / /g, "" ).toLowerCase();
    ajax(
        "/api/" + api,
        "status",
        JSON.stringify( { id: itemID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "databases-" + itemID ).innerHTML =
                "<span style='color: green;'>" + j.payload + "</span>";
            document.getElementById( "members-" + itemID ).innerHTML = j.status;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "databases-" + itemID ).innerHTML =
                "<span style='color: red;'>" + j.message + "</span>";
            document.getElementById( "members-" + itemID ).innerHTML = j.status;
        }
    );
};

const open_MagnaSQL = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-db",
        "cql",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Close";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "CQL Window",
                j.payload,
                okCaption,
                cancelCaption,
                "modal-fullscreen",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_MagnaSQLSQL = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqld",
        "sql",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Close";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "SQL Window",
                j.payload,
                okCaption,
                cancelCaption,
                "modal-fullscreen",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_MagnaSQLRSQL = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqlr",
        "sql",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Close";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "SQL Window",
                j.payload,
                okCaption,
                cancelCaption,
                "modal-fullscreen",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const magna_SQL_Post = () => {
    var data = JSON.stringify( {
        cql: window[ "editor" ].getValue(),
        id: document.getElementById( "id" ).value,
        name: document.getElementById( "name" ).value,
        operator: document.getElementById( "operator" ).value,
    } );

    var test = document.getElementById(
        "members-" + document.getElementById( "id" ).value
    ).innerText;
    let m = test.split( "/" )[ 0 ];
    let a = test.split( "/" )[ 1 ];
    if ( parseInt( m ) != parseInt( a ) ) {
        showError( "please wait for all nodes to come online" );
        return;
    }

    document.getElementById( "runButton" ).innerHTML =
        '<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>';
    document.getElementById( "runButton" ).setAttribute( "disabled", "true" );
    document.getElementById( "result" ).value = "";

    ajax(
        "/api/magna-db",
        "cql-run",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "result" ).value = j.payload;
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        }
    );
};

const magna_SQLSQL_Post = () => {
    var data = JSON.stringify( {
        sql: window[ "editor" ].getValue(),
        id: document.getElementById( "id" ).value,
        name: document.getElementById( "name" ).value,
        operator: document.getElementById( "operator" ).value,
    } );

    var test = document.getElementById(
        "members-" + document.getElementById( "id" ).value
    ).innerText;
    let m = test.split( "/" )[ 0 ];
    let a = test.split( "/" )[ 1 ];
    if ( parseInt( m ) != parseInt( a ) ) {
        showError( "please wait for all nodes to come online" );
        return;
    }

    document.getElementById( "runButton" ).innerHTML =
        '<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>';
    document.getElementById( "runButton" ).setAttribute( "disabled", "true" );
    document.getElementById( "result" ).value = "";

    ajax(
        "/api/magna-sqld",
        "sql-run",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "result" ).value = j.payload;
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        }
    );
};

const magna_SQLRSQL_Post = () => {
    var data = JSON.stringify( {
        sql: window[ "editor" ].getValue(),
        id: document.getElementById( "id" ).value,
        name: document.getElementById( "name" ).value,
        operator: document.getElementById( "operator" ).value,
    } );

    document.getElementById( "runButton" ).innerHTML =
        '<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>';
    document.getElementById( "runButton" ).setAttribute( "disabled", "true" );
    document.getElementById( "result" ).value = "";

    ajax(
        "/api/magna-sqlr",
        "sql-run",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "result" ).value = j.payload;
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        }
    );
};

const getDataStreamStatus = ( itemID, operatorID ) => {
    ajax(
        "/api/datastream",
        "status",
        JSON.stringify( { id: itemID, operator: operatorID } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "status-" + itemID ).innerHTML = j.payload;
            document.getElementById( "topics-" + itemID ).innerHTML = j.topics;
        },
        ( error ) => {
            var j = JSON.parse( error );
            document.getElementById( "status-" + itemID ).innerHTML = j.message;
            document.getElementById( "topics-" + itemID ).innerHTML = j.topics;
        }
    );
};

const get_DataStreamPorts = ( itemID, ip ) => {
    if ( ip.trim() == "" ) {
        showError( "No IP visible, can not connect" );
        return;
    }
    ajax(
        "/api/datastream",
        "ports",
        JSON.stringify( { id: itemID } ),
        ( success ) => {
            var j = JSON.parse( success );
            showModal(
                "Data Stream Brokers",
                j.payload.replace( /{IP}/g, ip + ":" ),
                "",
                "Close",
                "",
                null,
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const calculate_SparkResources = () => {
    var worker =
        document.getElementById( "worker" ).options[
            document.getElementById( "worker" ).selectedIndex
        ].value;
    var workercpu =
        document.getElementById( "workercpu" ).options[
            document.getElementById( "workercpu" ).selectedIndex
        ].value;
    var workerram =
        document.getElementById( "workerram" ).options[
            document.getElementById( "workerram" ).selectedIndex
        ].value;

    var totalCPU = parseInt( worker ) * parseInt( workercpu );
    var totalRAM = parseInt( worker ) * parseInt( workerram );

    for ( i = 0; i < document.getElementById( "cpu" ).options.length; i++ ) {
        if (
            document.getElementById( "cpu" ).options[ i ].text ==
            totalCPU.toString()
        ) {
            document.getElementById( "cpu" ).options[ i ].selected = true;
        }
    }

    for ( i = 0; i < document.getElementById( "ram" ).options.length; i++ ) {
        if (
            document.getElementById( "ram" ).options[ i ].text ==
            totalRAM.toString()
        ) {
            document.getElementById( "ram" ).options[ i ].selected = true;
        }
    }
};

const join_MassiveSECluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-se",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-se",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_MassiveSECluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-se",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/magna-se",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const magnase_Json_Post = ( clusterID, operatorID ) => {
    if (
        document.getElementById( "path" ).value.indexOf( "<COLLECTION_NAME>" ) !=
        -1 ||
        document.getElementById( "path" ).value.indexOf( "<DOCUMENT_ID>" ) != -1 ||
        document.getElementById( "path" ).value.indexOf( "<OVERRIDE_NAME>" ) !=
        -1 ||
        document.getElementById( "path" ).value.indexOf( "<SEARCH_FOR>" ) != -1 ||
        document.getElementById( "path" ).value.indexOf( "<FIELD_NAME>" ) != -1 ||
        document.getElementById( "path" ).value.indexOf( "<SYNONYM_NAME>" ) != -1
    ) {
        showError( "please replace placeholder in path" );
        return;
    }

    var jData = {
        id: clusterID,
        operator: operatorID,
        data: window[ "editor" ].getValue(),
        method: document.getElementById( "method" ).options[
            document.getElementById( "method" ).selectedIndex
        ].value,
        path: document.getElementById( "path" ).value,
    };

    document.getElementById( "runButton" ).innerHTML =
        '<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>';
    document.getElementById( "runButton" ).setAttribute( "disabled", "true" );
    document.getElementById( "result" ).value = "";

    ajax(
        "/api/magna-se",
        "post",
        JSON.stringify( jData ),
        ( success ) => {
            var j = JSON.parse( success );
            var ret = "";
            try {
                ret = JSON.stringify( j.payload, null, 2 );
            } catch { }
            document.getElementById( "result" ).value = ret;
            document.getElementById( "runButton" ).innerHTML = "SUBMIT";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "runButton" ).innerHTML = "RUN";
            document.getElementById( "runButton" ).removeAttribute( "disabled" );
        }
    );
};

const open_MagnaSE = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-se",
        "sewin",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Close";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Magna-se Window",
                j.payload,
                okCaption,
                cancelCaption,
                "modal-fullscreen",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const setSampleMagnaSE = ( sender ) => {
    if ( sender.selectedIndex == 0 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/search?q=<SEARCH_FOR>&query_by=<FIELD_NAME>";
        window[ "editor" ].setValue( "", -1 );
    } else if ( sender.selectedIndex == 1 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value = "/collections";
        window[ "editor" ].setValue( "", -1 );
    } else if ( sender.selectedIndex == 2 ) {
        document.getElementById( "method" ).selectedIndex = 1;
        document.getElementById( "path" ).value = "/collections";
        window[ "editor" ].setValue(
            `{
    "name": "companies",
    "num_documents": 0,
    "fields": [
        {"name": "company_name", "type": "string" },
        {"name": "num_employees", "type": "int32" },
        {"name": "country", "type": "string", "facet": true }
    ],
    "default_sorting_field": "num_employees"
}`,
            -1
        );
    } else if ( sender.selectedIndex == 3 ) {
        document.getElementById( "method" ).selectedIndex = 2;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>";
        window[ "editor" ].setValue(
            `{
    "fields": [
        {"name": "num_employees", "drop": true },
        {"name": "company_category", "type": "string" }
    ]
}`,
            -1
        );
    } else if ( sender.selectedIndex == 4 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 5 ) {
        document.getElementById( "method" ).selectedIndex = 4;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 6 ) {
        document.getElementById( "method" ).selectedIndex = 1;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents";
        window[ "editor" ].setValue(
            `{
    "id": "124",
    "company_name": "Stark Industries",
    "num_employees": 5215,
    "country": "USA"
}`,
            -1
        );
    } else if ( sender.selectedIndex == 7 ) {
        document.getElementById( "method" ).selectedIndex = 1;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents?action=upsert";
        window[ "editor" ].setValue(
            `{
    "id": "124",
    "company_name": "Stark Industries",
    "num_employees": 5215,
    "country": "USA"
}`,
            -1
        );
    } else if ( sender.selectedIndex == 8 ) {
        document.getElementById( "method" ).selectedIndex = 1;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/import?action=create";
        window[ "editor" ].setValue(
            `{"id": "124", "company_name": "Stark Industries", "num_employees": 5215, "country": "US"}
{"id": "125", "company_name": "Future Technology", "num_employees": 1232, "country": "UK"}
{"id": "126", "company_name": "Random Corp.", "num_employees": 531, "country": "AU"}`,
            -1
        );
    } else if ( sender.selectedIndex == 9 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/<DOCUMENT_ID>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 10 ) {
        document.getElementById( "method" ).selectedIndex = 2;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/<DOCUMENT_ID>";
        window[ "editor" ].setValue(
            `{
    "company_name": "Stark Industries",
    "num_employees": 5500
}`,
            -1
        );
    } else if ( sender.selectedIndex == 11 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/export";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 12 ) {
        document.getElementById( "method" ).selectedIndex = 4;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/documents/<DOCUMENT_ID>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 13 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/overrides";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 14 ) {
        document.getElementById( "method" ).selectedIndex = 3;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/overrides/<OVERRIDE_NAME>";
        window[ "editor" ].setValue(
            `{
    "rule": {
        "query": "apple",
        "match": "exact"
    },
    "includes": [
        {"id": "422", "position": 1},
        {"id": "54", "position": 2}
    ],
    "excludes": [
        {"id": "287"}
    ]
}`,
            -1
        );
    } else if ( sender.selectedIndex == 15 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/overrides/<OVERRIDE_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 16 ) {
        document.getElementById( "method" ).selectedIndex = 4;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/overrides/<OVERRIDE_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 17 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value = "/aliases";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 18 ) {
        document.getElementById( "method" ).selectedIndex = 3;
        document.getElementById( "path" ).value = "/aliases/<COLLECTION_NAME>";
        window[ "editor" ].setValue(
            `{
    "collection_name": "companies_june11"
}`,
            -1
        );
    } else if ( sender.selectedIndex == 19 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value = "/aliases/<COLLECTION_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 20 ) {
        document.getElementById( "method" ).selectedIndex = 4;
        document.getElementById( "path" ).value = "/aliases/<COLLECTION_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 21 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/synonyms";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 22 ) {
        document.getElementById( "method" ).selectedIndex = 3;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/synonyms/<SYNONYM_NAME>";
        window[ "editor" ].setValue(
            `{
    "synonyms": ["blazer", "coat", "jacket"]
}`,
            -1
        );
    } else if ( sender.selectedIndex == 23 ) {
        document.getElementById( "method" ).selectedIndex = 0;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/synonyms/<SYNONYM_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    } else if ( sender.selectedIndex == 24 ) {
        document.getElementById( "method" ).selectedIndex = 4;
        document.getElementById( "path" ).value =
            "/collections/<COLLECTION_NAME>/synonyms/<SYNONYM_NAME>";
        window[ "editor" ].setValue( ``, -1 );
    }
    window[ "editor" ].getSession().setUndoManager( new ace.UndoManager() );
};

const mirror_ObjectStorage = ( itemID, itemName, cloudID ) => {
    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
    } );
    ajax( "/api/objectstorage", "mirror", data, ( dialog ) => {
        var j = JSON.parse( dialog );
        showModal(
            "Mirror Object Storage",
            j.payload,
            "Mirror",
            "Cancel",
            "",
            () => {
                if ( document.getElementById( "devices" ).selectedIndex == -1 ) {
                    showError( "No compatible devices found" );
                    return;
                }

                var folderCheck =
                    document.getElementById( "devices" ).options[
                        document.getElementById( "devices" ).selectedIndex
                    ].text;
                if ( folderCheck != "Disable Mirror" ) {
                    if (
                        folderCheck.indexOf(
                            "[" + document.getElementById( "name" ).value + "]"
                        ) == -1
                    ) {
                        showError(
                            "Destination folder name must be identical to the source name"
                        );
                        return;
                    }
                }

                var data = JSON.stringify( {
                    id: document.getElementById( "id" ).value,
                    operator: document.getElementById( "operator" ).value,
                    cloudnode: document.getElementById( "cloudid" ).value,
                    name: document.getElementById( "name" ).value,
                    deviceid:
                        document.getElementById( "devices" ).options[
                            document.getElementById( "devices" ).selectedIndex
                        ].value,
                } );

                document.getElementById( "okButton" ).innerHTML =
                    '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                document
                    .getElementById( "cancelButton" )
                    .setAttribute( "disabled", "yes" );
                document
                    .getElementById( "okButton" )
                    .setAttribute( "disabled", "yes" );

                ajax(
                    "/api/objectstorage",
                    "do-mirror",
                    data,
                    ( success ) => {
                        var j = JSON.parse( success );
                        showSuccess( j.payload );
                        list( document.getElementById( "nav-title" ), false );
                        document.getElementById( "quitButton" ).click();
                    },
                    ( error ) => {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            "Mirror";
                        var j = JSON.parse( error );
                        showError( j.message );
                    }
                );
            },
            () => {
                document.getElementById( "quitButton" ).click();
            }
        );
    } );
};

const join_SparkCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/dataspark-house",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/dataspark-house",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_SparkCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/dataspark-house",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/dataspark-house",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const setClusterPolicy = ( sender ) => {
    var pol = `{"Version": "2012-10-17",
"Statement": [{
    "Action": [
      "s3:ListBucket",
      "s3:PutObject",
      "s3:GetObject",
      "s3:DeleteObject"
    ],
    "Effect": "Allow",
      "Resource": [
        "arn:aws:s3:::{BUCKET}/*",
        "arn:aws:s3:::{BUCKET}"
    ]
}]}
`;
    var tmp = sender.options[ sender.selectedIndex ].text;
    if ( tmp.indexOf( "(" ) != -1 ) {
        tmp = tmp.substring( 0, tmp.indexOf( "(" ) ).trim();
    }
    document.getElementById( "policy" ).value = pol.replace(
        /{BUCKET}/g,
        tmp
    );
};

const join_MassiveSQLCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqld",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var test = document.getElementById(
                        "members-" + clusterID
                    ).innerText;
                    let m = test.split( "/" )[ 0 ];
                    let a = test.split( "/" )[ 1 ];
                    if ( parseInt( m ) != parseInt( a ) ) {
                        showError(
                            "please wait for all nodes to come online before you join a new member"
                        );
                        return;
                    }
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-sqld",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_MassiveSQLCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqld",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/magna-sqld",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const join_MassiveSQLRCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqlr",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-sqlr",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_MassiveSQLRCluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-sqlr",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/magna-sqlr",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const makeTable = ( json_objects_arr ) => {
    var table = document.createElement( "table" );
    table.className = "table tableNoWrap";
    var keys = getKeysFromArray( json_objects_arr );
    table.appendChild( makeTHEAD( keys ) );
    table.appendChild( makeTBODY( json_objects_arr, keys ) );
    return table;
};

const doChart = ( sender ) => {
    var charts = document.getElementById( 'log-charts' );
    if ( charts ) {
        document.getElementById( 'search' ).value = sender.innerText.trim();
        document.getElementById( 'searchButton' ).click();
    } else {
        showError( "can not chart this view" );
    }
};

const makeTHEAD = ( keys ) => {
    var thead = document.createElement( "thead" );
    var tr = document.createElement( "tr" );
    keys.forEach( function ( key ) {
        var th = document.createElement( "th" );
        if ( key == "direction" ) {
            key = "direction                                        ";
        }
        th.innerHTML = "<div class='trHEAD' title='Show in Chart' onclick='doChart(this);'>" + key + "</div>";
        th.className = "tableNoWrap";
        tr.appendChild( th );
    } );
    thead.appendChild( tr );
    return thead;
};

const makeTBODY = ( json_objects_arr, keys ) => {
    var tbody = document.createElement( "tbody" );
    json_objects_arr.forEach( function ( object ) {
        let tr = document.createElement( "tr" );
        keys.forEach( function ( key ) {
            var td = document.createElement( "td" );
            td.innerText = object[ key ];
            td.className = "tableNoWrap";
            if ( td.innerText.toLowerCase().indexOf( "error" ) != -1 || td.innerText.indexOf( '"ERR"' ) != -1 || td.innerText.indexOf( 'BLOCKED' ) != -1 || td.innerText.indexOf( 'SIEM' ) != -1 ) {
                td.className = "tderror";
            } else if ( td.innerText.toLowerCase().indexOf( "warning" ) != -1 || td.innerText.toLowerCase().indexOf( '"warn"' ) != -1 ) {
                td.className = "tdwarn";
            } else if ( td.innerText.toLowerCase().indexOf( "reqres" ) != -1 ) {
                //nothing
            } else if ( td.innerText.toLowerCase().indexOf( "req" ) != -1 ) {
                td.className = "tdin";
            } else if ( td.innerText.toLowerCase().indexOf( "res" ) != -1 ) {
                td.className = "tdout";
            }
            td.innerHTML = "<b style='cursor: pointer;' title='Copy to Clipboard' onclick='copyText(null, \"" + td.innerText + "\");'>📋</b>&nbsp;" + td.innerHTML;
            tr.appendChild( td );
        } );
        tbody.appendChild( tr );
    } );
    return tbody;
};

const getKeysFromArray = ( json_objects_arr ) => {
    var array_of_keys = [];
    json_objects_arr.forEach( function ( obj ) {
        Object.keys( obj ).forEach( function ( key ) {
            if ( !array_of_keys.includes( key ) ) {
                array_of_keys.push( key );
            }
        } );
    } );
    return array_of_keys.sort();
};

const jsonToTable = ( data ) => {
    function isNumeric ( str ) {
        if ( str != undefined ) {
            return !isNaN( str );
        } else {
            return false;
        }
    }
    var jData = JSON.parse( data );
    document.getElementById( "jsonTable" ).innerHTML = "";
    setTimeout( () => {
        try {
            document
                .getElementById( "jsonTable" )
                .appendChild( makeTable( jData ) );
            var charts = document.getElementById( 'log-charts' );
            if ( charts ) {
                if ( document.getElementById( 'search' ).value.trim() != "" ) {
                    var canShow = false;
                    jData.forEach( function ( item ) {
                        if ( item[ document.getElementById( 'search' ).value.trim() ] != undefined ) {
                            canShow = true;
                        }
                    } );
                    if ( canShow ) {
                        charts.width = 1200;
                        charts.height = 400;
                        document.getElementById( 'log-charts' ).style.display = "block";
                        document.getElementById( 'jsonTable' ).style.height = 'calc(100vh - 850px)';
                        document.getElementById( 'log-charts' ).style.height = "400px";
                        document.getElementById( 'log-charts' ).style.width = "100%";

                        var dTime = [];
                        var dData = [];
                        var isNum = null;
                        jData.forEach( function ( item ) {
                            if ( item[ document.getElementById( 'search' ).value.trim() ] != undefined ) {
                                dData.push( item[ document.getElementById( 'search' ).value.trim() ] );
                                if ( isNum == null ) {
                                    isNum = isNumeric( item[ document.getElementById( 'search' ).value.trim() ] );
                                }
                            }
                        } );
                        jData.forEach( function ( item ) {
                            if ( item[ 'time' ] != undefined ) {
                                dTime.push( item[ 'time' ] );
                            }
                        } );

                        if ( !isNum ) {
                            const minuteCounts = {};
                            dTime.forEach( ( ts, i ) => {
                                const minute = new Date( ts ).toISOString().substring( 0, 16 ); // "YYYY-MM-DDTHH:MM"
                                if ( !minuteCounts[ minute ] ) {
                                    minuteCounts[ minute ] = 0;
                                }
                                minuteCounts[ minute ] += 1;
                            } );
                            const minutes = Object.keys( minuteCounts ).sort();
                            const counts = minutes.map( min => minuteCounts[ min ] );
                            dTime = minutes;
                            dData = counts;
                        }

                        //console.log( dTime );
                        //console.log( dData );

                        const chartData = {
                            labels: dTime,
                            datasets: [
                                {
                                    borderColor: "blue",
                                    label: document.getElementById( 'search' ).value.trim(),
                                    data: dData,
                                    borderWidth: 1,
                                }
                            ],
                        };
                        try {
                            _CHART_.destroy();
                            delete _CHART_;
                        } catch { }
                        _CHART_ = new Chart( charts.getContext( '2d' ), {
                            type: "line",
                            data: chartData,
                            options: {
                                elements: { point: { radius: 1, hoverRadius: 2 } },
                                plugins: {
                                    legend: {
                                        display: false,
                                        labels: { font: { size: 13 } },
                                    },
                                },
                                scales: {
                                    x: { ticks: { font: { size: 11 } } },
                                    y: { ticks: { font: { size: 11 } } },
                                },
                            },
                        } );
                        _CHART_.width = 1200;
                        _CHART_.height = 400;
                    } else {
                        try {
                            _CHART_.destroy();
                            delete _CHART_;
                        } catch { }
                        document.getElementById( 'log-charts' ).style.display = "none";
                        document.getElementById( 'jsonTable' ).style.height = 'calc(100vh - 302px)';
                        document.getElementById( 'log-charts' ).style.height = "400px";
                        document.getElementById( 'log-charts' ).style.width = "100%";
                    }
                } else {
                    try {
                        _CHART_.destroy();
                        delete _CHART_;
                    } catch { }
                    document.getElementById( 'log-charts' ).style.display = "none";
                    document.getElementById( 'jsonTable' ).style.height = 'calc(100vh - 302px)';
                    document.getElementById( 'log-charts' ).style.height = "400px";
                    document.getElementById( 'log-charts' ).style.width = "100%";
                }
            }
        } catch ( err ) {
            //console.log( err );
            showError( "Somthing went wrong ..." );
            try {
                document.getElementById( "monitorButton" ).innerHTML = "Load";
                document.getElementById( "monitorButton" ).removeAttribute( "disabled" );
            } catch { }
            document.getElementById( "jsonTable" ).style.display = "block";
        }
    }, 250 );
};

const publishToStacks = ( itemID, itemName, api ) => {
    var sapi = api.toLowerCase().replace( / /g, "" );
    if ( sapi.indexOf( "start" ) != -1 ) {
        sapi = getSAPIfromID( id );
    }

    var tmp = document.getElementById( "status-" + itemID ).innerText;
    if ( tmp.trim().indexOf( "AC " ) == -1 ) {
        showError( "Please deploy your function first" );
        return;
    }

    showModal(
        "Publish to Stacks",
        "You are about to publish [" +
        itemName +
        "] to the Solution Stacks Registry, continue?",
        "Publish",
        "Cancel",
        "",
        () => {
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
            ajax(
                "/api/" + sapi,
                "publish",
                JSON.stringify( { id: itemID, name: itemName } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "quitButton" ).click();
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        () => {
            //cancel
            document.getElementById( "quitButton" ).click();
        }
    );
};

const purge_EventHub = ( itemID, itemName, cloudID ) => {
    var delMessage = `<b>You are about to perform an <span style="color: red;">ireversable purge operation</span> which will delete all messages in the event queue.</b><br><br>Do you want to continue?`;

    showModal(
        "Purge Events",
        delMessage,
        "Purge",
        "Cancel",
        "",
        () => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );

            var data = JSON.stringify( {
                id: itemID,
                cloudnode: cloudID,
                name: itemName,
            } );
            ajax(
                "/api/eventhub",
                "purge",
                data,
                ( success ) => {
                    var j = JSON.parse( success );
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        showSuccess( j.payload );
                    }, 500 );
                    setTimeout( () => {
                        list( document.getElementById( "nav-title" ), false );
                    }, 1500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    document.getElementById( "quitButton" ).click();
                    setTimeout( () => {
                        showError( j.message );
                    }, 500 );
                }
            );
        },
        () => {
            //cancel
            document.getElementById( "quitButton" ).click();
        }
    );
};

const sendReceive_EventHub = ( itemID, itemName, cloudID ) => {
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
    } );
    ajax(
        "/api/eventhub",
        "edit",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showModal(
                "Send/Receive Messages",
                j.payload,
                "",
                "Close",
                "modal-lg",
                () => { },
                () => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        () => {
            showError( "Something went wrong, please try again" );
        }
    );
};

const sendmessage_EventHub = () => {
    var itemID = document.getElementById( "id" ).value;
    var itemName = document.getElementById( "name" ).value;
    var cloudID = document.getElementById( "cloudnode" ).value;
    var messageData = document.getElementById( "sendmessage" ).value;

    if ( messageData.trim() == "" ) {
        showError( "Please enter message/data" );
        return;
    }

    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
        postdata: messageData,
    } );

    ajax(
        "/api/eventhub",
        "send",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const receive_EventHub = ( ack ) => {
    var itemID = document.getElementById( "id" ).value;
    var itemName = document.getElementById( "name" ).value;
    var cloudID = document.getElementById( "cloudnode" ).value;
    var data = JSON.stringify( {
        id: itemID,
        cloudnode: cloudID,
        name: itemName,
        delete: ack,
    } );

    ajax(
        "/api/eventhub",
        "receive",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "receivemessage" ).value = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getLogStreams = ( sender ) => {
    unselectCodeFiles();
    document.getElementById( "stream" ).innerHTML = "";
    document.getElementById( "spinner" ).style.display = "none";
    document.getElementById( "frontpanel" ).style.display = "none";
    document.getElementById( "jsonTable" ).innerHTML = "";
    document.getElementById( "collection" ).value = "";
    ajax(
        "/api/logwatch",
        "get-streams",
        JSON.stringify( { item: sender.id } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "ul-" + sender.id ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
    event.stopPropagation();
};

const getLogFor = ( sender ) => {
    document.getElementById( "spinner" ).style.display = "";
    var data = JSON.stringify( {
        type: sender.getAttribute( "type" ),
        api: sender.getAttribute( "api" ),
        id: sender.id,
        cloudnode: sender.getAttribute( "cloudnode" ),
    } );
    ajax(
        "/api/logwatch",
        "get-stream-list",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "stream" ).innerHTML = j.payload;
            unselectCodeFiles();
            sender.classList.add( "fileselected" );
            document.getElementById( "frontpanel" ).style.display = "none";
            document.getElementById( "jsonTable" ).innerHTML = "";
            document.getElementById( "spinner" ).style.display = "none";
            document.getElementById( "collection" ).value =
                sender.getAttribute( "type" ) + "/" + sender.getAttribute( "api" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "collection" ).value = "";
        }
    );
    event.stopPropagation();
};

const getSystemStreams = ( sender ) => {
    document.getElementById( "collection" ).value = "";
    unselectCodeFiles();
    document.getElementById( "spinner" ).style.display = "none";
    document.getElementById( "frontpanel" ).style.display = "";
    ajax(
        "/api/systemwatch",
        "get-streams",
        JSON.stringify( { item: sender.id } ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "ul-" + sender.id ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
    event.stopPropagation();
};

const getMetricsFor = ( sender ) => {
    var tmpSelected = null;
    if ( sender.id == "days" ) {
        var firstDay =
            document.getElementById( "days" ).options[
                document.getElementById( "days" ).selectedIndex
            ].value;
        var data = JSON.stringify( {
            file: getSelectedCodeFile().getAttribute( "file" ),
            cloudnode: getSelectedCodeFile().id,
            firstday: firstDay,
        } );
        tmpSelected = getSelectedCodeFile();
    } else {
        var firstDay = "";
        if ( document.getElementById( "days" ).selectedIndex != -1 ) {
            if ( document.getElementById( "days" ).selectedIndex != 0 ) {
                firstDay =
                    document.getElementById( "days" ).options[
                        document.getElementById( "days" ).selectedIndex
                    ].value;
            }
        }
        var data = JSON.stringify( {
            file: sender.getAttribute( "file" ),
            cloudnode: sender.id,
            firstday: firstDay,
        } );
    }

    document.getElementById( "spinner" ).style.display = "";

    ajax(
        "/api/systemwatch",
        "get-metrics",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "days" ).innerHTML = j.payload;
            document.getElementById( "collection" ).value = j.collection;
            unselectCodeFiles();
            if ( tmpSelected != null ) {
                tmpSelected.classList.add( "fileselected" );
            } else {
                sender.classList.add( "fileselected" );
            }
            document.getElementById( "frontpanel" ).style.display = "none";
            document.getElementById( "spinner" ).style.display = "none";

            const ctx = document.getElementById( "monitor-chart" );
            const chartData = {
                labels: [],
                datasets: [
                    {
                        borderColor: "#00bb00",
                        label: "%",
                        data: [],
                        borderWidth: 1,
                    },
                    {
                        borderColor: "#dd0000",
                        label: "%",
                        data: [],
                        borderWidth: 1,
                    },
                    {
                        borderColor: "#0000dd",
                        label: "%",
                        data: [],
                        borderWidth: 1,
                    },
                ],
            };
            chartData.labels = j.labels;
            chartData.datasets[ 0 ].label = j.cpulabel;
            chartData.datasets[ 0 ].data = j.cpus;
            chartData.datasets[ 1 ].label = j.ramlabel;
            chartData.datasets[ 1 ].data = j.mems;
            chartData.datasets[ 2 ].label = j.disklabel;
            chartData.datasets[ 2 ].data = j.disks;
            try {
                _CHART_.destroy();
                delete _CHART_;
            } catch { }
            _CHART_ = new Chart( ctx, {
                type: "line",
                data: chartData,
                options: {
                    elements: { point: { radius: 1, hoverRadius: 2 } },
                    plugins: { legend: { labels: { font: { size: 15 } } } },
                    scales: {
                        x: { ticks: { font: { size: 11 } } },
                        y: { ticks: { font: { size: 13 } } },
                    },
                },
            } );
            if ( firstDay != "" ) {
                for (
                    i = 0;
                    i < document.getElementById( "days" ).options.length;
                    i++
                ) {
                    if (
                        document.getElementById( "days" ).options[ i ].value ==
                        firstDay
                    ) {
                        document.getElementById( "days" ).options[
                            i
                        ].selected = true;
                        break;
                    }
                }
            }
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
    event.stopPropagation();
};

const join_MassiveS3Cluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-s3",
        "join",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/magna-s3",
                        "member-join",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_MassiveS3Cluster = ( clusterID, operatorID ) => {
    ajax(
        "/api/magna-s3",
        "leave",
        JSON.stringify( { id: clusterID, operator: operatorID } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }

                    document.getElementById( "tmph" ).style.height = "70px";
                    document.getElementById( "decom" ).style.display = "block";

                    ajax(
                        "/api/magna-s3",
                        "member-leave",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "tmph" ).style.height =
                                "auto";
                            document.getElementById( "decom" ).style.display =
                                "none";
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const loadMagnaS3Files = ( itemID, itemName, cloudID ) => {
    document.getElementById(
        "s3list"
    ).innerHTML = `<center><div style="margin-top: 50px;" id="spinner" class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span></div><br>LOADING</center>`;

    document.getElementById( "selectall" ).checked = false;

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        path: document.getElementById( "path" ).value,
        magnas3: cloudID,
        showversions: document.getElementById( "showversions" ).checked,
        search: document.getElementById( "searchfor" ).value,
    } );

    document.getElementById( "searchButton" ).innerHTML =
        "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
    document.getElementById( "searchButton" ).setAttribute( "disabled", "true" );

    ajax(
        "/api/magna-buckets",
        "list-bucket",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.payload == "" ) {
                document.getElementById( "s3list" ).innerHTML =
                    "<center><br><br>this bucket is empty</center>";
            } else {
                document.getElementById( "s3list" ).innerHTML = j.payload;
            }
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            document.getElementById( "s3list" ).innerHTML =
                "<center><br><br><span style='color: red;'>" +
                j.message +
                "</span></center>";
            document.getElementById( "searchButton" ).innerHTML = "Load";
            document.getElementById( "searchButton" ).removeAttribute( "disabled" );
        }
    );
};

const newMagnaS3Folder = ( itemID, itemName, cloudID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "superform-text" ).innerHTML = `
        <input autocomplete="some_off_string_workaround" spellcheck="false" type="text" class="form-control rounded-0" id="newfilename" pattern="[a-zA-Z0-9]+" placeholder="Name (no spaces)" />
    `;
    document.getElementById( "superform-modal" ).style.top = "0px";
    document.getElementById( "newfilename" ).value =
        document.getElementById( "path" ).value + "/";
    setTimeout( () => {
        document.getElementById( "newfilename" ).focus();
    }, 500 );
    document.getElementById( "sfOKButton" ).onclick = ( e ) => {
        var newFilename = document.getElementById( "newfilename" ).value;
        if (
            newFilename.indexOf( "." ) != -1 ||
            newFilename.indexOf( "," ) != -1 ||
            newFilename.indexOf( ":" ) != -1 ||
            newFilename.indexOf( "!" ) != -1 ||
            newFilename.indexOf( "#" ) != -1 ||
            newFilename.indexOf( "@" ) != -1 ||
            newFilename.indexOf( "%" ) != -1 ||
            newFilename.indexOf( "&" ) != -1 ||
            newFilename.indexOf( "^" ) != -1 ||
            newFilename.indexOf( "*" ) != -1 ||
            newFilename.indexOf( "(" ) != -1 ||
            newFilename.indexOf( ")" ) != -1 ||
            newFilename.indexOf( "[" ) != -1 ||
            newFilename.indexOf( "]" ) != -1 ||
            newFilename.indexOf( "=" ) != -1 ||
            newFilename.indexOf( "+" ) != -1 ||
            newFilename.indexOf( "-" ) != -1 ||
            newFilename.indexOf( "{" ) != -1 ||
            newFilename.indexOf( "}" ) != -1 ||
            newFilename.indexOf( "<" ) != -1 ||
            newFilename.indexOf( ">" ) != -1 ||
            newFilename.indexOf( ";" ) != -1 ||
            newFilename.indexOf( "?" ) != -1
        ) {
            showError( "Folder names can not contain punctuations" );
            return;
        }
        if ( newFilename.trim() != "" ) {
            document.getElementById( "superform-modal" ).style.top = "-180px";
            document.getElementById( "super-modal-back" ).style.display = "none";
            showInfo( "Command was issued, please wait" );
            var data = {
                path: newFilename,
                id: itemID,
                name: itemName,
                magnas3: cloudID,
            };
            ajax(
                "/api/magna-buckets",
                "new-folder",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "searchButton" ).click();
                    document.getElementById( "superform-modal" ).style.top =
                        "-180px";
                    document.getElementById( "super-modal-back" ).style.display =
                        "none";
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        } else {
            showError( "Please enter a folder name" );
        }
    };
    document.getElementById( "sfNOButton" ).onclick = ( e ) => {
        document.getElementById( "superform-modal" ).style.top = "-180px";
        document.getElementById( "super-modal-back" ).style.display = "none";
    };
};

const openMagnaS3Folder = ( itemID, itemName, cloudID, item ) => {
    var path = document.getElementById( "path" ).value;
    if ( item != "" ) {
        path = path + "/" + item.replace( "/", "" );
        document.getElementById( "path" ).value = path;
        loadMagnaS3Files( itemID, itemName, cloudID );
    } else {
        var tmp = "";
        if ( path != itemName ) {
            for ( i = 0; i < path.split( "/" ).length - 1; i++ ) {
                if ( tmp == "" ) {
                    tmp = path.split( "/" )[ i ];
                } else {
                    tmp = tmp + "/" + path.split( "/" )[ i ];
                }
            }
        }
        document.getElementById( "path" ).value = tmp;
        loadMagnaS3Files( itemID, itemName, cloudID );
    }
};

const downloadMagnaS3File = ( itemID, itemName, cloudID, item ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about to download the file [" + item + "], continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        showInfo( "Command issued, please wait" );
        ajax(
            "/api/magna-buckets",
            "download-file",
            JSON.stringify( {
                filename: item,
                id: itemID,
                name: itemName,
                path: document.getElementById( "path" ).value,
                magnas3: cloudID,
            } ),
            ( success ) => {
                var j = JSON.parse( success );
                window.open( j.payload );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const deleteMagnaS3File = ( itemID, itemName, cloudID, item ) => {
    var checks = document.getElementsByClassName( "form-check-input" );
    var files = [];
    for ( i = 0; i < checks.length; i++ ) {
        if ( checks[ i ].id != "showversions" && checks[ i ].id != "selectall" ) {
            if ( checks[ i ].checked ) {
                files.push( { name: checks[ i ].id } );
            }
        }
    }

    var data = JSON.stringify( {
        id: itemID,
        name: itemName,
        magnas3: cloudID,
        path: document.getElementById( "path" ).value,
        items: files,
    } );

    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about delete files/folders, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        showInfo( "Command issued, please wait" );
        document.getElementById( "deleteButton" ).innerHTML =
            "<sp id='spinner' class='spinner-border' role='status' style='width: 16px; height: 16px;'></sp>";
        document
            .getElementById( "deleteButton" )
            .setAttribute( "disabled", "true" );
        ajax(
            "/api/magna-buckets",
            "delete-file",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
                document.getElementById( "searchButton" ).click();
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
                document.getElementById( "deleteButton" ).innerText = "Delete";
                document
                    .getElementById( "deleteButton" )
                    .removeAttribute( "disabled" );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const selectAction_EventHub = ( itemID, itemName, cloudID ) => {
    var data = {
        id: itemID,
        name: itemName,
        cloudnode: cloudID,
    };
    ajax(
        "/api/eventhub",
        "gates",
        JSON.stringify( data ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Action Gates",
                j.payload,
                "Save",
                "Cancel",
                "",
                () => {
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData();
                    ajax(
                        "/api/eventhub",
                        "save-gates",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            list( document.getElementById( "nav-title" ), false );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Save";
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const populate_From_Repository = ( itemID, cloudID ) => {
    var data = {
        id: itemID,
        cloudnode: cloudID,
    };
    ajax(
        "/api/repositories",
        "populate",
        JSON.stringify( data ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Populate from Repository",
                j.payload,
                "Fork",
                "Cancel",
                "",
                () => {
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }

                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData();
                    ajax(
                        "/api/repositories",
                        "do-populate",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                            list( document.getElementById( "nav-title" ), false );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Fork";
                            document.getElementById( "quitButton" ).click();
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Fork";
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getApiCommands = ( sender ) => {
    var data = {
        api: sender.options[ sender.selectedIndex ].value,
    };
    ajax(
        "/api/flow-fx",
        "api-commands",
        JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "servicesList" ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const exec_flowfx = () => {
    document.getElementById( "designer" ).value = btoa(
        JSON.stringify( window[ "flow" ].export() )
    );
    var data = JSON.stringify( {
        name: document.getElementById( "name" ).value,
        comments: document.getElementById( "comments" ).value,
        id: document.getElementById( "fid" ).value,
        operator: document.getElementById( "operator" ).value,
        designer: document.getElementById( "designer" ).value,
        loglevel:
            document.getElementById( "loglevel" ).options[
                document.getElementById( "loglevel" ).selectedIndex
            ].value,
    } );

    for ( var i = 0; i < 1000; i++ ) {
        try {
            document.getElementById( "node-" + i ).style.outline = "none";
        } catch { }
    }

    try {
        document.getElementById( "execButton" ).innerHTML =
            '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
        document.getElementById( "execButton" ).setAttribute( "disabled", true );
    } catch { }
    try {
        document.getElementById( "runButton" ).innerHTML =
            '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
        document.getElementById( "runButton" ).setAttribute( "disabled", true );
    } catch { }
    setTimeout( () => {
        getFlowChart( document.getElementById( "fid" ).value );
        getFlowRuns( document.getElementById( "fid" ).value );
    }, 250 );
    ajax(
        "/api/flow-fx",
        "exec",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
            try {
                j.done.split( "," ).forEach( function ( item ) {
                    if ( item.trim() != "" ) {
                        try {
                            document.getElementById(
                                "node-" + item
                            ).style.outline = "solid 5px lime";
                        } catch { }
                    }
                } );
                document.getElementById( "node-" + j.lastitem ).style.outline =
                    "solid 5px lime";
            } catch { }
            try {
                document.getElementById( "execButton" ).innerHTML = "Invoke Start";
                document.getElementById( "execButton" ).removeAttribute( "disabled" );
            } catch { }
            try {
                document.getElementById( "runButton" ).innerHTML = "Run";
                document.getElementById( "runButton" ).removeAttribute( "disabled" );
            } catch { }
            getFlowChart( document.getElementById( "fid" ).value );
            getFlowRuns( document.getElementById( "fid" ).value );
            document.getElementById( "findruns" ).value = j.logtime;
            setTimeout( () => {
                doSearchRuns();
            }, 1000 );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message + "\n" + j.retdata );
            try {
                j.done.split( "," ).forEach( function ( item ) {
                    if ( item.trim() != "" ) {
                        try {
                            document.getElementById( "node-" + item ).style.outline =
                                "solid 5px lime";
                        } catch { }
                    }
                } );
            } catch { }
            try {
                document.getElementById( "node-" + j.lastitem ).style.outline = "solid 5px red";
            } catch { }
            try {
                document.getElementById( "execButton" ).innerHTML = "Invoke Start";
                document.getElementById( "execButton" ).removeAttribute( "disabled" );
            } catch { }
            try {
                document.getElementById( "runButton" ).innerHTML = "Run";
                document.getElementById( "runButton" ).removeAttribute( "disabled" );
            } catch { }
            getFlowChart( document.getElementById( "fid" ).value );
            getFlowRuns( document.getElementById( "fid" ).value );
            document.getElementById( "findruns" ).value = j.logtime;
            setTimeout( () => {
                doSearchRuns();
            }, 1000 );
        }
    );
};

const exec_flowfxByID = ( itemID ) => {
    var data = JSON.stringify( {
        id: itemID,
    } );

    showModal( "Flow Run", "You are about to run this Flow-fx, continue?", "Run", "Cancel", "",
        () => {
            ajax(
                "/api/flow-fx",
                "exec-id",
                data,
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    setTimeout( () => {
                        try {
                            var running = document.getElementById( itemID + '-running' ).innerText.trim();
                            var success = document.getElementById( itemID + '-success' ).innerText.trim();
                            document.getElementById( itemID + '-running' ).innerText = parseInt( running ) - 1;
                            document.getElementById( itemID + '-success' ).innerText = parseInt( success ) + 1;
                        } catch { }
                    }, 500 );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    if ( j.retdata != undefined ) {
                        showError( j.message + "\n" + j.retdata );
                    } else {
                        showError( j.message );
                    }
                    setTimeout( () => {
                        try {
                            var running = document.getElementById( itemID + '-running' ).innerText.trim();
                            var failed = document.getElementById( itemID + '-failed' ).innerText.trim();
                            document.getElementById( itemID + '-running' ).innerText = parseInt( running ) - 1;
                            document.getElementById( itemID + '-failed' ).innerText = parseInt( failed ) + 1;
                        } catch { }
                    }, 500 );
                    document.getElementById( "quitButton" ).click();
                }
            );
            try {
                var running = document.getElementById( itemID + '-running' ).innerText.trim();
                var total = document.getElementById( itemID + '-total' ).innerText.trim();
                document.getElementById( itemID + '-running' ).innerText = parseInt( running ) + 1;
                document.getElementById( itemID + '-total' ).innerText = parseInt( total ) + 1;
            } catch { }
            document.getElementById( "quitButton" ).click();
        },
        () => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const export_flowfx = () => {
    document.getElementById( "designer" ).value = btoa(
        JSON.stringify( window[ "flow" ].export() )
    );
    var data = JSON.stringify( {
        name: document.getElementById( "name" ).value,
        comments: document.getElementById( "comments" ).value,
        id: document.getElementById( "fid" ).value,
        operator: document.getElementById( "operator" ).value,
        designer: document.getElementById( "designer" ).value,
        loglevel:
            document.getElementById( "loglevel" ).options[
                document.getElementById( "loglevel" ).selectedIndex
            ].value,
    } );

    ajax(
        "/api/flow-fx",
        "export",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "impex" ).value = j.payload;
            document.getElementById( "impex-title" ).innerHTML = "Export Flow-fx";
            document.getElementById( "impex-button" ).innerHTML =
                "Copy and Close";
            document.getElementById( "impex-button" ).onclick = () => {
                copyText( null, document.getElementById( "impex" ).value );
                document.getElementById( "impex-container" ).style.display =
                    "none";
            };
            document.getElementById( "impex-container" ).style.display = "block";
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const import_flowfx = () => {
    document.getElementById( "impex" ).value = "";
    document.getElementById( "impex-title" ).innerHTML = "Import Flow-fx";
    document.getElementById( "impex-button" ).innerHTML = "Import and Close";
    document.getElementById( "impex-button" ).onclick = () => {
        if ( document.getElementById( "impex" ).value.trim() == "" ) {
            showError( "Please paste Flox-fx yaml code" );
            return;
        }

        var data = JSON.stringify( {
            yaml: btoa( document.getElementById( "impex" ).value ),
            id: document.getElementById( "fid" ).value
        } );

        ajax(
            "/api/flow-fx",
            "import",
            data,
            ( success ) => {
                var j = JSON.parse( success );
                document.getElementById( "designer" ).value = j.payload;
                var flow = JSON.parse(
                    atob( document.getElementById( "designer" ).value )
                );
                window[ "flow" ].import( flow );
                document.getElementById( "impex-container" ).style.display =
                    "none";
                window[ "flowchanged" ] = true;
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
    };
    document.getElementById( "impex-container" ).style.display = "block";
};

const getFlowCounters = ( itemID ) => {
    var data = { id: itemID };
    ajax(
        "/api/flow-fx",
        "counter",
        JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( itemID + "-running" ).innerHTML = j.running;
            document.getElementById( itemID + "-success" ).innerHTML = j.success;
            document.getElementById( itemID + "-failed" ).innerHTML = j.failed;
            document.getElementById( itemID + "-total" ).innerHTML = j.total;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getFlowChart = ( itemID ) => {
    var data = { id: itemID };
    ajax(
        "/api/flow-fx",
        "counter",
        JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            const ctx = document.getElementById( "flow-chart" );
            const chartData = {
                labels: [ "" ],
                datasets: [
                    {
                        borderColor: "#000000",
                        label: "Total",
                        data: [ j.total ],
                        borderWidth: 2,
                    },
                    {
                        borderColor: "#00dd00",
                        label: "Success",
                        data: [ j.success ],
                        borderWidth: 2,
                    },
                    {
                        borderColor: "#dd0000",
                        label: "Fail",
                        data: [ j.failed ],
                        borderWidth: 2,
                    },
                    {
                        borderColor: "#0000ff",
                        label: "Running",
                        data: [ j.running ],
                        borderWidth: 2,
                    },
                ],
            };
            try {
                _CHART_.destroy();
                delete _CHART_;
            } catch { }
            _CHART_ = new Chart( ctx, {
                type: "bar",
                data: chartData,
                options: {
                    elements: { point: { radius: 1, hoverRadius: 2 } },
                    plugins: {
                        legend: {
                            display: false,
                            labels: { font: { size: 13 } },
                        },
                    },
                    scales: {
                        x: { ticks: { font: { size: 11 } } },
                        y: { ticks: { font: { size: 11 } } },
                    },
                },
            } );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const getFlowRuns = ( itemID ) => {
    var data = { id: itemID };
    document.getElementById( "runlogs" ).innerHTML = "";
    ajax(
        "/api/flow-fx",
        "runs",
        JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "runs" ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const selectRunlog = ( sender ) => {
    var list = document.getElementsByClassName( "runs" );
    for ( i = 0; i < list.length; i++ ) {
        list[ i ].classList.remove( "runselected" );
    }

    var data = JSON.stringify( { id: sender.id } );
    ajax(
        "/api/flow-fx",
        "logs",
        data,
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( "runlogs" ).innerHTML =
                `<div class="btn btn-primary rounded-0" style="position: absolute; right: 5px; top: 53px;" onclick="copyText(document.getElementById('c01'));">Copy Logs</div>` +
                "<pre id='c01'>" +
                JSON.stringify( j.payload, null, 4 ) +
                "</pre";
            sender.classList.add( "runselected" );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const clearRunLogs = ( itemID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText =
        "You are about clear the logs, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( e ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }
        var data = { id: itemID };
        ajax(
            "/api/flow-fx",
            "clearlogs",
            JSON.stringify( data ),
            ( success ) => {
                var j = JSON.parse( success );
                showSuccess( j.payload );
                document.getElementById( "runlogs" ).innerHTML = "";
                document.getElementById( "runs" ).innerHTML = "";
                setTimeout( () => {
                    getFlowChart( document.getElementById( "fid" ).value );
                    getFlowRuns( document.getElementById( "fid" ).value );
                    document.getElementById( "findruns" ).value = "";
                    setTimeout( () => {
                        doSearchRuns();
                    }, 1000 );
                }, 500 );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const clearRunLogs2 = ( itemID ) => {
    showModal(
        "Clear Run Logs",
        "You are about to clear all run logs, continue?",
        "Clear",
        "Cancel",
        "",
        () => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            document.getElementById( "okButton" ).innerHTML =
                '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
            document
                .getElementById( "cancelButton" )
                .setAttribute( "disabled", "yes" );
            document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
            var data = { id: itemID };
            ajax(
                "/api/flow-fx",
                "clearlogs",
                JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "quitButton" ).click();
                    list( document.getElementById( "nav-title" ), false );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        () => {
            //cancel
            document.getElementById( "quitButton" ).click();
        }
    );
};

const openFlowDocs = ( id ) => {
    ajax( "/api/flow-fx", "flow-help", JSON.stringify( { api: id } ),
        ( success ) => {
            document.getElementById( 'flowhelp' ).classList.remove( 'hide' );
            var j = JSON.parse( success );
            document.getElementById( 'flowhelp-title' ).innerHTML = "<b>" + id + "</b>";
            var smallDoc = "";
            j.payload.split( "\n" ).every( function ( line ) {
                if ( line.indexOf( "Code Snippets" ) != -1 ) {
                    return false;
                }
                smallDoc = smallDoc + line;
                if ( line.indexOf( "Indicates a mandatory field" ) != -1 ) {
                    return false;
                }
                return true;
            } );
            var start = false;
            j.payload.split( "\n" ).forEach( function ( line ) {
                if ( line.indexOf( "Successful Response" ) != -1 ) {
                    start = true;
                    smallDoc = smallDoc + "<hr>";
                }
                if ( start ) {
                    smallDoc = smallDoc + line;
                }
            } );
            smallDoc = smallDoc.replace( "<hr />", "" );
            if ( smallDoc.indexOf( "Indicates a mandatory field" ) == -1 ) {
                smallDoc = smallDoc.replace( "<hr />", "" );
            }
            document.getElementById( 'flowhelp-content' ).innerHTML = smallDoc;
            document.getElementById( 'flowhelp' ).style.zIndex = '101';
            document.getElementById( 'flowhelp' ).classList.add( 'show' );
            document.getElementById( 'flowhelp-content' ).scrollTo( { top: 0, behavior: 'smooth' } );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const openFlowEditor = ( sender, syntax = "javascript" ) => {
    const editor = ace.edit( "editor" );
    var theme = "iplastic";
    if ( window.matchMedia && window.matchMedia( '(prefers-color-scheme: dark)' ).matches ) {
        theme = 'solarized_dark';
    }
    editor.setTheme( "ace/theme/" + theme );

    editor.session.setMode( "ace/mode/" + syntax );
    editor.session.setValue( sender.value, -1 );
    editor.setOptions( {
        fontFamily: "monospace",
        fontSize: "16px"
    } );
    document.getElementById( 'floweditor' ).classList.remove( 'hide' );
    document.getElementById( 'floweditor' ).style.zIndex = '101';
    document.getElementById( 'floweditor' ).classList.add( 'show' );
    editor.focus();
    window[ "editor" ] = editor;
    window[ "flowsender" ] = sender;
};

const pin_InstanceConsole = ( id, type, name, apiname ) => {
    ajax( "/api/start", "pin", JSON.stringify( { "id": id, "type": type, "name": name, "apiname": apiname } ),
        ( success ) => {
            var j = JSON.parse( success );
            showSuccess( j.payload );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const launch_Pin = ( sender ) => {
    //open_InstanceConsole = ( cloudid, apiname, ip, instanceID )
    var apiname = sender.getAttribute( "apiname" );
    var instance = sender.getAttribute( "target" );
    var type = sender.getAttribute( "type" );
    sender.setAttribute( "disabled", "yes" );
    ajax( "/api/start", "open", JSON.stringify( { "id": instance } ),
        ( success ) => {
            var j = JSON.parse( success );
            if ( type == "pin-terminal" || type == "pin-xvmconsole" ) {
                open_InstanceConsole( j.cloudnode, apiname, j.ip, instance );
            } else if ( type == "pin-console" ) {
                open_InstanceConsoleRdp( j.cloudnode, apiname, j.ip, instance );
            } else if ( type == "pin-browser" ) {
                open_InstanceConsoleVnc( j.cloudnode, apiname, j.ip, instance );
            } else if ( type == "pin-flow" ) {
                exec_flowfxByID( instance );
            } else if ( type == "pin-cloudterminal" ) {
                open_CloudConsole( instance );
            } else if ( type == "pin-chat" ) {
                start_IngeniaChat( instance );
            }
            setTimeout( () => {
                sender.removeAttribute( "disabled" );
            }, 2500 );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            sender.removeAttribute( "disabled" );
        }
    );
};

const remove_Pin = ( target, pintype ) => {
    showModal( "Remove Start Pin", "You are about to remove a Start Pin, continue?", "Yes", "No", "",
        ( ok ) => {
            ajax( "/api/start", "rmpin", JSON.stringify( { id: target, type: pintype } ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    list( document.getElementById( "nav-title" ), false );
                    document.getElementById( 'quitButton' ).click();
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        },
        ( no ) => {
            document.getElementById( 'quitButton' ).click();
        }
    );
};

const showUpdates = async () => {

    window.open( "{MASTER}updates" );

};

const populate_SIEM_Instances = () => {
    var data = {
        type: document.getElementById( 'sourcetype' ).options[ document.getElementById( 'sourcetype' ).selectedIndex ].value
    };
    ajax( "/api/siemcollector", "list-sources", JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            document.getElementById( 'source' ).innerHTML = j.payload;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const open_Observer = ( itemID ) => {
    var data = {
        id: itemID
    };
    ajax( "/api/siemcollector", "observer", JSON.stringify( data ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal( "Observer", j.payload, "", "Close", "modal-fullscreen",
                ( success ) => {

                },
                ( cancel ) => {
                    document.getElementById( 'quitButton' ).click();
                }
            );
            jsonToTable( j.log );
            document.getElementById( 'counter' ).innerText = j.count;
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const doLogSearch = ( itemID ) => {
    var data = {
        id: itemID,
        search: document.getElementById( 'search' ).value,
        time: document.getElementById( 'timescope' ).options[ document.getElementById( 'timescope' ).selectedIndex ].value
    };
    document.getElementById( 'searchButton' ).innerHTML = '<sp id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"></sp>';
    document.getElementById( 'searchButton' ).setAttribute( "disabled", "true" );
    ajax( "/api/siemcollector", "search", JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            if ( j.log.length <= 2 ) {
                document.getElementById( 'jsonTable' ).innerHTML = "<center><br><br>nothing to show</center>";
                document.getElementById( 'counter' ).innerText = "0";
            } else {
                jsonToTable( j.log );
                document.getElementById( 'counter' ).innerText = j.count;
            }
            setTimeout( () => {
                document.getElementById( 'searchButton' ).innerHTML = "Search";
                document.getElementById( 'searchButton' ).removeAttribute( "disabled" );
            }, 1500 );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
            setTimeout( () => {
                document.getElementById( 'searchButton' ).innerHTML = "Search";
                document.getElementById( 'searchButton' ).removeAttribute( "disabled" );
            }, 1500 );
        }
    );
};

const add_SIEMRule = ( itemID ) => {
    if ( document.getElementById( "search" ).value.trim() == "" ) {
        showError( "Please enter a rule query" );
        return;
    }

    var action = "None";
    if ( document.getElementById( "action" ) != null ) {
        action = document.getElementById( "action" ).options[ document.getElementById( "action" ).selectedIndex ].value;
    }
    var event = document.getElementById( "event" ).options[ document.getElementById( "event" ).selectedIndex ].value;

    var data = {
        id: itemID,
        query: document.getElementById( "search" ).value,
        action: action,
        event: event
    };
    ajax( "/api/siemcollector", "add-rule", JSON.stringify( data ),
        ( success ) => {
            var j = JSON.parse( success );
            var node = document.createElement( "div" );
            node.innerHTML = j.payload;
            document.getElementById( "rulelist" ).appendChild( node );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const delete_SIEMRule = ( sender, itemID ) => {
    document.getElementById( "super-modal-back" ).style.display = "block";
    document.getElementById( "super-modal-text" ).innerText = "You are about to delete a rule, continue?";
    document.getElementById( "super-modal" ).style.top = "0px";
    document.getElementById( "smNOButton" ).focus();
    document.getElementById( "smOKButton" ).onclick = ( event ) => {
        if ( !event.shiftKey ) {
            if ( !_DELETE_CONFIRM_CODE ) {
                showError(
                    "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                );
                return;
            }
        }

        var el = sender.parentNode.parentNode.parentNode.querySelectorAll( ".query" )[ 0 ];
        var query = el.innerText;
        var el = sender.parentNode.parentNode.parentNode.querySelectorAll( ".event" )[ 0 ];
        var event = el.innerText;
        var el = sender.parentNode.parentNode.parentNode.querySelectorAll( ".action" )[ 0 ];
        var action = el.innerText;

        var data = {
            id: itemID,
            query: query,
            event: event,
            action: action
        };

        ajax( "/api/siemcollector", "delete-rule", JSON.stringify( data ),
            ( success ) => {
                var el = sender.parentNode.parentNode.parentNode;
                el.parentNode.removeChild( el );
            },
            ( error ) => {
                var j = JSON.parse( error );
                showError( j.message );
            }
        );

        window[ "editorchanged" ] = false;
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
    document.getElementById( "smNOButton" ).onclick = ( e ) => {
        document.getElementById( "super-modal-back" ).style.display = "none";
        document.getElementById( "super-modal" ).style.top = "-180px";
    };
};

const run_SIEMRule = ( sender ) => {
    var el = sender.parentNode.parentNode.parentNode.querySelectorAll( ".query" )[ 0 ];
    document.getElementById( 'search' ).value = el.innerText;
    document.getElementById( 'searchButton' ).click();
};

const open_PurgeSIEMCollector = ( itemID ) => {
    var data = {
        id: itemID
    };
    var delMessage = `<b>You are about to perform an <span style="color: red;">ireversable purge operation</span> which will delete all logs in the collector.</b><br><br>Do you want to continue?`;
    showModal( "Purge Collector", delMessage, "Purge", "Cancel", "",
        ( ok ) => {
            if ( !event.shiftKey ) {
                if ( !_DELETE_CONFIRM_CODE ) {
                    showError(
                        "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                    );
                    return;
                }
            }
            ajax( "/api/siemcollector", "purge", JSON.stringify( data ),
                ( success ) => {
                    var j = JSON.parse( success );
                    showSuccess( j.payload );
                    document.getElementById( "quitButton" ).click();
                    list( document.getElementById( "nav-title" ), false );
                },
                ( error ) => {
                    var j = JSON.parse( error );
                    showError( j.message );
                }
            );
        },
        ( cancel ) => {
            document.getElementById( "quitButton" ).click();
        }
    );
};

const run_PenTest = ( itemID ) => {
    var data = {
        id: itemID
    };
    ajax( "/api/securityscanner", "scan", JSON.stringify( data ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal( "Security Scanner", j.payload, "Run", "Cancel", "modal-xl",
                ( ok ) => {

                    var runner = `<center>
                                        <br><br>
                                        <b>Please wait while we complete the scan.</b>
                                        <br><br>
                                        <img src="/c/assets/img/network.gif" style="width: 150px" />
                                        <br><br>
                                        <i style="font-size: 0.85rem;">This operation may take a while. Please open a <a href="session" target="_blank">new window</a> if you want to continue to work.</i>
                                    </center>`;
                    document.getElementById( 'runner' ).innerHTML = runner;

                    document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );

                    ajax( "/api/securityscanner", "run", JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( 'runner' ).innerHTML = `<textarea readonly style="height: 100%; width: 100%; border: none; font-family: monospace; white-space: pre; overflow-wrap: normal; overflow-x: auto;">` + j.payload + `</textarea>`;
                            document.getElementById( "okButton" ).innerHTML = 'Run';
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );
                            document.getElementById( "okButton" ).innerHTML = 'Run';
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                        }
                    );
                },
                ( cancel ) => {
                    document.getElementById( 'quitButton' ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );

};

const add_Subnet = ( agID ) => {
    ajax( "/api/skynetwork", "subnet", JSON.stringify( { id: agID } ),
        ( success ) => {
            var j = JSON.parse( success );
            showModal( "Add Subnet", j.payload, "Add", "Cancel", "",
                ( ok ) => {
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }

                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );

                    var data = {
                        id: document.getElementById( 'id' ).value,
                        operator: document.getElementById( 'operator' ).value,
                        ip1: document.getElementById( 'ip1' ).value,
                        ip2: document.getElementById( 'ip2' ).value,
                        name: document.getElementById( 'name' ).value,
                        vlan: document.getElementById( 'vlan' ).value
                    };

                    ajax( "/api/skynetwork", "add-subnet", JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            var j = JSON.parse( error );
                            showError( j.message );

                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                "Add";
                        }
                    );
                },
                ( cancel ) => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const remove_Subnet = ( _id, _operator ) => {
    ajax(
        "/api/skynetwork",
        "remove",
        JSON.stringify( { id: _id, operator: _operator } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Save";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Remove Subnet",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }

                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/skynetwork",
                        "remove-subnet",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const join_Subnet = ( _id, _operator ) => {
    ajax(
        "/api/skynetwork",
        "join",
        JSON.stringify( { id: _id, operator: _operator } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Join";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Join",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/skynetwork",
                        "join-member",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const leave_Subnet = ( _id, _operator ) => {
    ajax(
        "/api/skynetwork",
        "leave",
        JSON.stringify( { id: _id, operator: _operator } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            var okCaption = "Leave";
            var cancelCaption = "Cancel";
            if ( j.okCaption != undefined ) {
                okCaption = j.okCaption;
            }
            showModal(
                "Member Leave",
                j.payload,
                okCaption,
                cancelCaption,
                "",
                () => {
                    //save
                    if ( !event.shiftKey ) {
                        if ( !_DELETE_CONFIRM_CODE ) {
                            showError(
                                "Ireversable Operation Protection! Please hold the shift key to confirm this operation."
                            );
                            return;
                        }
                    }

                    var form = document.getElementById( "docform" );
                    form.classList.add( "was-validated" );
                    if ( !form.checkValidity() ) {
                        return;
                    }
                    document.getElementById( "okButton" ).innerHTML =
                        '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document
                        .getElementById( "cancelButton" )
                        .setAttribute( "disabled", "yes" );
                    document
                        .getElementById( "okButton" )
                        .setAttribute( "disabled", "yes" );
                    var data = saveData( "" );
                    if ( data == "ERR" ) {
                        document
                            .getElementById( "cancelButton" )
                            .removeAttribute( "disabled" );
                        document
                            .getElementById( "okButton" )
                            .removeAttribute( "disabled" );
                        document.getElementById( "okButton" ).innerHTML =
                            okCaption;
                        return;
                    }
                    ajax(
                        "/api/skynetwork",
                        "leave-member",
                        JSON.stringify( data ),
                        ( success ) => {
                            var j = JSON.parse( success );
                            document.getElementById( "quitButton" ).click();
                            list( document.getElementById( "nav-title" ), false );
                            setTimeout( () => {
                                showSuccess( j.payload );
                            }, 500 );
                        },
                        ( error ) => {
                            document
                                .getElementById( "cancelButton" )
                                .removeAttribute( "disabled" );
                            document
                                .getElementById( "okButton" )
                                .removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML =
                                okCaption;
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const provision_Item = () => {
    ajax(
        "/api/start",
        "provision",
        '',
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal(
                "Provision",
                j.payload,
                j.okCaption,
                "Cancel",
                "",
                () => { },
                () => {
                    //cancel
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};

const start_IngeniaChat = ( id ) => {
    const chatWindow = document.getElementById( "chat-window" );
    const inputField = document.getElementById( "chat-question" );
    chatWindow.setAttribute( "chatid", id );
    chatWindow.style.display = "flex";
    inputField.focus();
};

const customize_Ingenia = ( _id ) => {
    ajax( "/api/ingeniallm", "customize", JSON.stringify( { id: _id } ),
        ( dialog ) => {
            var j = JSON.parse( dialog );
            showModal( "Prompt Injection", j.payload, "Build", "Cancel", "modal-xl",
                ( ok ) => {
                    var data = {
                        id: _id,
                        prompt: document.getElementById( "prompt" ).value
                    };
                    document.getElementById( "okButton" ).innerHTML = '<center><div id="spinner" class="spinner-border" role="status" style="width: 16px; height: 16px;"><center>';
                    document.getElementById( "cancelButton" ).setAttribute( "disabled", "yes" );
                    document.getElementById( "okButton" ).setAttribute( "disabled", "yes" );
                    ajax( "/api/ingeniallm", "train-model", JSON.stringify( data ),
                        ( success ) => {
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML = "Build";
                            document.getElementById( "quitButton" ).click();
                            var j = JSON.parse( success );
                            showSuccess( j.payload );
                        },
                        ( error ) => {
                            document.getElementById( "cancelButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).removeAttribute( "disabled" );
                            document.getElementById( "okButton" ).innerHTML = "Build";
                            var j = JSON.parse( error );
                            showError( j.message );
                        }
                    );
                },
                ( cancel ) => {
                    document.getElementById( "quitButton" ).click();
                }
            );
        },
        ( error ) => {
            var j = JSON.parse( error );
            showError( j.message );
        }
    );
};