var _USER = "";
var _PASS = "";
var _URL = "";
var _CONNECTED = false;

if ( _CONNECTED ) {
    document.getElementById( 'vistas' ).style.display = "block";
}

/// AJAX
const ajax = (
    url,
    command,
    data = null,
    success = null,
    error = null,
    progress = null,
    formData = null
) => {
    var x = new XMLHttpRequest();
    x.onreadystatechange = function () {
        if ( x.readyState == 4 && x.status == 200 ) {
            if ( success != null ) {
                success( x.responseText );
            }
        } else if ( x.readyState == 4 && x.status == 210 ) {
            if ( error != null ) {
                error( x.responseText );
            }
        } else if ( x.readyState == 4 && x.status == 505 ) {
            if ( error != null ) {
                error( x.responseText );
            }
        }
    };
    x.upload.onload = () => { };
    x.upload.onerror = () => {
        try {
            document.getElementById( 'loginButton' ).removeAttribute( 'disabled' );
            document.getElementById( 'gate' ).removeAttribute( 'disabled' );
            document.getElementById( 'email' ).removeAttribute( 'disabled' );
            document.getElementById( 'pass' ).removeAttribute( 'disabled' );
            document.getElementById( 'loginButton' ).style.cursor = 'default';
            document.getElementById( 'gate' ).style.cursor = 'default';
            document.getElementById( 'email' ).style.cursor = 'default';
            document.getElementById( 'pass' ).style.cursor = 'default';
            document.body.style.cursor = 'default';
            document.getElementById( 'message2' ).innerHTML = "<span style='color: red'>Cloud not connect to access gate</span>";
        } catch { }
    };
    x.upload.onabort = () => { };
    x.upload.onprogress = ( event ) => {
        if ( event.lengthComputable ) {
            var percentComplete = parseInt( ( event.loaded / event.total ) * 100 );
            if ( progress != null ) {
                progress( event.total, event.loaded, percentComplete );
            }
        }
    };
    x.open( "POST", url, true );
    if ( formData != null ) {
        x.send( formData );
    } else {
        document.getElementById( "loginButton" ).setAttribute( "disabled", "true" );
        x.setRequestHeader( "X-API-COMMAND", command );
        x.setRequestHeader( "Content-Type", "application/json; charset=UTF-8;" );
        x.send( data );
    }
};

/// WINDOW LOAD
window.onload = ( e ) => {
    document.getElementById( 'loginButton' ).addEventListener( 'click', () => {
        doLogin();
    } );

    window.electronAPI.sendPing( "load_default" );

    window.electronAPI.onPong( ( data ) => {
        if ( data.startsWith( "tunnel:" ) ) {
            document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: orange'>" + data.replace( "tunnel:", "" ) + "</span>";
        } else {
            document.getElementById( 'gate' ).value = data.split( "\n" )[ 0 ].replace( "/vista", "" ).replace( "https://", "" );
            document.getElementById( 'email' ).value = data.split( "\n" )[ 1 ];
        }
    } );

    document.getElementById( 'pass' ).addEventListener( 'keyup', function ( event ) {
        if ( event.which == 13 ) {
            doLogin();
        }
        event.preventDefault();
    } );

    document.getElementById( 'email' ).addEventListener( 'keyup', function ( event ) {
        if ( event.which == 13 ) {
            doLogin();
        }
        event.preventDefault();
    } );

    document.getElementById( 'gate' ).addEventListener( 'keyup', function ( event ) {
        if ( event.which == 13 ) {
            doLogin();
        }
        event.preventDefault();
    } );

    ///

    document.getElementById( 'close' ).addEventListener( 'click', () => {
        window.close();
    } );

    document.getElementById( 'gate' ).onkeydown = checkLogin;
    document.getElementById( 'email' ).onkeydown = checkLogin;
    document.getElementById( 'pass' ).onkeydown = checkLogin;

    setTimeout( () => {
        if ( document.getElementById( 'gate' ).value == "" ) {
            document.getElementById( 'gate' ).focus();
        } else {
            document.getElementById( 'pass' ).focus();
        }
    }, 500 );

    const chatWindow = document.getElementById( "chat-window" );
    const chatHeader = document.getElementById( "chat-header" );

    let offsetX = 0, offsetY = 0, isDragging = false;

    chatHeader.addEventListener( "mousedown", function ( e ) {
        isDragging = true;
        offsetX = e.clientX - chatWindow.offsetLeft;
        offsetY = e.clientY - chatWindow.offsetTop;
        document.body.style.userSelect = 'none';
    } );

    document.addEventListener( "mouseup", function () {
        isDragging = false;
        document.body.style.userSelect = 'auto';
    } );

    document.addEventListener( "mousemove", function ( e ) {
        if ( isDragging ) {
            chatWindow.style.left = `${e.clientX - offsetX}px`;
            chatWindow.style.top = `${e.clientY - offsetY}px`;
            chatWindow.style.bottom = 'auto';
            chatWindow.style.right = 'auto';
        }
    } );

    // Resizing
    const resizer = document.getElementById( "chat-resizer" );
    let isResizing = false;

    resizer.addEventListener( "mousedown", function ( e ) {
        isResizing = true;
        e.preventDefault();
        document.body.style.userSelect = 'none';
    } );

    document.addEventListener( "mouseup", function () {
        isResizing = false;
        document.body.style.userSelect = 'auto';
    } );

    document.addEventListener( "mousemove", function ( e ) {
        if ( isResizing ) {
            const newWidth = e.clientX - chatWindow.offsetLeft;
            const newHeight = e.clientY - chatWindow.offsetTop;
            chatWindow.style.width = `${newWidth}px`;
            chatWindow.style.height = `${newHeight}px`;
        }
    } );

    document.getElementById( "chat-close" ).addEventListener( "click", function () {
        chatWindow.style.display = "none";
    } );

    // Input & Send Button
    const inputField = document.getElementById( "chat-question" );
    const sendButton = document.getElementById( "chat-send" );
    const chatBody = document.getElementById( "chat-body" );

    function extractChatMessages () {
        const chatBody = document.getElementById( "chat-body" );
        const messages = [];

        // Get all message elements
        const nodes = chatBody.querySelectorAll( ".message" );

        nodes.forEach( node => {
            // Skip typing indicator or other temporary elements
            if ( node.classList.contains( "typing-indicator" ) ) return;

            let role = "user";
            if ( node.classList.contains( "bot" ) ) {
                role = "assistant";
            }

            let text = node.cloneNode( true );

            messages.push( {
                role: role,
                content: text.textContent.trim()
            } );
        } );

        return messages;
    }

    function createBotMessage ( text ) {
        const container = document.createElement( "div" );
        container.className = "message bot";
        container.innerHTML = text;

        // const copyBtn = document.createElement( "button" );
        // copyBtn.className = "copy-btn";
        // copyBtn.title = "Copy to Clipboard";
        // copyBtn.textContent = "📋"; // Or use "Copy"

        // copyBtn.addEventListener( "click", ( e ) => {
        //     e.stopPropagation();
        //     navigator.clipboard.writeText( container.innerText ).then( () => {
        //         copyBtn.textContent = "✅";
        //         setTimeout( () => ( copyBtn.textContent = "📋" ), 1000 );
        //     } );
        // } );

        //container.appendChild( copyBtn );

        chatBody.appendChild( container );
        chatBody.scrollTop = chatBody.scrollHeight;
    }

    function showTypingIndicator () {
        const typing = document.createElement( "div" );
        typing.className = "message bot typing-indicator";
        typing.innerHTML = `<div class="typing"><em style="font-size: 0.8rem;">thinking</em><span>.</span><span>.</span><span>.</span></div>`;
        chatBody.appendChild( typing );
        chatBody.scrollTop = chatBody.scrollHeight;
        return typing;
    }

    function wrapMarkdownTablesInPre ( text ) {
        const lines = text.split( '\n' );
        const output = [];
        let currentTable = [];
        let inTable = false;

        for ( let i = 0; i < lines.length; i++ ) {
            const line = lines[ i ];

            const isTableLine = /^\s*\|.*\|\s*$/.test( line );
            const isSeparatorLine = /^\s*\|?\s*:?-+:?\s*(\|\s*:?-+:?\s*)+\|?\s*$/.test( line );

            if ( isTableLine || ( inTable && line.trim() === '' ) ) {
                currentTable.push( line );
                inTable = true;
            } else if ( inTable ) {
                // Output the pre block for table
                output.push( '<pre><code>' + currentTable.join( '\n' ) + '</code></pre>' );
                currentTable = [];
                inTable = false;
                output.push( line );
            } else {
                output.push( line );
            }
        }

        // Final table
        if ( currentTable.length > 0 ) {
            output.push( '<pre><code>' + currentTable.join( '\n' ) + '</code></pre>' );
        }

        return output.join( '\n' );
    }

    function formatCodeBlocksAndParagraphs ( text ) {
        const parts = [];
        const regex = /```(\w+)?\n([\s\S]*?)```/g;

        let lastIndex = 0;
        let match;

        var c = 0;
        while ( ( match = regex.exec( text ) ) !== null ) {
            const [ fullMatch, lang, code ] = match;
            const beforeCode = text.slice( lastIndex, match.index ).trim();

            if ( beforeCode ) {
                c = c + 1;
                // Convert plain text to paragraphs
                const paragraphs = beforeCode
                    .split( /\n+/ )
                    .map( p => `<p>${p.trim()}</p>` )
                    .join( '\n' );
                parts.push( paragraphs );
            }

            // Convert code block
            parts.push(
                `<div title="Copy Code" class="codecopy" style="float: right; position: relative;" onclick="copyText(document.getElementById('c` + c + `'));">⧉</div><pre id="c` + c + `"><code>${escapeHtml( code.trim() )}</code></pre>`
            );

            lastIndex = match.index + fullMatch.length;
        }

        // Handle remaining text after last code block
        const remainingText = text.slice( lastIndex ).trim();
        if ( remainingText ) {
            const paragraphs = remainingText
                .split( /\n+/ )
                .map( p => `<p>${escapeHtml( p.trim() )}</p>` )
                .join( '\n' );
            parts.push( paragraphs );
        }

        return parts.join( '\n' );
    }

    function convertMarkdownLinksToAnchors ( text ) {
        const markdownLinkRegex = /\[([^\]]+)]\((https?:\/\/[^\s)]+)\)/g;
        return text.replace( markdownLinkRegex, '<a href="$2" target="_blank" rel="noopener noreferrer">$1</a>' );
    }

    function formatCodeBlocks ( text ) {
        return text.replace( /```(\w+)?\n([\s\S]*?)```/g, ( match, lang, code ) => {
            return `<pre><code>${escapeHtml( code )}</code></pre>`;
        } );
    }

    // Optional: Escape HTML special characters inside code blocks
    function escapeHtml ( str ) {
        return str
            .replace( /&/g, '&amp;' )
            .replace( /</g, '&lt;' )
            .replace( />/g, '&gt;' );
    }

    function sendMessage () {
        const msg = inputField.value.trim();
        if ( chatBody.querySelectorAll( ".typing-indicator" ).length != 0 ) {
            showError( "Ingenia is thinking" );
            return;
        }
        if ( msg ) {
            const msgElement = document.createElement( "div" );
            msgElement.className = "message user";
            msgElement.textContent = msg;
            chatBody.appendChild( msgElement );
            chatBody.scrollTop = chatBody.scrollHeight;
            inputField.value = "";

            let typingIndicator = showTypingIndicator();
            let _messages = extractChatMessages();
            var data = {
                id: document.getElementById( "chat-window" ).getAttribute( "chatid" ),
                email: document.getElementById( 'email' ).value,
                username: _USER,
                password: _PASS,
                messages: _messages,
                prompt: msg
            };
            ajax( _URL, "interact", JSON.stringify( data ),
                ( success ) => {
                    chatBody.removeChild( typingIndicator );
                    try {
                        var j = JSON.parse( success );
                        var msg = JSON.parse( j.payload );
                        msg.response = msg.response.replace( /<think>[\s\S]*?<\/think>/g, '' );
                        createBotMessage( wrapMarkdownTablesInPre( convertMarkdownLinksToAnchors( formatCodeBlocksAndParagraphs( msg.response ) ) ) );
                    } catch {
                        try {
                            var j = JSON.parse( success );
                            var msg = JSON.parse( j.payload );
                            createBotMessage( "Oh no, something went wrong: " + formatCodeBlocksAndParagraphs( msg.error ) );
                        } catch {
                            //normal message
                            var j = JSON.parse( success );
                            if ( j.message == undefined ) {
                                showSuccess( j.payload );
                                createBotMessage( "Task reported success: " + formatCodeBlocksAndParagraphs( j.payload.trim() ) );
                            } else {
                                showSuccess( j.payload );
                                createBotMessage( "Task reported error: " + formatCodeBlocksAndParagraphs( j.message.trim() ) );
                            }
                        }
                    }
                },
                ( error ) => {
                    chatBody.removeChild( typingIndicator );
                    var j = JSON.parse( error );
                    document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: red'>" + j.message + "</span>";
                }
            );
        }
    }

    document.getElementById( "clear-chat" ).addEventListener( "click", () => {
        const chatBody = document.getElementById( "chat-body" );
        chatBody.innerHTML = ""; // Clear all messages
        //Optionally scroll to top or show a placeholder
        chatBody.innerHTML = "<p><em><b>Welcome! I am Ingenia, what can I help you with?</b></em></p>";
    } );

    sendButton.addEventListener( "click", sendMessage );
    inputField.addEventListener( "keydown", function ( e ) {
        if ( e.key === "Enter" && !e.shiftKey ) {
            e.preventDefault(); // prevent newline
            sendMessage(); // submit message
        }
        // Ctrl+Enter or Shift+Enter will insert a newline automatically
    } );
};


/// FUNCTIONS
const checkLogin = () => {
    if ( document.getElementById( 'gate' ).value.trim() != "" &&
        document.getElementById( 'email' ).value.trim() != "" &&
        document.getElementById( 'pass' ).value.trim() != "" ) {
        document.getElementById( 'loginButton' ).removeAttribute( 'disabled' );
    } else {
        document.getElementById( 'loginButton' ).setAttribute( 'disabled', 'true' );
    }
};

const doLogin = () => {
    if ( document.getElementById( 'loginButton' ).hasAttribute( "disabled" ) ) {
        return;
    }

    document.getElementById( 'message2' ).innerHTML = "<span style='color: black'>connecting, please wait...</span>";

    document.getElementById( 'loginButton' ).setAttribute( 'disabled', 'true' );
    document.getElementById( 'gate' ).setAttribute( 'disabled', 'true' );
    document.getElementById( 'email' ).setAttribute( 'disabled', 'true' );
    document.getElementById( 'pass' ).setAttribute( 'disabled', 'true' );
    document.getElementById( 'loginButton' ).style.cursor = 'wait';
    document.getElementById( 'gate' ).style.cursor = 'wait';
    document.getElementById( 'email' ).style.cursor = 'wait';
    document.getElementById( 'pass' ).style.cursor = 'wait';
    document.body.style.cursor = 'wait';

    _URL = document.getElementById( 'gate' ).value;
    if ( !_URL.startsWith( "http" ) ) {
        _URL = "https://" + _URL;
    }
    _URL = _URL + "/vista";

    var data = {
        username: document.getElementById( 'email' ).value,
        password: document.getElementById( 'pass' ).value
    };

    ajax( _URL, "login", JSON.stringify( data ),
        ( success ) => {
            document.getElementById( 'loginButton' ).removeAttribute( 'disabled' );
            document.getElementById( 'gate' ).removeAttribute( 'disabled' );
            document.getElementById( 'email' ).removeAttribute( 'disabled' );
            document.getElementById( 'pass' ).removeAttribute( 'disabled' );
            document.getElementById( 'loginButton' ).style.cursor = 'default';
            document.getElementById( 'gate' ).style.cursor = 'default';
            document.getElementById( 'email' ).style.cursor = 'default';
            document.getElementById( 'pass' ).style.cursor = 'default';
            document.body.style.cursor = 'default';
            _USER = data.username;
            _PASS = data.password;
            _CONNECTED = true;
            document.getElementById( 'vistas' ).style.display = "block";
            window.electronAPI.sendPing( "save_default|" + _URL + "|" + _USER );
            if ( success.trim() != "" ) {
                //we have vistas
                var vistaItem = "<div onclick='launch(this);' class='vista' id='{ID}' data='{ROW}'><center><img src='{IMG}' style='width:100%;'><br><span style='font-size: 13px;'><b>{NAME}</b></span></center></div>";
                var vistas = "";
                success.split( "\n" ).forEach( function ( line ) {
                    if ( line.trim() != "" ) {
                        var img = "app.png";
                        if ( line.split( '|' )[ 3 ] == "vnc" || line.split( '|' )[ 3 ] == "xvnc" || line.split( '|' )[ 3 ] == "vistapool-xvnc" ) {
                            img = 'vnc.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "spice" || line.split( '|' )[ 3 ] == "vistapool-spice" ) {
                            img = 'spice.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "http" || line.split( '|' )[ 3 ] == "https" ) {
                            img = 'http.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "ssh" ) {
                            img = 'ssh.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "llm" ) {
                            img = 'llm.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "rdp" || line.split( '|' )[ 3 ] == "vistapool-rdp" ) {
                            img = 'rdp.png';
                        }
                        else if ( line.split( '|' )[ 3 ] == "locked" ) {
                            img = 'locked.png';
                        }
                        vistas = vistas + vistaItem.replace( "{ID}", line.split( '|' )[ 1 ] ).replace( "{NAME}", line.split( '|' )[ 0 ] ).replace( "{ROW}", line.trim() ).replace( "{IMG}", img );
                    }

                } );
                document.getElementById( 'vistas' ).innerHTML = vistas;
            } else {
                document.getElementById( 'vistas' ).innerHTML = "<center style='color: black'><br><br><br>No Vista Sessions found</center>";
            }
        },
        ( error ) => {
            document.getElementById( 'loginButton' ).removeAttribute( 'disabled' );
            document.getElementById( 'gate' ).removeAttribute( 'disabled' );
            document.getElementById( 'email' ).removeAttribute( 'disabled' );
            document.getElementById( 'pass' ).removeAttribute( 'disabled' );
            document.getElementById( 'loginButton' ).style.cursor = 'default';
            document.getElementById( 'gate' ).style.cursor = 'default';
            document.getElementById( 'email' ).style.cursor = 'default';
            document.getElementById( 'pass' ).style.cursor = 'default';
            document.body.style.cursor = 'default';
            document.getElementById( 'message2' ).innerHTML = "<span style='color: red'>" + error + "</span>";
        }
    );
};

const copyText = ( sender, value = "" ) => {
    var text = "";
    if ( value == "" ) {
        text = sender.innerText;
    } else {
        text = value;
    }
    if ( navigator.clipboard && window.isSecureContext ) {
        return navigator.clipboard.writeText( text );
    } else {
        let textArea = document.createElement( "textarea" );
        textArea.value = text;
        textArea.style.position = "fixed";
        textArea.style.left = "-999999px";
        textArea.style.top = "-999999px";
        document.body.appendChild( textArea );
        textArea.focus();
        textArea.select();
        return new Promise( ( res, rej ) => {
            document.execCommand( "copy" ) ? res() : rej();
            textArea.remove();
        } );
    }
};

const launch = ( sender ) => {
    document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: lime'>Connecting please wait...</span>";
    var data = sender.getAttribute( 'data' );
    if ( _CONNECTED ) {
        var jData = {
            id: "v" + data.split( '|' )[ 1 ].toLowerCase().substring( 0, 20 ),
            protocol: data.split( '|' )[ 3 ],
            username: _USER,
            password: _PASS,
            instance: data.split( '|' )[ 4 ],
            port: data.split( '|' )[ 5 ],
            operator: data.split( '|' )[ 6 ],
            fullid: data.split( '|' )[ 1 ]
        };
        if ( data.split( '|' )[ 3 ] == "llm" ) {
            var chatWindow = document.getElementById( "chat-window" );
            const inputField = document.getElementById( "chat-question" );
            chatWindow.setAttribute( "chatid", data.split( '|' )[ 4 ] );
            chatWindow.style.display = "flex";
            inputField.focus();
            document.getElementById( 'message1' ).innerHTML = "";
        } else {
            ajax( _URL, "instance", JSON.stringify( jData ),
                ( success ) => {
                    if ( success.indexOf( "Error: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: #FF4433'>" + success.replace( "Error: ", "" ) + "</span>";
                    }
                    else if ( success.indexOf( "Info: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: lime'>" + success.replace( "Info: ", "" ) + "</span>";
                    }
                    else if ( success.indexOf( "Warning: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: yellow'>" + success.replace( "Warning: ", "" ) + "</span>";
                    }
                    else {
                        var secPW = success.split( '|' )[ 0 ];
                        var ip = success.split( '|' )[ 1 ];
                        var spicePort = data.split( '|' )[ 5 ];
                        var accessPort = "2318";
                        if ( data.split( '|' )[ 3 ] == "vistapool-xvnc" ||
                            data.split( '|' )[ 3 ] == "vistapool-spice" ||
                            data.split( '|' )[ 3 ] == "spice" ||
                            data.split( '|' )[ 3 ] == "xvnc" ) {
                            try {
                                spicePort = success.split( '|' )[ 2 ];
                            } catch { }
                        } else if ( data.split( '|' )[ 3 ] == "vnc" ) {
                            spicePort = "5900";
                        }
                        var randomPort = Math.floor( Math.random() * ( 64000 - 40000 + 1 ) ) + 40000;
                        var destIP = _URL.replace( "/vista", "" ).replace( "https://", "" );
                        var launchInfo = {
                            id: data.split( '|' )[ 1 ],
                            sshuser: "v" + data.split( '|' )[ 1 ].toLowerCase().substring( 0, 20 ),
                            user: _USER.substring( 0, _USER.indexOf( "@" ) ),
                            secret: secPW,
                            random: randomPort,
                            destip: ip,
                            accessip: destIP,
                            accessport: accessPort,
                            spiceport: spicePort,
                            protocol: data.split( '|' )[ 3 ]
                        };
                        window.electronAPI.sendPing( "launch|" + JSON.stringify( launchInfo ) );
                        document.getElementById( 'message1' ).innerHTML = "";
                    }
                },
                ( error ) => {
                    if ( error.indexOf( "Error: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: #FF4433'>" + error.replace( "Error: ", "" ) + "</span>";
                    }
                    else if ( error.indexOf( "Info: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: lime'>" + error.replace( "Info: ", "" ) + "</span>";
                    }
                    else if ( error.indexOf( "Warning: " ) != -1 ) {
                        document.getElementById( 'message1' ).innerHTML = "<br>&nbsp;<span style='color: yellow'>" + error.replace( "Warning: ", "" ) + "</span>";
                    }
                }
            );
        }
    };
};