const { app, BrowserWindow, session, Tray, Menu, Notification, screen, ipcMain, shell } = require( 'electron' );
const { exec } = require( 'child_process' );
const tunnel = require( 'tunnel-ssh' );
const fs = require( "fs" );
const os = require( "os" );

process.env.NODE_TLS_REJECT_UNAUTHORIZED = 0;
console.error = () => { };
console.warn = () => { };

const isMac = os.platform() === "darwin";
const isWindows = os.platform() === "win32";
const isLinux = os.platform() === "linux";

process.on( "unhandledRejection", ( error ) => {
    //console.warn( ">>> REJ-ERROR | " + error + " => " + error.stack );
} );

process.on( "uncaughtException", ( error ) => {
    //logger.log( error.stack.toString() );
} );

let tray = null;
let win = null;
let canClose = false;
let notificationShown = false;
let connections = [];

function showNotification ( text ) {
    new Notification( {
        title: "Vista Connect",
        body: text,
        icon: __dirname + '/app.png',
        tag: 'xcware-Vista-Notification'
    } ).show();
}

//events
ipcMain.on( 'ping', async ( event, message ) => {

    //receive
    if ( message.startsWith( 'save_default' ) ) {
        var settings = message.split( "|" )[ 1 ] + "\n" + message.split( "|" )[ 2 ];
        fs.writeFileSync( "./settings.conf", settings );
        tray.setToolTip( "Vista Connect (" + message.split( "|" )[ 1 ].replace( "/vista", "" ).replace( "https://", "" ) + ")" );
    }
    else if ( message.startsWith( "launch|" ) ) {
        var data = JSON.parse( message.replace( "launch|", "" ) );
        try {
            connections.forEach( function ( item ) {
                if ( item.id == data.id ) {
                    delete item;
                    throw "exit";
                }
            } );
        } catch { }
        try {
            const tunnelOptions = {
                autoClose: false
            };

            const sshOptions = {
                host: data.accessip,
                port: data.accessport,
                username: data.sshuser,
                password: data.secret
            };

            const serverOptions = {
                host: '127.0.0.1',
                port: parseInt( data.random )
            };

            const forwardOptions = {
                srcAddr: '127.0.0.1',
                srcPort: parseInt( data.random ),
                dstAddr: data.destip,
                dstPort: data.spiceport
            };


            await tunnel.createTunnel( tunnelOptions, serverOptions, sshOptions, forwardOptions ).then(
                ( [ server, conn ], error ) => {

                    if ( error ) {
                        event.reply( 'pong', "tunnel: Error - " + error.toString() );
                        return;
                    }

                    server.on( 'error', ( e ) => {
                        event.reply( 'pong', "tunnel: Server - " + e.toString() );
                        return;
                    } );

                    conn.on( 'error', ( e ) => {
                        event.reply( 'pong', "tunnel: Tunnel - " + e.toString() );
                        return;
                    } );

                } );

            if ( data.protocol == "rdp" || data.protocol == "vistapool-rdp" ) {
                if ( isWindows ) {
                    exec( "C:/Windows/System32/mstsc.exe /multimon /v:" + "127.0.0.1:" + parseInt( data.random ) );
                } else if ( isLinux ) {
                    exec( "/usr/bin/xfreerdp /multimon /v:" + "127.0.0.1:" + parseInt( data.random ) );
                } else if ( isMac ) {
                    exec( "/opt/homebrew/bin/xfreerdp /multimon /v:" + "127.0.0.1:" + parseInt( data.random ) );
                }
            }

            else if ( data.protocol == "vnc" || data.protocol == "xvnc" || data.protocol == "vistapool-xvnc" ) {
                if ( isWindows ) {
                    exec( '"' + __dirname + '/vnc.exe"' + " 127.0.0.1:" + parseInt( data.random ) );
                } else if ( isLinux ) {
                    exec( '/usr/bin/vncviewer' + " 127.0.0.1:" + parseInt( data.random ) );
                } else if ( isMac ) {
                    event.reply( 'pong', "tunnel: This protocol is currently not supported" );
                }
            }

            else if ( data.protocol == "spice" || data.protocol == "vistapool-spice" ) {
                if ( isWindows ) {
                    exec( '"C:/Program Files/VirtViewer v11.0-256/bin/remote-viewer.exe" spice://127.0.0.1:' + parseInt( data.random ) );
                } else if ( isLinux ) {
                    exec( '/usr/bin/virt-viewer spice://127.0.0.1:' + parseInt( data.random ) );
                } else if ( isMac ) {
                    event.reply( 'pong', "tunnel: This protocol is currently not supported" );
                }
            }

            else if ( data.protocol == "ssh" ) {
                if ( isWindows ) {
                    exec( '"' + __dirname + '/ssh.exe"' + " " + data.user + "@127.0.0.1 -P " + parseInt( data.random ) );
                } else if ( isLinux ) {
                    exec( "xterm -e ssh " + data.user + "@127.0.0.1 -p " + parseInt( data.random ) );
                } else if ( isMac ) {
                    event.reply( 'pong', "tunnel: This protocol is currently not supported" );
                }
            }

            else if ( data.protocol == "http" ) {
                shell.openExternal( "http://127.0.0.1:" + parseInt( data.random ) );
            }

            else if ( data.protocol == "https" ) {
                shell.openExternal( "https://127.0.0.1:" + parseInt( data.random ) );
            }

            else if ( data.protocol == "custom" ) {
                event.reply( 'pong', "tunnel: Tunnel is now active on port 127.0.0.1:" + parseInt( data.random ) );
            }


        } catch ( err ) {
            event.reply( 'pong', "tunnel:" + err.toString() );
        }
    }

    //return
    if ( message.startsWith( 'load_default' ) ) {
        if ( fs.existsSync( "./settings.conf" ) ) {
            var tmp = fs.readFileSync( './settings.conf' );
            event.reply( 'pong', tmp.toString() );
        }
    }

} );

//app
app.whenReady().then( () => {
    try {
        session.defaultSession.clearStorageData();
    } catch { }

    win = new BrowserWindow( {
        show: false,
        backgroundColor: '#fff',
        frame: false,
        titleBarStyle: 'hidden',
        webPreferences: {
            preload: __dirname + '/preload.js',
            nodeIntegration: true,
            contextIsolation: true
        }
    } );

    const { width, height } = screen.getPrimaryDisplay().workAreaSize;
    win.setSize( width - 200, height - 200, false );
    win.center();
    win.setMenuBarVisibility( false );
    win.loadFile( "vista.html" );
    win.show();
    win.focus();

    tray = new Tray( __dirname + "/app.png" );

    const contextMenu = Menu.buildFromTemplate( [
        { label: 'Show Vista Connect', click: () => { win.show(); } },
        { type: 'separator' },
        { label: 'Quit Vista Connect', click: () => { canClose = true; app.quit(); } }
    ] );

    tray.setToolTip( 'Vista Connect' );
    tray.setContextMenu( contextMenu );

    tray.on( 'double-click', () => {
        win.show();
    } );

    win.on( 'close', ( e ) => {
        if ( !canClose ) {
            //prevent close
            e.preventDefault();
            win.hide();
            if ( !notificationShown ) {
                showNotification( "Vista Connect is now running in the System Tray. Right-click the tray icon to access the menu options." );
                notificationShown = true;
            }
        } else {
            //clean up sessions
            showNotification( "Vista Connect has disconnected all active sessions and closed." );
        }
    } );

    win.webContents.setWindowOpenHandler( ( { url } ) => {
        shell.openExternal( url );
        return { action: 'deny' };
    } );

    session.defaultSession.webRequest.onBeforeSendHeaders( ( details, callback ) => {
        details.requestHeaders[ 'User-Agent' ] = 'xcware-Vista';
        callback( { cancel: false, requestHeaders: details.requestHeaders } );
    } );

} );

app.on( 'window-all-closed', () => {
    if ( process.platform !== 'darwin' ) {
        app.quit();
    }
} );

app.on( 'certificate-error', ( event, webContents, url, error, certificate, callback ) => {
    callback( true );
    event.preventDefault();
} );